/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.client.StreamDataSetDescriptor;
import edu.uiowa.physics.pw.das.components.HorizontalSpectrogramSlicer;
import edu.uiowa.physics.pw.das.components.VerticalSpectrogramSlicer;
import edu.uiowa.physics.pw.das.components.propertyeditor.Enumeration;
import edu.uiowa.physics.pw.das.dataset.AveragePeakTableRebinner;
import edu.uiowa.physics.pw.das.dataset.ConstantDataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetRebinner;
import edu.uiowa.physics.pw.das.dataset.DataSetUpdateEvent;
import edu.uiowa.physics.pw.das.dataset.DataSetUpdateListener;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.NearestNeighborTableRebinner;
import edu.uiowa.physics.pw.das.dataset.RebinDescriptor;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.LocationUnits;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.event.HorizontalSlicerMouseModule;
import edu.uiowa.physics.pw.das.event.VerticalSlicerMouseModule;
import edu.uiowa.physics.pw.das.graph.AttachedColumn;
import edu.uiowa.physics.pw.das.graph.AttachedRow;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasLabelAxis;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.DasZAxisPlot;
import edu.uiowa.physics.pw.das.stream.PacketDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamYScanDescriptor;
import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.Icon;
import javax.swing.JFileChooser;

public class DasStackedHistogramPlot
extends DasPlot
implements DasZAxisPlot,
DataSetUpdateListener {
    private ZAxisComponent zAxisComponent = null;
    private RebinDescriptor xBins = null;
    private DasCanvas parent;
    private PeaksIndicator peaksIndicator;
    private boolean dumpDataSet;
    private boolean sliceRebinnedData;

    public static DasStackedHistogramPlot create(DasCanvas dasCanvas, TableDataSet tableDataSet) {
        DasRow dasRow = new DasRow(dasCanvas, 0.05, 0.85);
        DasColumn dasColumn = new DasColumn(dasCanvas, 0.15, 0.9);
        int n = tableDataSet.getXLength();
        int n2 = tableDataSet.getYLength(0);
        double[] dArray = new double[n];
        int n3 = 0;
        while (n3 < n) {
            dArray[n3] = tableDataSet.getXTagDouble(n3, tableDataSet.getXUnits());
            ++n3;
        }
        double[] dArray2 = new double[n * n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            int n6 = 0;
            while (n6 < n2) {
                dArray2[n4++] = tableDataSet.getDouble(n5, n6, tableDataSet.getZUnits());
                ++n6;
            }
            ++n5;
        }
        DasAxis dasAxis = DasAxis.create(dArray2, tableDataSet.getZUnits(), 4, true);
        dasAxis.setRow(new AttachedRow(dasRow, 0.0, 0.6));
        dasAxis.setColumn(new AttachedColumn(dasColumn, 1.05, 1.1));
        DasAxis dasAxis2 = DasAxis.create(dArray, tableDataSet.getXUnits(), 2, false);
        DasStackedHistogramPlot dasStackedHistogramPlot = DasStackedHistogramPlot.create(dasCanvas, tableDataSet, dasAxis2, dasAxis);
        dasStackedHistogramPlot.setRow(dasRow);
        dasStackedHistogramPlot.setColumn(dasColumn);
        return dasStackedHistogramPlot;
    }

    public static DasStackedHistogramPlot create(DasCanvas dasCanvas, TableDataSet tableDataSet, DasAxis dasAxis, DasAxis dasAxis2) {
        Datum[] datumArray = new Datum[tableDataSet.getYLength(0)];
        Units units = tableDataSet.getYUnits();
        int n = 0;
        while (n < tableDataSet.getYLength(0)) {
            datumArray[n] = tableDataSet.getXTagDatum(n);
            ++n;
        }
        ConstantDataSetDescriptor constantDataSetDescriptor = new ConstantDataSetDescriptor(tableDataSet);
        DasLabelAxis dasLabelAxis = new DasLabelAxis(datumArray, 3);
        return new DasStackedHistogramPlot(constantDataSetDescriptor, dasAxis, dasLabelAxis, dasAxis2);
    }

    public static DasStackedHistogramPlot create(DataSetDescriptor dataSetDescriptor, DasAxis dasAxis, DasAxis dasAxis2) {
        if (dataSetDescriptor instanceof StreamDataSetDescriptor) {
            StreamDataSetDescriptor streamDataSetDescriptor = (StreamDataSetDescriptor)dataSetDescriptor;
            if (streamDataSetDescriptor.getProperty("form").equals("x_tagged_y_scan")) {
                PacketDescriptor packetDescriptor = streamDataSetDescriptor.getDefaultPacketDescriptor();
                StreamYScanDescriptor streamYScanDescriptor = (StreamYScanDescriptor)packetDescriptor.getYDescriptors().get(0);
                Datum[] datumArray = new Datum[streamYScanDescriptor.getNItems()];
                Units units = streamYScanDescriptor.getYUnits();
                double[] dArray = streamYScanDescriptor.getYTags();
                int n = 0;
                while (n < dArray.length) {
                    datumArray[n] = Datum.create(dArray[n], units);
                    ++n;
                }
                return new DasStackedHistogramPlot(dataSetDescriptor, dasAxis, new DasLabelAxis(datumArray, 3), dasAxis2);
            }
        } else {
            double[] dArray = (double[])dataSetDescriptor.getProperty("y_coordinate");
            Datum[] datumArray = new Datum[dArray.length];
            Units units = Units.dimensionless;
            int n = 0;
            while (n < dArray.length) {
                datumArray[n] = Datum.create(dArray[n], units);
                ++n;
            }
            return new DasStackedHistogramPlot(dataSetDescriptor, dasAxis, new DasLabelAxis(datumArray, 3), dasAxis2);
        }
        return null;
    }

    public DasStackedHistogramPlot(DataSetDescriptor dataSetDescriptor, DasAxis dasAxis, DasLabelAxis dasLabelAxis, DasAxis dasAxis2) {
        super(dasAxis, dasLabelAxis);
        dasLabelAxis.addPropertyChangeListener("labelPositions", this.rebinListener);
        dasLabelAxis.setFloppyItemSpacing(true);
        dasLabelAxis.setOutsidePadding(1);
        this.zAxisComponent = new ZAxisComponent(this, dasAxis2);
        this.setZAxis(dasAxis2);
        this.peaksIndicator = PeaksIndicator.MaxLines;
        VerticalSpectrogramSlicer verticalSpectrogramSlicer = VerticalSpectrogramSlicer.createSlicer(this, this);
        VerticalSlicerMouseModule verticalSlicerMouseModule = VerticalSlicerMouseModule.create(this);
        verticalSlicerMouseModule.addDataPointSelectionListener(verticalSpectrogramSlicer);
        this.mouseAdapter.addMouseModule(verticalSlicerMouseModule);
        HorizontalSpectrogramSlicer horizontalSpectrogramSlicer = HorizontalSpectrogramSlicer.createSlicer(this, this);
        HorizontalSlicerMouseModule horizontalSlicerMouseModule = HorizontalSlicerMouseModule.create(this);
        horizontalSlicerMouseModule.addDataPointSelectionListener(horizontalSpectrogramSlicer);
        this.mouseAdapter.addMouseModule(horizontalSlicerMouseModule);
        this.setDataSetDescriptor(dataSetDescriptor);
    }

    public static DasStackedHistogramPlot create(DasCanvas dasCanvas, DataSetDescriptor dataSetDescriptor, Datum datum, Datum datum2) throws DasException {
        TableDataSet tableDataSet = (TableDataSet)dataSetDescriptor.getDataSet(datum, datum2, null, null);
        DasStackedHistogramPlot dasStackedHistogramPlot = DasStackedHistogramPlot.create(dasCanvas, tableDataSet);
        dasStackedHistogramPlot.setDataSetDescriptor(dataSetDescriptor);
        return dasStackedHistogramPlot;
    }

    public void setZAxis(DasAxis dasAxis) {
        if (dasAxis.isHorizontal()) {
            throw new IllegalArgumentException("ZAxis is not VERTICAL");
        }
        DasAxis dasAxis2 = this.zAxisComponent.getAxis();
        if (dasAxis2 != null) {
            if (this.parent != null) {
                this.parent.remove(dasAxis2);
            }
            dasAxis2.removePropertyChangeListener("dataMinimum", this.rebinListener);
            dasAxis2.removePropertyChangeListener("dataMaximum", this.rebinListener);
            dasAxis2.removePropertyChangeListener("log", this.rebinListener);
        }
        if (this.parent != null) {
            this.parent.add(dasAxis);
        }
        dasAxis.addPropertyChangeListener("dataMinimum", this.rebinListener);
        dasAxis.addPropertyChangeListener("dataMaximum", this.rebinListener);
        dasAxis.addPropertyChangeListener("log", this.rebinListener);
        this.getYAxis().addPropertyChangeListener("dataMinimum", this.zAxisComponent);
        this.getYAxis().addPropertyChangeListener("dataMaximum", this.zAxisComponent);
        this.getYAxis().addPropertyChangeListener("log", this.zAxisComponent);
    }

    public void setYAxis(DasAxis dasAxis) {
        if (dasAxis instanceof DasLabelAxis) {
            super.setYAxis(dasAxis);
        } else {
            DasDie.die("You can't call setYAxis for stackedHistogramPlot");
        }
    }

    protected synchronized void updatePlotImage() throws DasException {
        Container container = this.getParent();
        Cursor cursor = container.getCursor();
        container.setCursor(new Cursor(3));
        int n = this.getColumn().getWidth();
        int n2 = this.getRow().getHeight();
        if (n == 0) {
            return;
        }
        this.plotImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = (Graphics2D)this.plotImage.getGraphics();
        graphics2D.translate(-this.getColumn().getDMinimum(), -this.getRow().getDMinimum());
        double d = this.getColumn().getDMinimum();
        double d2 = this.getRow().getDMinimum();
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        RenderingHints renderingHints2 = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHints(renderingHints2);
        DasAxis dasAxis = this.getXAxis();
        RebinDescriptor rebinDescriptor = new RebinDescriptor(dasAxis.getDataMinimum(), dasAxis.getDataMaximum(), Math.abs(this.getColumn().getWidth()) / 1 + 1, this.getXAxis().isLog());
        int n3 = this.getColumn().getDMaximum();
        int n4 = this.getColumn().getDMinimum();
        TableDataSet tableDataSet = (TableDataSet)this.Data;
        if (this.Data == null) {
            DasDie.println("null data set");
            return;
        }
        Rebinner rebinner = new Rebinner();
        TableDataSet tableDataSet2 = (TableDataSet)rebinner.rebin(tableDataSet, rebinDescriptor, null);
        TableDataSet tableDataSet3 = (TableDataSet)tableDataSet2.getPlanarView("peaks");
        DasLabelAxis dasLabelAxis = (DasLabelAxis)this.getYAxis();
        int n5 = 0;
        while (n5 < tableDataSet2.getYLength(0)) {
            int n6;
            if (n5 == tableDataSet2.getYLength(0) - 1) {
                n6 = dasLabelAxis.getItemMin(tableDataSet2.getYTagDatum(0, n5));
                graphics2D.setColor(Color.lightGray);
                graphics2D.drawLine(n4, n6, n3, n6);
                graphics2D.setColor(Color.darkGray);
            }
            n6 = dasLabelAxis.getItemMax(tableDataSet2.getYTagDatum(0, n5));
            graphics2D.setColor(Color.lightGray);
            graphics2D.drawLine(n4, n6, n3, n6);
            graphics2D.setColor(Color.darkGray);
            int n7 = dasLabelAxis.getItemMin(tableDataSet2.getYTagDatum(0, n5));
            double d3 = container.getHeight();
            this.zAxisComponent.setLittleRow(n7, n6);
            double[] dArray = rebinDescriptor.binStarts();
            double[] dArray2 = rebinDescriptor.binStops();
            int n8 = n6;
            int n9 = n6 - n7;
            double d4 = this.zAxisComponent.getAxis().getDataMaximum().doubleValue(tableDataSet.getZUnits());
            if (n7 >= this.getRow().getDMinimum() && n6 <= this.getRow().getDMaximum()) {
                int n10 = 0;
                while (n10 < tableDataSet2.getXLength()) {
                    int n11 = this.getXAxis().transform(dArray[n10], rebinDescriptor.getUnits());
                    int n12 = n11 + 1;
                    double d5 = tableDataSet2.getDouble(n10, n5, tableDataSet2.getZUnits());
                    if (!tableDataSet2.getZUnits().isFill(d5)) {
                        double d6;
                        int n13 = this.zAxisComponent.transform(d5, tableDataSet2.getZUnits());
                        n13 = n13 > n8 - n9 ? n13 : n8 - n9;
                        int n14 = n8 - n13 > 0 ? n8 - n13 : 0;
                        int n15 = n14 = n14 < n9 ? n14 : n9;
                        if (tableDataSet3 != null && (d6 = tableDataSet3.getDouble(n10, n5, tableDataSet3.getZUnits())) <= d4) {
                            int n16 = this.zAxisComponent.transform(d6, tableDataSet3.getZUnits());
                            int n17 = n16 = n8 - n16 > 0 ? n16 : n8;
                            if (this.peaksIndicator == PeaksIndicator.MaxLines) {
                                graphics2D.drawLine(n11, n16, n11, n16);
                            } else if (this.peaksIndicator == PeaksIndicator.GrayPeaks) {
                                graphics2D.setColor(Color.lightGray);
                                graphics2D.fillRect(n11, n16, n12 - n11, n8 - n16);
                                graphics2D.setColor(Color.darkGray);
                            }
                        }
                        graphics2D.fillRect(n11, n13, n12 - n11, n14);
                    }
                    ++n10;
                }
            }
            ++n5;
        }
        if (this.isSliceRebinnedData()) {
            this.Data = tableDataSet2;
        }
        graphics2D.setRenderingHints(renderingHints);
        graphics2D.dispose();
        container.setCursor(cursor);
        this.repaint();
    }

    public void setData(TableDataSet tableDataSet) {
        super.setData(tableDataSet);
    }

    public DasAxis getZAxis() {
        return this.zAxisComponent.getAxis();
    }

    public void setZTitle(String string) {
        this.getZAxis().setLabel(string);
    }

    protected void installComponent() {
        super.installComponent();
        this.getCanvas().add(this.zAxisComponent);
    }

    public PeaksIndicator getPeaksIndicator() {
        return this.peaksIndicator;
    }

    public void setPeaksIndicator(PeaksIndicator peaksIndicator) {
        this.peaksIndicator = peaksIndicator;
        try {
            this.updatePlotImage();
        }
        catch (DasException dasException) {
            DasExceptionHandler.handle(dasException);
        }
        this.repaint();
    }

    public void dataSetUpdated(DataSetUpdateEvent dataSetUpdateEvent) {
        this.markDirty();
        this.update();
        this.repaint();
    }

    public void setDataSetDescriptor(DataSetDescriptor dataSetDescriptor) {
        super.setDataSetDescriptor(dataSetDescriptor);
        dataSetDescriptor.addDataSetUpdateListener(this);
    }

    public boolean isDumpDataSet() {
        return this.dumpDataSet;
    }

    public void setDumpDataSet(boolean bl) {
        try {
            if (bl) {
                System.out.println("Dumping data set");
                JFileChooser jFileChooser = new JFileChooser();
                int n = jFileChooser.showSaveDialog(this.getParent());
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    DataSet dataSet = this.getDataSet();
                    if (dataSet instanceof TableDataSet) {
                        TableUtil.dumpToAsciiStream((TableDataSet)dataSet, new FileOutputStream(file));
                    } else {
                        throw new DasException("don't know how to serialize data set");
                    }
                }
                this.setDumpDataSet(false);
            }
        }
        catch (Exception exception) {
            DasExceptionHandler.handle(exception);
        }
        this.dumpDataSet = bl;
    }

    public boolean isSliceRebinnedData() {
        return this.sliceRebinnedData;
    }

    public void setSliceRebinnedData(boolean bl) {
        this.sliceRebinnedData = bl;
    }

    public class Rebinner
    implements DataSetRebinner {
        DataSetRebinner highResRebinner = new NearestNeighborTableRebinner();
        DataSetRebinner lowResRebinner = new AveragePeakTableRebinner();

        Rebinner() {
        }

        public DataSet rebin(DataSet dataSet, RebinDescriptor rebinDescriptor, RebinDescriptor rebinDescriptor2) throws IllegalArgumentException, DasException {
            Units units;
            Datum datum = (Datum)dataSet.getProperty("xTagWidth");
            if (datum == null) {
                datum = DataSetUtil.guessXTagWidth((TableDataSet)dataSet);
            }
            if ((units = rebinDescriptor.getUnits()) instanceof LocationUnits) {
                units = ((LocationUnits)units).getOffsetUnits();
            }
            try {
                Datum datum2 = DasStackedHistogramPlot.this.getXAxis().getDataMinimum();
                Datum datum3 = DasStackedHistogramPlot.this.getXAxis().getDataMaximum();
                DataSet dataSet2 = rebinDescriptor.binWidth() < datum.doubleValue(units) ? this.highResRebinner.rebin(dataSet, rebinDescriptor, rebinDescriptor2) : this.lowResRebinner.rebin(dataSet, rebinDescriptor, rebinDescriptor2);
                return dataSet2;
            }
            catch (Exception exception) {
                DasExceptionHandler.handle(exception);
                return null;
            }
        }
    }

    public class ZAxisComponent
    extends DasCanvasComponent
    implements PropertyChangeListener {
        private DasAxis zAxis;
        private DasPlot parent;
        private int littleRowMin;
        private int littleRowMax;
        private int docLittleRowMin = -1;
        private int docLittleRowMax;
        private DasRow row0;

        public ZAxisComponent(DasPlot dasPlot, DasAxis dasAxis) {
            this.zAxis = dasAxis;
            this.row0 = dasAxis.getRow();
            this.setRow(dasPlot.getRow());
            this.setColumn(dasPlot.getColumn());
            this.parent = dasPlot;
            this.setBounds(this.getBounds());
        }

        private Rectangle getZAxisComponentBounds() {
            int n = this.parent.getColumn().getDMaximum();
            int n2 = this.zAxis.getColumn().getDMaximum();
            int n3 = this.parent.getRow().getDMaximum();
            int n4 = this.zAxis.getRow().getDMaximum();
            int n5 = this.parent.getRow().getDMinimum();
            int n6 = this.zAxis.getRow().getDMinimum();
            Rectangle rectangle = new Rectangle(n, n5 - 1, n2 - n, n3 - n5 + 2);
            rectangle.add(n2, n6 - 1);
            rectangle.add(n2, n4 + 1);
            return rectangle;
        }

        protected DasAxis getAxis() {
            return this.zAxis;
        }

        public void setLittleRow(int n, int n2) {
            this.littleRowMin = n;
            this.littleRowMax = n2;
            int n3 = this.zAxis.getRow().getDMiddle();
            if (n <= n3 && n3 < n2) {
                this.docLittleRowMin = n;
                this.docLittleRowMax = n2;
            }
            this.repaint();
        }

        public int transform(double d, Units units) {
            int n = this.zAxis.transform(d, units, this.littleRowMax, this.littleRowMin);
            return n;
        }

        public void resize() {
            this.setBounds(this.getZAxisComponentBounds());
        }

        protected void paintComponent(Graphics graphics) {
            if (this.docLittleRowMin == -1) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(-this.getX(), -this.getY());
            int n = 3;
            int n2 = this.parent.getColumn().getDMaximum() + n;
            int n3 = this.zAxis.getColumn().getDMaximum() - n;
            int n4 = this.docLittleRowMax;
            int n5 = this.zAxis.getRow().getDMaximum();
            int n6 = this.docLittleRowMin;
            int n7 = this.zAxis.getRow().getDMinimum();
            graphics2D.setColor(Color.lightGray);
            graphics2D.draw(new Line2D.Double(n2 - n, n4, n2, n4));
            graphics2D.draw(new Line2D.Double(n3, n5, n3 + n, n5));
            graphics2D.draw(new Line2D.Double(n2, n4, n3, n5));
            graphics2D.draw(new Line2D.Double(n2 - n, n6, n2, n6));
            graphics2D.draw(new Line2D.Double(n3, n7, n3 + n, n7));
            graphics2D.draw(new Line2D.Double(n2, n6, n3, n7));
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.update();
        }

        protected void installComponent() {
            super.installComponent();
            this.getCanvas().add(this.zAxis);
        }
    }

    public static class PeaksIndicator
    implements Enumeration {
        String id;
        public static final PeaksIndicator GrayPeaks = new PeaksIndicator("Gray Peaks");
        public static final PeaksIndicator NoPeaks = new PeaksIndicator("None");
        public static final PeaksIndicator MaxLines = new PeaksIndicator("Lines");

        PeaksIndicator(String string) {
            this.id = string;
        }

        public String toString() {
            return this.id;
        }

        public Icon getListIcon() {
            return null;
        }
    }
}

