/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.dataset.ConstantDataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DefaultVectorDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.Psym;
import edu.uiowa.physics.pw.das.graph.SymbolLineRenderer;
import edu.uiowa.physics.pw.das.util.DasDie;
import java.util.Collections;

public class DasSymbolPlot
extends DasPlot {
    private SymbolLineRenderer renderer;

    public DasSymbolPlot(VectorDataSet vectorDataSet, DasAxis dasAxis, DasAxis dasAxis2) {
        this(vectorDataSet == null ? null : new ConstantDataSetDescriptor(vectorDataSet), dasAxis, dasAxis2);
    }

    public DasSymbolPlot(DataSetDescriptor dataSetDescriptor, DasAxis dasAxis, DasAxis dasAxis2) {
        super(dasAxis, dasAxis2);
        this.renderer = new SymbolLineRenderer(dataSetDescriptor);
        this.addRenderer(this.renderer);
    }

    public Psym getPsym() {
        return this.renderer.getPsym();
    }

    public void setPsym(Psym psym) {
        this.renderer.setPsym(psym);
    }

    public void addData(double[] dArray, double[] dArray2) {
        Units units = Units.dimensionless;
        this.addData(new DefaultVectorDataSet(dArray, units, dArray2, units, Collections.EMPTY_MAP));
    }

    public void addData(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        int n = 0;
        while (n < dArray2.length) {
            dArray2[n] = n;
            ++n;
        }
        this.addData(dArray2, dArray);
    }

    public void addData(VectorDataSet vectorDataSet) {
        this.renderer.setDataSet(vectorDataSet);
    }

    public static DasSymbolPlot create(DasCanvas dasCanvas, DataSetDescriptor dataSetDescriptor) {
        DasRow dasRow = new DasRow(dasCanvas, 0.05, 0.85);
        DasColumn dasColumn = new DasColumn(dasCanvas, 0.15, 0.9);
        DasDie.println("  dsd: " + dataSetDescriptor + " units: " + dataSetDescriptor.getXUnits());
        DasAxis dasAxis = dataSetDescriptor.getXUnits() instanceof TimeLocationUnits ? new DasAxis(TimeUtil.createValid("2000/1/1"), TimeUtil.createValid("2000/1/2"), 2) : new DasAxis(Datum.create(0, dataSetDescriptor.getXUnits()), Datum.create(10, dataSetDescriptor.getXUnits()), 2);
        DasAxis dasAxis2 = new DasAxis(Datum.create(0, Units.dimensionless), Datum.create(10, Units.dimensionless), 3);
        DasSymbolPlot dasSymbolPlot = new DasSymbolPlot(dataSetDescriptor, dasAxis, dasAxis2);
        dasCanvas.add(dasSymbolPlot, dasRow, dasColumn);
        return dasSymbolPlot;
    }

    public static DasSymbolPlot create(DasCanvas dasCanvas, VectorDataSet vectorDataSet) {
        int n;
        DasRow dasRow = new DasRow(dasCanvas, 0.05, 0.85);
        DasColumn dasColumn = new DasColumn(dasCanvas, 0.15, 0.9);
        int n2 = n = vectorDataSet.getXLength();
        double[] dArray = new double[n];
        int n3 = 0;
        while (n3 < n) {
            dArray[n3] = vectorDataSet.getXTagDouble(n3, vectorDataSet.getXUnits());
            ++n3;
        }
        double d = Double.NaN;
        double[] dArray2 = new double[n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            double d2 = vectorDataSet.getDouble(n5, vectorDataSet.getYUnits());
            if (!Double.isNaN(d2)) {
                dArray2[n4++] = d2;
            }
            ++n5;
        }
        DasSymbolPlot dasSymbolPlot = new DasSymbolPlot(vectorDataSet, DasAxis.create(dArray, vectorDataSet.getXUnits(), 2, false), DasAxis.create(dArray2, vectorDataSet.getYUnits(), 3, false));
        dasCanvas.add(dasSymbolPlot, dasRow, dasColumn);
        return dasSymbolPlot;
    }

    public double getSymSize() {
        return this.renderer.getSymSize();
    }

    public void setSymSize(double d) {
        this.renderer.setSymSize(d);
    }
}

