/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.components.propertyeditor.Enumeration;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class Psym
implements Enumeration {
    private static final String[] NAMES = new String[]{"none", "dots", "circles", "triangles", "cross"};
    private static final boolean[] DRAWS_LINES = new boolean[]{false, false, false, false, false};
    public static final Psym NONE = new Psym(0);
    public static final Psym DOTS = new Psym(1);
    public static final Psym CIRCLES = new Psym(2);
    public static final Psym TRIANGLES = new Psym(3);
    public static final Psym CROSS = new Psym(4);
    private int nameIndex;
    Line2D.Double line;
    ImageIcon imageIcon;

    private Psym(int n) {
        this.nameIndex = n;
        this.line = new Line2D.Double();
        BufferedImage bufferedImage = new BufferedImage(10, 10, 1);
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        graphics2D.setRenderingHints(DasProperties.getRenderingHints());
        graphics2D.setColor(Color.lightGray);
        graphics2D.fillRect(0, 0, 10, 10);
        graphics2D.setColor(Color.black);
        this.draw(graphics2D, 5, 5, 2.0f);
        this.imageIcon = new ImageIcon(bufferedImage);
    }

    public String toString() {
        return NAMES[this.nameIndex];
    }

    public Icon getListIcon() {
        return this.imageIcon;
    }

    public boolean drawsLines() {
        return DRAWS_LINES[this.nameIndex];
    }

    public void draw(Graphics graphics, int n, int n2, float f) {
        switch (this.nameIndex) {
            case 0: {
                break;
            }
            case 1: {
                if (f <= 1.0f) {
                    graphics.drawLine(n, n2, n, n2);
                    break;
                }
                graphics.fillOval((int)((float)n - f), (int)((float)n2 - f), (int)(f * 2.0f), (int)(f * 2.0f));
                break;
            }
            case 2: {
                Color color = graphics.getColor();
                graphics.setColor(Color.lightGray);
                graphics.fillOval((int)((float)n - f), (int)((float)n2 - f), (int)(f * 2.0f), (int)(f * 2.0f));
                graphics.setColor(color);
                graphics.drawOval((int)((float)n - f), (int)((float)n2 - f), (int)(f * 2.0f), (int)(f * 2.0f));
                break;
            }
            case 3: {
                this.drawTriangle(graphics, n, n2, (int)f);
                break;
            }
            case 4: {
                graphics.drawLine((int)((float)n - f), n2, (int)((float)n + f), n2);
                graphics.drawLine(n, (int)((float)n2 - f), n, (int)((float)n2 + f));
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid nameIndex for psym");
            }
        }
    }

    public void drawLine(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        if (this.nameIndex == 0) {
            this.line.setLine(n, n2, n3, n4);
            graphics2D.draw(this.line);
        } else if (this.nameIndex == 5) {
            int n5 = (n + n3) / 2;
            this.line.setLine(n, n2, n5, n2);
            graphics2D.draw(this.line);
            this.line.setLine(n5, n2, n5, n4);
            graphics2D.draw(this.line);
            this.line.setLine(n5, n4, n3, n4);
            graphics2D.draw(this.line);
        }
    }

    public void drawTriangle(Graphics graphics, int n, int n2, int n3) {
        graphics.drawLine(n, n2 - n3, n + n3, n2 + n3);
        graphics.drawLine(n + n3, n2 + n3, n - n3, n2 + n3);
        graphics.drawLine(n - n3, n2 + n3, n, n2 - n3);
    }

    public static Psym parsePsym(String string) {
        if (string.equals("lines")) {
            return NONE;
        }
        if (string.equals("dots")) {
            return DOTS;
        }
        if (string.equals("circles")) {
            return CIRCLES;
        }
        if (string.equals("triangles")) {
            return TRIANGLES;
        }
        if (string.equals("cross")) {
            return CROSS;
        }
        throw new IllegalArgumentException(string);
    }
}

