/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.components.DasProgressPanel;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.dataset.ConstantDataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataRequestThread;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetConsumer;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetUpdateEvent;
import edu.uiowa.physics.pw.das.dataset.DataSetUpdateListener;
import edu.uiowa.physics.pw.das.dataset.NoDataInIntervalException;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorUtil;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRendererUpdateEvent;
import edu.uiowa.physics.pw.das.graph.SpectrogramRenderer;
import edu.uiowa.physics.pw.das.stream.StreamException;
import edu.uiowa.physics.pw.das.system.RequestProcessor;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InterruptedIOException;
import javax.swing.JFileChooser;

public abstract class Renderer
implements DataSetConsumer,
Editable,
DataSetUpdateListener {
    private DataSetDescriptor dsd;
    protected DataSet ds;
    private boolean fullResolution = false;
    DasPlot parent;
    private DasProgressPanel progressPanel;
    private DataRequestThread drt;
    protected Exception lastException;
    private boolean dumpDataSet;

    protected Renderer(DataSetDescriptor dataSetDescriptor) {
        this.dsd = dataSetDescriptor;
        if (dataSetDescriptor != null) {
            dataSetDescriptor.addDataSetUpdateListener(this);
        }
    }

    protected Renderer(DataSet dataSet) {
        this(dataSet == null ? (DataSetDescriptor)null : new ConstantDataSetDescriptor(dataSet));
    }

    protected Renderer() {
        this((DataSetDescriptor)null);
    }

    protected Renderer(DasPlot dasPlot, DataSetDescriptor dataSetDescriptor) {
        this(dataSetDescriptor);
        this.parent = dasPlot;
    }

    protected Renderer(DasPlot dasPlot, DataSet dataSet) {
        this(dataSet == null ? (DataSetDescriptor)null : new ConstantDataSetDescriptor(dataSet));
        this.parent = dasPlot;
    }

    public boolean isFullResolution() {
        return this.fullResolution;
    }

    public void setFullResolution(boolean bl) {
        if (this.fullResolution == bl) {
            return;
        }
        this.fullResolution = bl;
    }

    public DasPlot getParent() {
        return this.parent;
    }

    public DataSet getDataSet() {
        return this.ds;
    }

    public boolean isDumpDataSet() {
        return this.dumpDataSet;
    }

    public void setDumpDataSet(boolean bl) {
        try {
            this.dumpDataSet = bl;
            if (bl) {
                System.out.println("Dumping data set");
                JFileChooser jFileChooser = new JFileChooser();
                int n = jFileChooser.showSaveDialog(this.getParent());
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    if (this.ds instanceof TableDataSet) {
                        TableUtil.dumpToAsciiStream((TableDataSet)this.ds, new FileOutputStream(file));
                    } else if (this.ds instanceof VectorDataSet) {
                        VectorUtil.dumpToAsciiStream((VectorDataSet)this.ds, new FileOutputStream(file));
                    } else {
                        throw new DasException("don't know how to serialize data set");
                    }
                }
                this.setDumpDataSet(false);
            }
        }
        catch (Exception exception) {
            DasExceptionHandler.handle(exception);
        }
        this.dumpDataSet = bl;
    }

    public void setLastException(Exception exception) {
        this.lastException = exception;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public void setDataSet(DataSet dataSet) {
        this.setDataSetDescriptor(new ConstantDataSetDescriptor(dataSet));
    }

    public void setDataSetID(String string) throws DasException {
        if (string == null) {
            throw new NullPointerException("Null dataPath not allowed");
        }
        if (string.equals("")) {
            this.setDataSetDescriptor(null);
            return;
        }
        DataSetDescriptor dataSetDescriptor = DataSetDescriptor.create(string);
        this.setDataSetDescriptor(dataSetDescriptor);
    }

    public String getDataSetID() {
        if (this.dsd == null) {
            return "";
        }
        return this.dsd.getDataSetID();
    }

    public abstract void render(Graphics var1, DasAxis var2, DasAxis var3);

    public void renderException(Graphics graphics, DasAxis dasAxis, DasAxis dasAxis2, Exception exception) {
        String string;
        int n = dasAxis.getColumn().getDMiddle();
        int n2 = dasAxis2.getRow().getDMiddle();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (exception instanceof NoDataInIntervalException) {
            string = "no data in interval";
        } else {
            string = exception.getMessage();
            if ("".equals(string)) {
                string = exception.toString();
            }
        }
        int n3 = fontMetrics.stringWidth(string);
        Color color = graphics.getColor();
        graphics.setColor(Color.lightGray);
        graphics.drawString(string, n - n3 / 2, n2);
        graphics.setColor(color);
    }

    protected void loadDataSet(final DasAxis dasAxis, DasAxis dasAxis2) {
        if (this.parent == null || !this.parent.isDisplayable() || this.dsd == null) {
            return;
        }
        if (this.dsd instanceof ConstantDataSetDescriptor) {
            try {
                this.ds = this.dsd.getDataSet(null, null, null, null);
                this.updatePlotImage(dasAxis, dasAxis2, this.progressPanel);
                return;
            }
            catch (DasException dasException) {
                if (dasException instanceof DasException) {
                    this.lastException = dasException;
                    this.ds = null;
                }
                DasExceptionHandler.handle(dasException);
                return;
            }
        }
        this.lastException = null;
        Runnable runnable = new Runnable(){

            public void run() {
                Datum datum = dasAxis.getDataMaximum().subtract(dasAxis.getDataMinimum());
                double d = Math.floor((double)dasAxis.getColumn().getDMaximum() + 0.5) - Math.floor((double)dasAxis.getColumn().getDMinimum() + 0.5);
                Datum datum2 = Renderer.this.fullResolution ? null : datum.divide(d);
                if (d == 0.0) {
                    return;
                }
                if (Renderer.this.progressPanel == null) {
                    Renderer.this.progressPanel = DasProgressPanel.createComponentPanel(Renderer.this.parent, "Loading data set");
                } else {
                    Renderer.this.progressPanel.setLabel("Loading data set");
                }
                Renderer.this.progressPanel.cancel();
                Renderer.this.dsd.requestDataSet(dasAxis.getDataMinimum(), dasAxis.getDataMaximum(), datum2, Renderer.this.progressPanel);
            }
        };
        try {
            this.updatePlotImage(dasAxis, dasAxis2, null);
        }
        catch (DasException dasException) {
            // empty catch block
        }
        RequestProcessor.invokeLater(runnable, this.getParent().getCanvas());
    }

    public abstract void updatePlotImage(DasAxis var1, DasAxis var2, DasProgressMonitor var3) throws DasException;

    protected void refreshImage() {
        if (this.getParent() != null) {
            this.getParent().markDirty();
            if (this instanceof SpectrogramRenderer) {
                this.update();
            }
            this.getParent().repaint();
        }
    }

    public void update() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        DasRendererUpdateEvent dasRendererUpdateEvent = new DasRendererUpdateEvent(this.parent, this);
        eventQueue.postEvent(dasRendererUpdateEvent);
    }

    protected void updateImmediately() {
        DasAxis dasAxis = this.parent.getXAxis();
        DasAxis dasAxis2 = this.parent.getYAxis();
        this.loadDataSet(dasAxis, dasAxis2);
    }

    public void dataSetUpdated(DataSetUpdateEvent dataSetUpdateEvent) {
        block13: {
            Exception exception;
            if (!(dataSetUpdateEvent.getException() == null || (exception = dataSetUpdateEvent.getException()) instanceof InterruptedIOException || exception instanceof StreamException && !(((StreamException)exception).getCause() instanceof InterruptedIOException))) {
                if (exception instanceof DasException) {
                    this.lastException = exception;
                }
                if (!(exception instanceof NoDataInIntervalException)) {
                    DasExceptionHandler.handle(exception);
                }
            }
            try {
                block12: {
                    try {
                        this.ds = dataSetUpdateEvent.getDataSet();
                        if (this.progressPanel != null) {
                            this.progressPanel.setLabel("Rebinning data set");
                        }
                        this.updatePlotImage(this.parent.getXAxis(), this.parent.getYAxis(), this.progressPanel);
                        if (this.parent == null) break block12;
                        this.parent.repaint();
                    }
                    catch (DasException dasException) {
                        this.ds = null;
                        this.lastException = dasException;
                        Object var5_5 = null;
                        if (this.progressPanel != null) {
                            this.progressPanel.finished();
                        }
                        break block13;
                    }
                    catch (RuntimeException runtimeException) {
                        this.ds = null;
                        throw runtimeException;
                    }
                }
                Object var5_4 = null;
                if (this.progressPanel != null) {
                    this.progressPanel.finished();
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (this.progressPanel != null) {
                    this.progressPanel.finished();
                }
                throw throwable;
            }
        }
    }

    public void setDataSetDescriptor(DataSetDescriptor dataSetDescriptor) {
        if (this.dsd != null) {
            this.dsd.removeDataSetUpdateListener(this);
        }
        this.dsd = dataSetDescriptor;
        if (dataSetDescriptor != null) {
            dataSetDescriptor.addDataSetUpdateListener(this);
        }
        if (this.parent != null) {
            this.parent.markDirty();
            this.parent.update();
        }
        this.ds = null;
    }

    public DataSetDescriptor getDataSetDescriptor() {
        return this.dsd;
    }

    protected abstract void installRenderer();

    protected abstract void uninstallRenderer();
}

