/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.components.HorizontalSpectrogramSlicer;
import edu.uiowa.physics.pw.das.components.VerticalSpectrogramAverager;
import edu.uiowa.physics.pw.das.components.VerticalSpectrogramSlicer;
import edu.uiowa.physics.pw.das.components.propertyeditor.Enumeration;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dataset.AverageTableRebinner;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetRebinner;
import edu.uiowa.physics.pw.das.dataset.DefaultTableDataSet;
import edu.uiowa.physics.pw.das.dataset.NearestNeighborTableRebinner;
import edu.uiowa.physics.pw.das.dataset.RebinDescriptor;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSetConsumer;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.event.CrossHairMouseModule;
import edu.uiowa.physics.pw.das.event.DasMouseInputAdapter;
import edu.uiowa.physics.pw.das.event.HorizontalDragRangeSelectorMouseModule;
import edu.uiowa.physics.pw.das.event.HorizontalSlicerMouseModule;
import edu.uiowa.physics.pw.das.event.VerticalSlicerMouseModule;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasColorBar;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasDevicePosition;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.Icon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpectrogramRenderer
extends Renderer
implements TableDataSetConsumer {
    private DasColorBar colorBar;
    Image plotImage;
    RebinListener rebinListener = new RebinListener();
    private RebinnerEnum rebinnerEnum;
    int count = 0;
    private boolean sliceRebinnedData = true;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasColorBar;

    public SpectrogramRenderer(DataSetDescriptor dataSetDescriptor, DasColorBar dasColorBar) {
        super(dataSetDescriptor);
        this.colorBar = dasColorBar;
        if (this.colorBar != null) {
            dasColorBar.addPropertyChangeListener("dataMinimum", this.rebinListener);
            dasColorBar.addPropertyChangeListener("dataMaximum", this.rebinListener);
            dasColorBar.addPropertyChangeListener("log", this.rebinListener);
            dasColorBar.addPropertyChangeListener("type", this.rebinListener);
        }
        this.setRebinner(RebinnerEnum.binAverage);
    }

    public SpectrogramRenderer(DasPlot dasPlot, DataSetDescriptor dataSetDescriptor, DasColorBar dasColorBar) {
        this(dataSetDescriptor, dasColorBar);
        this.parent = dasPlot;
    }

    public DasAxis getZAxis() {
        return this.colorBar;
    }

    public DasColorBar getColorBar() {
        return this.colorBar;
    }

    public void setColorBar(DasColorBar dasColorBar) {
        if (this.colorBar == dasColorBar) {
            return;
        }
        if (this.colorBar != null) {
            this.colorBar.removePropertyChangeListener("dataMinimum", this.rebinListener);
            this.colorBar.removePropertyChangeListener("dataMaximum", this.rebinListener);
            this.colorBar.removePropertyChangeListener("log", this.rebinListener);
            this.colorBar.removePropertyChangeListener("type", this.rebinListener);
            if (this.parent != null && this.parent.getCanvas() != null) {
                this.parent.getCanvas().remove(this.colorBar);
            }
        }
        this.colorBar = dasColorBar;
        if (this.colorBar != null) {
            this.colorBar.addPropertyChangeListener("dataMinimum", this.rebinListener);
            this.colorBar.addPropertyChangeListener("dataMaximum", this.rebinListener);
            this.colorBar.addPropertyChangeListener("log", this.rebinListener);
            this.colorBar.addPropertyChangeListener("type", this.rebinListener);
            if (this.parent != null && this.parent.getCanvas() != null) {
                this.parent.getCanvas().add(this.colorBar);
            }
        }
    }

    public void render(Graphics graphics, DasAxis dasAxis, DasAxis dasAxis2) {
        if (this.getDataSet() == null && this.lastException != null) {
            this.renderException(graphics, dasAxis, dasAxis2, this.lastException);
        } else if (this.plotImage != null) {
            int n = dasAxis.getColumn().getDMinimum();
            int n2 = dasAxis2.getRow().getDMinimum();
            graphics.drawImage(this.plotImage, n, n2, this.getParent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePlotImage(DasAxis dasAxis, DasAxis dasAxis2, DasProgressMonitor dasProgressMonitor) throws DasException {
        try {
            if (dasProgressMonitor != null) {
                if (dasProgressMonitor.isCancelled()) {
                    return;
                }
                dasProgressMonitor.setTaskSize(-1L);
                dasProgressMonitor.started();
            }
            int n = dasAxis.getColumn().getDMaximum() - dasAxis.getColumn().getDMinimum();
            int n2 = dasAxis2.getRow().getDMaximum() - dasAxis2.getRow().getDMinimum();
            if (this.getParent() == null || n <= 1 || n2 <= 1) {
                DasDie.println("canvas not useable!!!");
                return;
            }
            int[] nArray = new int[n * n2];
            Arrays.fill(nArray, 0);
            if (this.getDataSet() == null) {
                double[] dArray;
                Units units = this.getParent().getXAxis().getUnits();
                Units units2 = this.getParent().getYAxis().getUnits();
                Units units3 = this.getColorBar().getUnits();
                double[] dArray2 = dArray = new double[0];
                double[][] dArrayArray = new double[][]{dArray};
                DefaultTableDataSet defaultTableDataSet = new DefaultTableDataSet(dArray2, units, dArray, units2, dArrayArray, units3, Collections.EMPTY_MAP);
                this.plotImage = null;
                defaultTableDataSet = null;
                this.getParent().repaint();
                return;
            }
            RebinDescriptor rebinDescriptor = new RebinDescriptor(dasAxis.getDataMinimum(), dasAxis.getDataMaximum(), n, dasAxis.isLog());
            RebinDescriptor rebinDescriptor2 = new RebinDescriptor(dasAxis2.getDataMinimum(), dasAxis2.getDataMaximum(), n2, dasAxis2.isLog());
            DataSetRebinner dataSetRebinner = this.rebinnerEnum.getRebinner();
            TableDataSet tableDataSet = (TableDataSet)dataSetRebinner.rebin(this.getDataSet(), rebinDescriptor, rebinDescriptor2);
            int n3 = 0;
            int n4 = tableDataSet.getYLength(n3);
            int n5 = tableDataSet.tableEnd(n3) - tableDataSet.tableStart(n3);
            int n6 = tableDataSet.tableStart(n3);
            while (n6 < tableDataSet.tableEnd(n3)) {
                int n7 = 0;
                while (n7 < tableDataSet.getYLength(0)) {
                    int n8 = n6 - tableDataSet.tableStart(n3) + (n4 - n7 - 1) * n5;
                    nArray[n8] = this.colorBar.itransform(tableDataSet.getDouble(n6, n7, tableDataSet.getZUnits()), tableDataSet.getZUnits());
                    ++n7;
                }
                ++n6;
            }
            MemoryImageSource memoryImageSource = new MemoryImageSource(n, n2, nArray, 0, n);
            this.plotImage = this.getParent().createImage(memoryImageSource);
            if (this.isSliceRebinnedData()) {
                DasApplication.getDefaultApplication().getLogger().fine("slicing rebin data");
                this.ds = tableDataSet;
            }
        }
        finally {
            if (dasProgressMonitor != null) {
                if (dasProgressMonitor.isCancelled()) {
                    return;
                }
                dasProgressMonitor.finished();
            }
            this.getParent().repaint();
        }
    }

    protected void installRenderer() {
        if (this.parent != null && this.parent.getCanvas() != null && this.colorBar != null) {
            Object object;
            if (this.colorBar.getColumn() == null) {
                object = this.parent.getColumn();
                double d = ((DasDevicePosition)object).getMaximum() - ((DasDevicePosition)object).getMinimum();
                double d2 = ((DasDevicePosition)object).getMaximum() + d / 5.0;
                double d3 = d2 + d / 10.0;
                if (d3 > 1.0 - d / 5.0) {
                    double d4 = (1.0 - ((DasDevicePosition)object).getMaximum()) / 3.0;
                    d2 = ((DasDevicePosition)object).getMaximum() + d4 / 2.0;
                    d3 = d2 + d4;
                }
                this.colorBar.setColumn(new DasColumn(this.parent.getCanvas(), d2, d3));
            }
            this.parent.getCanvas().add(this.colorBar, this.parent.getRow(), this.colorBar.getColumn());
            if (!"true".equals(System.getProperty("java.awt.headless"))) {
                object = this.parent.mouseAdapter;
                VerticalSpectrogramSlicer verticalSpectrogramSlicer = VerticalSpectrogramSlicer.createSlicer(this.parent, this);
                VerticalSlicerMouseModule verticalSlicerMouseModule = VerticalSlicerMouseModule.create(this);
                verticalSlicerMouseModule.addDataPointSelectionListener(verticalSpectrogramSlicer);
                ((DasMouseInputAdapter)object).addMouseModule(verticalSlicerMouseModule);
                HorizontalSpectrogramSlicer horizontalSpectrogramSlicer = HorizontalSpectrogramSlicer.createSlicer(this.parent, this);
                HorizontalSlicerMouseModule horizontalSlicerMouseModule = HorizontalSlicerMouseModule.create(this);
                horizontalSlicerMouseModule.addDataPointSelectionListener(horizontalSpectrogramSlicer);
                ((DasMouseInputAdapter)object).addMouseModule(horizontalSlicerMouseModule);
                VerticalSpectrogramAverager verticalSpectrogramAverager = VerticalSpectrogramAverager.createAverager(this.parent, this);
                HorizontalDragRangeSelectorMouseModule horizontalDragRangeSelectorMouseModule = new HorizontalDragRangeSelectorMouseModule(this.parent, this, this.parent.getXAxis());
                horizontalDragRangeSelectorMouseModule.addDataRangeSelectionListener(verticalSpectrogramAverager);
                ((DasMouseInputAdapter)object).addMouseModule(horizontalDragRangeSelectorMouseModule);
                CrossHairMouseModule crossHairMouseModule = new CrossHairMouseModule(this.parent, this, this.parent.getXAxis(), this.parent.getYAxis());
                ((DasMouseInputAdapter)object).addMouseModule(crossHairMouseModule);
            }
        }
    }

    protected void uninstallRenderer() {
        if (this.colorBar != null && this.colorBar.getCanvas() != null) {
            this.colorBar.getCanvas().remove(this.colorBar);
        }
    }

    public static SpectrogramRenderer processSpectrogramElement(Element element, DasPlot dasPlot, FormBase formBase) throws DasPropertyException, DasNameException, ParseException {
        Object object;
        String string = element.getAttribute("dataSetID");
        DasColorBar dasColorBar = null;
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            object = nodeList.item(n);
            if (object instanceof Element && object.getNodeName().equals("zAxis")) {
                dasColorBar = SpectrogramRenderer.processZAxisElement((Element)object, formBase);
            }
            ++n;
        }
        if (dasColorBar == null) {
            try {
                dasColorBar = (DasColorBar)formBase.checkValue(element.getAttribute("colorbar"), class$edu$uiowa$physics$pw$das$graph$DasColorBar == null ? (class$edu$uiowa$physics$pw$das$graph$DasColorBar = SpectrogramRenderer.class$("edu.uiowa.physics.pw.das.graph.DasColorBar")) : class$edu$uiowa$physics$pw$das$graph$DasColorBar, "<colorbar>");
            }
            catch (DasPropertyException dasPropertyException) {
                dasPropertyException.setPropertyName("colorbar");
                throw dasPropertyException;
            }
        }
        object = new SpectrogramRenderer(dasPlot, null, dasColorBar);
        try {
            ((Renderer)object).setDataSetID(string);
        }
        catch (DasException dasException) {
            DasExceptionHandler.handle(dasException);
        }
        return object;
    }

    private static DasColorBar processZAxisElement(Element element, FormBase formBase) throws DasPropertyException, DasNameException, ParseException {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element && node.getNodeName().equals("colorbar")) {
                return DasColorBar.processColorbarElement((Element)node, formBase);
            }
            ++n;
        }
        return null;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("spectrogram");
        element.setAttribute("dataSetID", this.getDataSetID());
        Element element2 = document.createElement("zAxis");
        Element element3 = this.getColorBar().getDOMElement(document);
        if (element3.getAttribute("row").equals(this.getParent().getRow().getDasName())) {
            element3.removeAttribute("row");
        }
        if (element3.getAttribute("column").equals(this.getParent().getColumn().getDasName())) {
            element3.removeAttribute("column");
        }
        element2.appendChild(element3);
        element.appendChild(element2);
        return element;
    }

    public RebinnerEnum getRebinner() {
        return this.rebinnerEnum;
    }

    public void setRebinner(RebinnerEnum rebinnerEnum) {
        this.rebinnerEnum = rebinnerEnum;
        this.refreshImage();
    }

    public boolean isSliceRebinnedData() {
        return this.sliceRebinnedData;
    }

    public void setSliceRebinnedData(boolean bl) {
        this.sliceRebinnedData = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class RebinnerEnum
    implements Enumeration {
        DataSetRebinner rebinner;
        String label;
        public static final RebinnerEnum binAverage = new RebinnerEnum(new AverageTableRebinner(), "binAverage");
        public static final RebinnerEnum nearestNeighbor = new RebinnerEnum(new NearestNeighborTableRebinner(), "nearestNeighbor");
        public static final RebinnerEnum binAverageNoInterpolate;

        private RebinnerEnum(DataSetRebinner dataSetRebinner, String string) {
            this.rebinner = dataSetRebinner;
            this.label = string;
        }

        public Icon getListIcon() {
            return null;
        }

        public String toString() {
            return this.label;
        }

        DataSetRebinner getRebinner() {
            return this.rebinner;
        }

        static {
            AverageTableRebinner averageTableRebinner = new AverageTableRebinner();
            averageTableRebinner.setInterpolate(false);
            binAverageNoInterpolate = new RebinnerEnum(averageTableRebinner, "noInterpolate");
        }
    }

    protected class RebinListener
    implements PropertyChangeListener {
        protected RebinListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SpectrogramRenderer.this.update();
        }
    }
}

