/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorUtil;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.Psym;
import edu.uiowa.physics.pw.das.graph.PsymConnector;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.graph.SymColor;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SymbolLineRenderer
extends Renderer {
    private Psym psym = Psym.DOTS;
    private double symSize = 1.0;
    private float lineWidth = 1.5f;
    private SymColor color = SymColor.black;
    private PsymConnector psymConnector = PsymConnector.SOLID;
    private long lastUpdateMillis;
    private boolean antiAliased = "on".equals(DasProperties.getInstance().get("antiAlias"));

    public SymbolLineRenderer(DataSet dataSet) {
        super(dataSet);
    }

    public SymbolLineRenderer(DataSetDescriptor dataSetDescriptor) {
        super(dataSetDescriptor);
    }

    public void render(Graphics graphics, DasAxis dasAxis, DasAxis dasAxis2) {
        double d;
        Object object;
        int n;
        double d2;
        double d3;
        double d4;
        double d5;
        long l = System.currentTimeMillis();
        VectorDataSet vectorDataSet = (VectorDataSet)this.getDataSet();
        if (vectorDataSet == null || vectorDataSet.getXLength() == 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        if (this.antiAliased) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        Units units = dasAxis.getUnits();
        Units units2 = dasAxis2.getUnits();
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            d5 = dasAxis.getDataMaximum().doubleValue(units);
            d4 = dasAxis.getDataMinimum().doubleValue(units);
            d3 = dasAxis2.getDataMaximum().doubleValue(units2);
            d2 = dasAxis2.getDataMinimum().doubleValue(units2);
        } else {
            d4 = dasAxis.invTransform((int)rectangle.getX()).doubleValue(units);
            d5 = dasAxis.invTransform((int)(rectangle.getX() + rectangle.getWidth())).doubleValue(units);
            d2 = dasAxis2.invTransform((int)rectangle.getY()).doubleValue(units2);
            d3 = dasAxis2.invTransform((int)(rectangle.getY() + rectangle.getHeight())).doubleValue(units2);
        }
        int n2 = VectorUtil.closestXTag(vectorDataSet, d4, units);
        if (n2 > 0) {
            --n2;
        }
        if ((n = VectorUtil.closestXTag(vectorDataSet, d5, units)) < vectorDataSet.getXLength() - 1) {
            ++n;
        }
        graphics2D.setColor(this.color.toColor());
        if (vectorDataSet.getProperty("xSampleWidth") != null) {
            object = (Datum)vectorDataSet.getProperty("xSampleWidth");
            d = ((Datum)object).doubleValue(units.getOffsetUnits());
        } else {
            object = (String)vectorDataSet.getProperty("x_sample_width");
            if (object != null) {
                double d6 = Double.parseDouble((String)object);
                d = Units.seconds.convertDoubleTo(units.getOffsetUnits(), d6);
            } else {
                d = 1.0E31;
            }
        }
        if (this.psymConnector != PsymConnector.NONE) {
            double d7 = vectorDataSet.getXTagDouble(n2, units);
            double d8 = vectorDataSet.getDouble(n2, units2);
            int n3 = dasAxis.transform(d7, units);
            int n4 = dasAxis2.transform(d8, units2);
            int n5 = n2 + 1;
            while (n5 <= n) {
                double d9 = vectorDataSet.getXTagDouble(n5, units);
                double d10 = vectorDataSet.getDouble(n5, units2);
                int n6 = dasAxis.transform(d9, units);
                int n7 = dasAxis2.transform(d10, units2);
                if (!units2.isFill(d10)) {
                    if (!units2.isFill(d8) && Math.abs(d9 - d7) < d) {
                        this.psymConnector.drawLine(graphics2D, n3, n4, n6, n7, this.lineWidth);
                    }
                    d7 = d9;
                    d8 = d10;
                    n3 = n6;
                    n4 = n7;
                }
                ++n5;
            }
            graphics2D.setStroke(new BasicStroke(1.0f));
        }
        int n8 = n2;
        while (n8 <= n) {
            if (!units2.isFill(vectorDataSet.getDouble(n8, units2))) {
                int n9 = dasAxis.transform(vectorDataSet.getXTagDouble(n8, units), units);
                int n10 = dasAxis2.transform(vectorDataSet.getDouble(n8, units2), units2);
                this.psym.draw(graphics2D, n9, n10, (float)this.symSize);
            }
            ++n8;
        }
        long l2 = System.currentTimeMillis();
        DasProperties.getLogger().finer("render: " + (l2 - l) + " total:" + (l2 - this.lastUpdateMillis) + " fps:" + 1000.0 / (double)(l2 - this.lastUpdateMillis));
        this.lastUpdateMillis = l2;
        graphics2D.setRenderingHints(renderingHints);
    }

    public void updatePlotImage(DasAxis dasAxis, DasAxis dasAxis2, DasProgressMonitor dasProgressMonitor) {
    }

    public Psym getPsym() {
        return this.psym;
    }

    public void setPsym(Psym psym) {
        if (psym == null) {
            throw new NullPointerException("psym cannot be null");
        }
        Psym psym2 = this.psym;
        this.psym = psym;
        this.refreshImage();
    }

    public double getSymSize() {
        return this.symSize;
    }

    public void setSymSize(double d) {
        this.symSize = d;
        this.setPsym(this.psym);
        this.refreshImage();
    }

    public SymColor getColor() {
        return this.color;
    }

    public void setColor(SymColor symColor) {
        this.color = symColor;
        this.refreshImage();
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float f) {
        this.lineWidth = f;
        this.refreshImage();
    }

    protected void installRenderer() {
    }

    protected void uninstallRenderer() {
    }

    public static SymbolLineRenderer processLinePlotElement(Element element, DasPlot dasPlot, FormBase formBase) {
        String string = element.getAttribute("dataSetID");
        Psym psym = Psym.parsePsym(element.getAttribute("psym"));
        SymColor symColor = SymColor.parseSymColor(element.getAttribute("color"));
        SymbolLineRenderer symbolLineRenderer = new SymbolLineRenderer((DataSet)null);
        dasPlot.addRenderer(symbolLineRenderer);
        float f = Float.parseFloat(element.getAttribute("lineWidth"));
        try {
            symbolLineRenderer.setDataSetID(string);
        }
        catch (DasException dasException) {
            DasExceptionHandler.handle(dasException);
        }
        symbolLineRenderer.setPsym(psym);
        symbolLineRenderer.setColor(symColor);
        symbolLineRenderer.setLineWidth(f);
        return symbolLineRenderer;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("lineplot");
        element.setAttribute("dataSetID", this.getDataSetID());
        element.setAttribute("psym", this.getPsym().toString());
        element.setAttribute("color", this.getColor().toString());
        return element;
    }

    public PsymConnector getPsymConnector() {
        return this.psymConnector;
    }

    public void setPsymConnector(PsymConnector psymConnector) {
        this.psymConnector = psymConnector;
        this.refreshImage();
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean bl) {
        this.antiAliased = bl;
        this.refreshImage();
    }
}

