/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.components.propertyeditor.Enumeration;
import edu.uiowa.physics.pw.das.dataset.ConstantDataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.graph.TickVDescriptor;
import edu.uiowa.physics.pw.das.util.DasMath;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import javax.swing.Icon;

public class TickCurveRenderer
extends Renderer {
    private Stroke stroke;
    TickVDescriptor tickv;
    private String xplane;
    private String yplane;
    private VectorDataSet xds;
    private VectorDataSet yds;
    private Units xunits;
    private Units yunits;
    private double[][] idata;
    private TickStyle tickStyle;
    private double lineWidth;
    private float tickLength;

    public TickCurveRenderer(DataSetDescriptor dataSetDescriptor, String string, String string2, TickVDescriptor tickVDescriptor) {
        super(dataSetDescriptor);
        this.setTickStyle(TickStyle.outer);
        this.setLineWidth(1.0);
        this.setTickLength(8.0f);
        this.xplane = string;
        this.yplane = string2;
        this.tickv = tickVDescriptor;
    }

    protected void uninstallRenderer() {
    }

    protected void installRenderer() {
    }

    private static double length(Line2D line2D) {
        double d = line2D.getX2() - line2D.getX1();
        double d2 = line2D.getY2() - line2D.getY1();
        double d3 = Math.sqrt(d * d + d2 * d2);
        return d3;
    }

    private static Line2D normalize(Line2D line2D, double d) {
        Point2D point2D = line2D.getP1();
        double d2 = line2D.getX2() - line2D.getX1();
        double d3 = line2D.getY2() - line2D.getY1();
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        Line2D line2D2 = (Line2D)line2D.clone();
        line2D2.setLine(point2D.getX(), point2D.getY(), point2D.getX() + d2 / d4 * d, point2D.getY() + d3 / d4 * d);
        return line2D2;
    }

    private double turnDir(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d3 - d;
        double d8 = d5 - d3;
        double d9 = d4 - d2;
        double d10 = d6 - d4;
        return d7 * d10 - d8 * d9;
    }

    private double turnDirAt(double d) {
        int n = this.xds.getXLength();
        int n2 = d < 1.0 ? 0 : (d > (double)(n - 2) ? n - 3 : (int)Math.floor(d) - 1);
        int n3 = n2 + 1;
        int n4 = n3 + 1;
        return this.turnDir(this.xds.getDouble(n2, this.xunits), this.yds.getDouble(n2, this.yunits), this.xds.getDouble(n3, this.xunits), this.yds.getDouble(n3, this.yunits), this.xds.getDouble(n4, this.xunits), this.yds.getDouble(n4, this.yunits));
    }

    private Line2D outsideNormalAt(double d) {
        double d2;
        double d3;
        double d4;
        int n = this.xds.getXLength();
        int n2 = (int)Math.floor(d);
        if (n2 == n - 1) {
            --n2;
        }
        double d5 = this.idata[0][n2];
        double d6 = this.idata[0][n2 + 1];
        double d7 = this.idata[1][n2];
        double d8 = this.idata[1][n2 + 1];
        double d9 = DasMath.interpolate(this.idata[0], d);
        double d10 = DasMath.interpolate(this.idata[1], d);
        double d11 = d6 - d5;
        double d12 = d8 - d7;
        double d13 = this.turnDirAt(d);
        if (d13 * (d4 = -1.0 * (d11 * (d3 = -d11) - (d2 = d12) * d12)) > 0.0) {
            d2 = -d12;
            d3 = d11;
        }
        return TickCurveRenderer.normalize(new Line2D.Double(d9, d10, d9 + d2, d10 + d3), 1.0);
    }

    private void drawTick(Graphics2D graphics2D, double d) {
        float f = this.getTickLength() * 2.0f / 3.0f;
        Line2D line2D = TickCurveRenderer.normalize(this.outsideNormalAt(d), f);
        graphics2D.draw(line2D);
        if (this.tickStyle == TickStyle.both) {
            graphics2D.draw(TickCurveRenderer.normalize(line2D, -f));
        }
    }

    private double slope(Line2D line2D) {
        return (line2D.getY2() - line2D.getY1()) / (line2D.getX2() - line2D.getX1());
    }

    private void drawLabelTick(Graphics2D graphics2D, double d, String string) {
        double d2;
        double d3;
        float f = this.getTickLength();
        Line2D line2D = TickCurveRenderer.normalize(this.outsideNormalAt(d), f);
        graphics2D.draw(line2D);
        if (this.tickStyle == TickStyle.both) {
            graphics2D.draw(TickCurveRenderer.normalize(line2D, -f));
        }
        double d4 = this.slope(line2D);
        double d5 = graphics2D.getFontMetrics().stringWidth(string);
        double d6 = graphics2D.getFontMetrics().getAscent();
        double d7 = d6 / d5;
        line2D = TickCurveRenderer.normalize(line2D, TickCurveRenderer.length(line2D) + 2.0);
        if (d7 > Math.abs(d4)) {
            if (line2D.getX2() > line2D.getX1()) {
                double d8 = d4 * d5 / 2.0;
                d3 = line2D.getX2();
                d2 = line2D.getY2() + d6 / 2.0 + d8;
            } else {
                double d9 = -d4 * d5 / 2.0;
                d3 = line2D.getX2() - d5;
                d2 = line2D.getY2() + d6 / 2.0 + d9;
            }
        } else if (line2D.getY2() < line2D.getY1()) {
            double d10 = -d6 / d4 / 2.0;
            d3 = line2D.getX2() + d10 - d5 / 2.0;
            d2 = line2D.getY2();
        } else {
            double d11 = d6 / d4 / 2.0;
            d3 = line2D.getX2() + d11 - d5 / 2.0;
            d2 = line2D.getY2() + d6;
        }
        graphics2D.drawString(string, (float)d3, (float)d2);
    }

    public void render(Graphics graphics, DasAxis dasAxis, DasAxis dasAxis2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(this.stroke);
        DataSet dataSet = this.getDataSet();
        this.xds = (VectorDataSet)dataSet.getPlanarView(this.xplane);
        this.yds = (VectorDataSet)dataSet.getPlanarView(this.yplane);
        this.xunits = this.xds.getYUnits();
        this.yunits = this.yds.getYUnits();
        this.idata = new double[2][this.xds.getXLength()];
        int n = 0;
        while (n < this.xds.getXLength()) {
            this.idata[0][n] = dasAxis.transform(this.xds.getDouble(n, this.xunits), this.xunits);
            this.idata[1][n] = dasAxis2.transform(this.yds.getDouble(n, this.yunits), this.yunits);
            ++n;
        }
        int n2 = 1;
        while (n2 < this.xds.getXLength()) {
            graphics2D.drawLine((int)this.idata[0][n2 - 1], (int)this.idata[1][n2 - 1], (int)this.idata[0][n2], (int)this.idata[1][n2]);
            ++n2;
        }
        double[] dArray = DasMath.findex(VectorUtil.getXTagArrayDouble(this.xds, this.xds.getXUnits()), this.tickv.minorTickV);
        int n3 = 0;
        while (n3 < this.tickv.minorTickV.length) {
            this.drawTick(graphics2D, dArray[n3]);
            ++n3;
        }
        dArray = DasMath.findex(VectorUtil.getXTagArrayDouble(this.xds, this.xds.getXUnits()), this.tickv.tickV);
        int n4 = 0;
        while (n4 < this.tickv.tickV.length) {
            String string = this.tickv.units.createDatum(this.tickv.tickV[n4]).toString();
            this.drawLabelTick(graphics2D, dArray[n4], string);
            ++n4;
        }
    }

    public void updatePlotImage(DasAxis dasAxis, DasAxis dasAxis2) {
    }

    private static String lineToString(Line2D line2D) {
        return "" + line2D.getX1() + " " + line2D.getY1() + " " + line2D.getX2() + " " + line2D.getY2();
    }

    public TickStyle getTickStyle() {
        return this.tickStyle;
    }

    public void setTickStyle(TickStyle tickStyle) {
        this.tickStyle = tickStyle;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double d) {
        this.lineWidth = d;
        this.stroke = new BasicStroke((float)d);
    }

    public float getTickLength() {
        return this.tickLength;
    }

    public void setTickLength(float f) {
        this.tickLength = f;
    }

    public DataSet getDataSet() {
        DataSetDescriptor dataSetDescriptor = this.getDataSetDescriptor();
        if (!(dataSetDescriptor instanceof ConstantDataSetDescriptor)) {
            throw new IllegalStateException("only ConstantDataSetDescriptors for now!");
        }
        try {
            return dataSetDescriptor.getDataSet(null, null, null, null);
        }
        catch (DasException dasException) {
            throw new RuntimeException(dasException);
        }
    }

    public void updatePlotImage(DasAxis dasAxis, DasAxis dasAxis2, DasProgressMonitor dasProgressMonitor) {
    }

    public static class TickStyle
    implements Enumeration {
        private String name;
        public static TickStyle outer = new TickStyle("Outer");
        public static TickStyle both = new TickStyle("Both");

        private TickStyle(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }

        public Icon getListIcon() {
            return null;
        }
    }
}

