/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.datum.format.TimeDatumFormatter;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.DataRange;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TimeRangeLabel
extends DasCanvasComponent {
    private static final DatumFormatter MINUTES;
    private static final DatumFormatter SECONDS;
    private static final DatumFormatter MILLESECONDS;
    private DataRange dataRange;
    private DatumFormatter df;

    public TimeRangeLabel(DataRange dataRange) {
        this.dataRange = dataRange;
        DataRangePropertyChangeListener dataRangePropertyChangeListener = new DataRangePropertyChangeListener();
        dataRange.addPropertyChangeListener("minimum", dataRangePropertyChangeListener);
        dataRange.addPropertyChangeListener("maximum", dataRangePropertyChangeListener);
        this.updateFormatter();
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHints(DasProperties.getRenderingHints());
        Datum datum = Datum.create(this.dataRange.getMinimum(), this.dataRange.getUnits());
        Datum datum2 = Datum.create(this.dataRange.getMaximum(), this.dataRange.getUnits());
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = this.getRow().getDMinimum();
        int n2 = this.getColumn().getDMinimum();
        graphics2D.translate(-this.getX(), -this.getY());
        graphics2D.drawString(this.df.format(datum), n2, n - fontMetrics.getHeight() / 2);
        String string = this.df.format(datum2);
        graphics2D.drawString(string, n2 + this.getColumn().getWidth() - fontMetrics.stringWidth(string), n - fontMetrics.getHeight() / 2);
    }

    public void resize() {
        Rectangle rectangle = new Rectangle(this.getColumn().getDMinimum() - 30, this.getRow().getDMinimum() - 30, this.getColumn().getWidth() + 60, 30);
        this.setBounds(rectangle);
    }

    private void updateFormatter() {
        UnitsConverter unitsConverter = Units.getConverter(this.dataRange.getUnits(), Units.t2000);
        double d = unitsConverter.convert(this.dataRange.getMinimum());
        double d2 = unitsConverter.convert(this.dataRange.getMinimum());
        d = this.secondsSinceMidnight(d);
        d2 = this.secondsSinceMidnight(d2);
        int n = (int)(d * 1000.0);
        int n2 = (int)(d2 * 1000.0);
        this.df = n % 1000 != 0 || n2 % 1000 != 0 ? MILLESECONDS : (n % 60000 != 0 || n2 % 60000 != 0 ? SECONDS : MINUTES);
    }

    private double secondsSinceMidnight(double d) {
        if (d < 0.0) {
            if ((d %= 86400.0) == 0.0) {
                return 0.0;
            }
            return 86400.0 + d;
        }
        return d % 86400.0;
    }

    public PropertyChangeListener createDataRangePropertyListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getOldValue();
                Object object2 = propertyChangeEvent.getNewValue();
                if (string.equals("log")) {
                    TimeRangeLabel.this.update();
                    TimeRangeLabel.this.firePropertyChange("log", object, object2);
                } else if (string.equals("minimum")) {
                    TimeRangeLabel.this.update();
                    TimeRangeLabel.this.updateFormatter();
                    TimeRangeLabel.this.firePropertyChange("dataMinimum", object, object2);
                } else if (string.equals("maximum")) {
                    TimeRangeLabel.this.update();
                    TimeRangeLabel.this.updateFormatter();
                    TimeRangeLabel.this.firePropertyChange("dataMaximum", object, object2);
                }
                TimeRangeLabel.this.markDirty();
            }
        };
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        JPanel jPanel = new JPanel();
        DasCanvas dasCanvas = new DasCanvas(300, 300);
        DasRow dasRow = new DasRow(dasCanvas, 0.1, 0.2);
        DasRow dasRow2 = new DasRow(dasCanvas, 0.3, 0.4);
        DasRow dasRow3 = new DasRow(dasCanvas, 0.5, 0.6);
        DasRow dasRow4 = new DasRow(dasCanvas, 0.7, 0.8);
        DasColumn dasColumn = new DasColumn(dasCanvas, 0.1, 0.9);
        DataRange dataRange = new DataRange(null, TimeUtil.createValid("1998-01-01 12:20"), TimeUtil.createValid("1999-01-01"), false);
        DataRange dataRange2 = new DataRange(null, TimeUtil.createValid("1998-01-02 12:30:02"), TimeUtil.createValid("1999-01-01"), false);
        DataRange dataRange3 = new DataRange(null, TimeUtil.createValid("1998-01-03 12:40:02.244"), TimeUtil.createValid("1999-01-01"), false);
        dasCanvas.add(new TimeRangeLabel(dataRange), dasRow, dasColumn);
        dasCanvas.add(new TimeRangeLabel(dataRange2), dasRow2, dasColumn);
        dasCanvas.add(new TimeRangeLabel(dataRange3), dasRow3, dasColumn);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)dasCanvas, "Center");
        jFrame.setContentPane(jPanel);
        jFrame.pack();
        jFrame.setVisible(true);
        dasCanvas.repaint();
    }

    static {
        try {
            MINUTES = new TimeDatumFormatter("yyyy-MM-dd '('DDD')' HH:mm");
            SECONDS = new TimeDatumFormatter("yyyy-MM-dd '('DDD')' HH:mm:ss");
            MILLESECONDS = new TimeDatumFormatter("yyyy-MM-dd '('DDD')' HH:mm:ss.SSS");
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }

    private class mouseModule
    extends MouseModule {
        private mouseModule() {
        }
    }

    private class DataRangePropertyChangeListener
    implements PropertyChangeListener {
        private DataRangePropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            TimeRangeLabel.this.repaint();
        }
    }
}

