/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.stream;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.stream.SkeletonDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamMultiYDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamXDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamYScanDescriptor;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PacketDescriptor
implements Cloneable {
    private StreamXDescriptor xDescriptor;
    private SkeletonDescriptor[] yDescriptors = new SkeletonDescriptor[6];
    private int yCount = 0;
    private static final Pattern LABEL_PATTERN = Pattern.compile("\\s*label\\((\\d+)\\)\\s*");

    public PacketDescriptor(Element element) {
        if (element.getTagName().equals("packet")) {
            this.processElement(element);
        } else {
            this.processLegacyElement(element);
        }
    }

    private void processElement(Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                SkeletonDescriptor skeletonDescriptor;
                Element element2 = (Element)node;
                String string = element2.getTagName();
                if (string.equals("x")) {
                    this.xDescriptor = new StreamXDescriptor(element2);
                } else if (string.equals("y")) {
                    skeletonDescriptor = new StreamMultiYDescriptor(element2);
                    this.addYDescriptor(skeletonDescriptor);
                } else if (string.equals("yscan")) {
                    skeletonDescriptor = new StreamYScanDescriptor(element2);
                    this.addYDescriptor(skeletonDescriptor);
                }
            }
            ++n;
        }
    }

    private void processLegacyElement(Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                SkeletonDescriptor skeletonDescriptor;
                Element element2 = (Element)node;
                String string = element2.getTagName();
                if (string.equals("X")) {
                    this.xDescriptor = new StreamXDescriptor(element2);
                } else if (string.equals("YScan")) {
                    skeletonDescriptor = new StreamYScanDescriptor(element2);
                    this.addYDescriptor(skeletonDescriptor);
                } else if (string.equals("MultiY")) {
                    skeletonDescriptor = new StreamMultiYDescriptor(element2);
                    this.addYDescriptor(skeletonDescriptor);
                }
            }
            ++n;
        }
    }

    public PacketDescriptor() {
    }

    public StreamXDescriptor getXDescriptor() {
        return this.xDescriptor;
    }

    public void setXDescriptor(StreamXDescriptor streamXDescriptor) {
        this.xDescriptor = streamXDescriptor;
    }

    public void addYDescriptor(SkeletonDescriptor skeletonDescriptor) {
        if (this.yCount == this.yDescriptors.length) {
            SkeletonDescriptor[] skeletonDescriptorArray = new SkeletonDescriptor[this.yCount * 2];
            System.arraycopy(this.yDescriptors, 0, skeletonDescriptorArray, 0, this.yCount);
            this.yDescriptors = skeletonDescriptorArray;
        }
        this.yDescriptors[this.yCount] = skeletonDescriptor;
        ++this.yCount;
    }

    public int getYCount() {
        return this.yCount;
    }

    public List getYDescriptors() {
        return Collections.unmodifiableList(Arrays.asList(this.yDescriptors).subList(0, this.yCount));
    }

    public SkeletonDescriptor getYDescriptor(int n) {
        if (n < 0 || n >= this.yCount) {
            throw new IndexOutOfBoundsException("index = " + n + ", yCount = " + this.yCount);
        }
        return this.yDescriptors[n];
    }

    public int getSizeBytes() {
        int n = this.xDescriptor.getSizeBytes();
        int n2 = 0;
        while (n2 < this.yCount) {
            n += this.yDescriptors[n2].getSizeBytes();
            ++n2;
        }
        return n;
    }

    public DatumVector[] read(ByteBuffer byteBuffer) {
        DatumVector[] datumVectorArray = new DatumVector[this.yCount + 1];
        datumVectorArray[0] = this.xDescriptor.read(byteBuffer);
        int n = 0;
        while (n < this.yCount) {
            datumVectorArray[n + 1] = this.yDescriptors[n].read(byteBuffer);
            ++n;
        }
        return datumVectorArray;
    }

    public void write(Datum datum, DatumVector[] datumVectorArray, ByteBuffer byteBuffer) {
        this.xDescriptor.writeDatum(datum, byteBuffer);
        int n = 0;
        while (n < this.yCount) {
            this.yDescriptors[n].write(datumVectorArray[n], byteBuffer);
            ++n;
        }
        if (this.yDescriptors[this.yCount - 1] instanceof StreamYScanDescriptor && ((StreamYScanDescriptor)this.yDescriptors[this.yCount - 1]).getDataTransferType().isAscii() && Character.isWhitespace((char)byteBuffer.get(byteBuffer.position() - 1))) {
            byteBuffer.put(byteBuffer.position() - 1, (byte)10);
        } else if (this.yDescriptors[this.yCount - 1] instanceof StreamMultiYDescriptor && ((StreamMultiYDescriptor)this.yDescriptors[this.yCount - 1]).getDataTransferType().isAscii() && Character.isWhitespace((char)byteBuffer.get(byteBuffer.position() - 1))) {
            byteBuffer.put(byteBuffer.position() - 1, (byte)10);
        }
    }

    private static String trimComment(String string) {
        int n = string.indexOf(59);
        if (n == 0) {
            return "";
        }
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static PacketDescriptor createLegacyPacketDescriptor(Map map) {
        PacketDescriptor packetDescriptor = new PacketDescriptor();
        packetDescriptor.setXDescriptor(new StreamXDescriptor());
        if (map.get("form").equals("x_tagged_y_scan")) {
            StreamYScanDescriptor streamYScanDescriptor = new StreamYScanDescriptor();
            streamYScanDescriptor.setYCoordinates((double[])map.get("y_coordinate"));
            packetDescriptor.addYDescriptor(streamYScanDescriptor);
        } else if (map.get("form").equals("x_multi_y") && map.get("ny") != null) {
            StreamMultiYDescriptor streamMultiYDescriptor = new StreamMultiYDescriptor();
            packetDescriptor.addYDescriptor(streamMultiYDescriptor);
        } else if (map.get("form").equals("x_multi_y") && map.get("items") != null) {
            List list = (List)map.get("plane-list");
            packetDescriptor.addYDescriptor(new StreamMultiYDescriptor());
            int n = 0;
            while (n < list.size()) {
                StreamMultiYDescriptor streamMultiYDescriptor = new StreamMultiYDescriptor();
                streamMultiYDescriptor.setName((String)list.get(n));
                packetDescriptor.addYDescriptor(streamMultiYDescriptor);
                ++n;
            }
        }
        return packetDescriptor;
    }

    private static String[] ensureCapacity(String[] stringArray, int n) {
        if (stringArray == null) {
            return new String[n];
        }
        if (stringArray.length >= n) {
            return stringArray;
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("packet");
        element.appendChild(this.xDescriptor.getDOMElement(document));
        int n = 0;
        while (n < this.yCount) {
            element.appendChild(this.yDescriptors[n].getDOMElement(document));
            ++n;
        }
        return element;
    }

    public Object clone() {
        try {
            PacketDescriptor packetDescriptor = (PacketDescriptor)super.clone();
            packetDescriptor.xDescriptor = (StreamXDescriptor)this.xDescriptor.clone();
            packetDescriptor.yDescriptors = new SkeletonDescriptor[this.yCount];
            int n = 0;
            while (n < this.yCount) {
                packetDescriptor.yDescriptors[n] = (SkeletonDescriptor)this.yDescriptors[n].clone();
                ++n;
            }
            return packetDescriptor;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public String toString() {
        String string = "<packet>\n";
        int n = 0;
        while (n < this.yCount) {
            string = string + this.yDescriptors[n].toString() + "\n";
            ++n;
        }
        string = string + "</packet>\n";
        return string;
    }
}

