/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.stream;

import edu.uiowa.physics.pw.das.datum.Units;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

public final class PropertyType {
    private static final Map map = new HashMap();
    public static final PropertyType DOUBLE = new PropertyType("double");
    public static final PropertyType DOUBLE_ARRAY = new PropertyType("doubleArray");
    public static final PropertyType DATUM = new PropertyType("Datum");
    private final String name;

    public static PropertyType getByName(String string) {
        return (PropertyType)map.get(string);
    }

    private PropertyType(String string) {
        this.name = string;
        map.put(string, this);
    }

    public Object parse(String string) throws ParseException {
        if (this.name.equals("double")) {
            try {
                return new Double(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(numberFormatException.getMessage(), 0);
            }
        }
        if (this.name.equals("doubleArray")) {
            try {
                String[] stringArray = string.split(",");
                double[] dArray = new double[stringArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    dArray[n] = Double.parseDouble(stringArray[n]);
                    ++n;
                }
                return dArray;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(numberFormatException.getMessage(), 0);
            }
        }
        if (this.name.equals("Datum")) {
            String[] stringArray = string.split("\\s+");
            if (stringArray.length == 1) {
                return Units.dimensionless.parse(stringArray[0]);
            }
            if (stringArray.length == 2) {
                Units units = Units.getByName(stringArray[1]);
                return units.parse(stringArray[0]);
            }
            throw new IllegalArgumentException("Too many tokens: '" + string + "'");
        }
        throw new IllegalStateException("unrecognized name: " + this.name);
    }

    public String toString() {
        return this.name;
    }
}

