/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.stream;

import edu.uiowa.physics.pw.das.DasProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public abstract class StreamProcessor {
    public abstract void process(InputStream var1, OutputStream var2) throws IOException;

    public InputStream process(final InputStream inputStream) throws IOException {
        final PipedOutputStream pipedOutputStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    StreamProcessor.this.process(inputStream, pipedOutputStream);
                    pipedOutputStream.close();
                }
                catch (IOException iOException) {
                    try {
                        pipedOutputStream.write(StreamProcessor.this.getDasExceptionStream(iOException));
                    }
                    catch (IOException iOException2) {
                        DasProperties.getLogger().severe(iOException2.toString());
                        throw new RuntimeException(iOException2);
                    }
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        return pipedInputStream;
    }

    public byte[] getDasExceptionStream(Throwable throwable) {
        String string = "[xx]<exception rootCause=\"" + throwable.toString() + "\"/>";
        return string.getBytes();
    }
}

