/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.stream;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.stream.PacketDescriptor;
import edu.uiowa.physics.pw.das.stream.SkeletonDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamException;
import edu.uiowa.physics.pw.das.stream.StreamHandler;
import edu.uiowa.physics.pw.das.stream.StreamMultiYDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamYScanDescriptor;
import edu.uiowa.physics.pw.das.util.DeflaterChannel;
import edu.uiowa.physics.pw.das.util.StreamTool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StreamProducer
implements StreamHandler {
    private Map descriptors = new IdentityHashMap();
    private WritableByteChannel stream;
    private ByteBuffer bigBuffer = ByteBuffer.allocate(4096);
    private byte[] six = new byte[6];
    private int nextAvailable = 1;
    private DocumentBuilder builder;

    public StreamProducer(WritableByteChannel writableByteChannel) {
        this.stream = writableByteChannel;
        try {
            this.builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
    }

    public void packet(PacketDescriptor packetDescriptor, Datum datum, DatumVector[] datumVectorArray) throws StreamException {
        try {
            String string = (String)this.descriptors.get(packetDescriptor);
            if (packetDescriptor.getSizeBytes() > this.bigBuffer.capacity()) {
                this.resizeBuffer(packetDescriptor.getSizeBytes() + packetDescriptor.getSizeBytes() >> 1);
            }
            if (packetDescriptor.getSizeBytes() + 4 > this.bigBuffer.remaining()) {
                this.flush();
            }
            this.six[3] = 58;
            this.six[0] = 58;
            this.six[1] = (byte)string.charAt(0);
            this.six[2] = (byte)string.charAt(1);
            this.bigBuffer.put(this.six, 0, 4);
            packetDescriptor.getXDescriptor().writeDatum(datum, this.bigBuffer);
            int n = 0;
            while (n < packetDescriptor.getYCount()) {
                packetDescriptor.getYDescriptor(n).write(datumVectorArray[n], this.bigBuffer);
                ++n;
            }
            int n2 = this.bigBuffer.position() - 1;
            SkeletonDescriptor skeletonDescriptor = packetDescriptor.getYDescriptor(packetDescriptor.getYCount() - 1);
            if ((skeletonDescriptor instanceof StreamYScanDescriptor && ((StreamYScanDescriptor)skeletonDescriptor).getDataTransferType().isAscii() || skeletonDescriptor instanceof StreamMultiYDescriptor && ((StreamMultiYDescriptor)skeletonDescriptor).getDataTransferType().isAscii()) && Character.isWhitespace((char)this.bigBuffer.get(n2))) {
                this.bigBuffer.put(n2, (byte)10);
            }
            this.bigBuffer.flip();
            this.stream.write(this.bigBuffer);
            this.bigBuffer.compact();
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    public void packetDescriptor(PacketDescriptor packetDescriptor) throws StreamException {
        try {
            String string = StreamProducer.toString2(this.nextAvailable++);
            this.descriptors.put(packetDescriptor, string);
            Document document = this.builder.newDocument();
            Element element = packetDescriptor.getDOMElement(document);
            document.appendChild(element);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "US-ASCII");
            StreamTool.formatHeader(document, outputStreamWriter);
            outputStreamWriter.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            int n = byArray.length;
            if (this.bigBuffer.remaining() < n + 10) {
                this.flush();
            }
            if (this.bigBuffer.capacity() < n + 10) {
                this.resizeBuffer(n + n / 2 + 15);
                System.err.println("length: " + n);
            }
            this.six[0] = 91;
            this.six[1] = (byte)string.charAt(0);
            this.six[2] = (byte)string.charAt(1);
            this.six[3] = 93;
            this.bigBuffer.put(this.six, 0, 4);
            this.six[0] = (byte)Character.forDigit(n / 100000 % 10, 10);
            this.six[1] = (byte)Character.forDigit(n / 10000 % 10, 10);
            this.six[2] = (byte)Character.forDigit(n / 1000 % 10, 10);
            this.six[3] = (byte)Character.forDigit(n / 100 % 10, 10);
            this.six[4] = (byte)Character.forDigit(n / 10 % 10, 10);
            this.six[5] = (byte)Character.forDigit(n % 10, 10);
            this.bigBuffer.put(this.six);
            this.bigBuffer.put(byArray);
            this.bigBuffer.flip();
            this.stream.write(this.bigBuffer);
            this.bigBuffer.compact();
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    public void resizeBuffer(int n) throws StreamException {
        this.flush();
        System.err.println("resizeBuffer(" + n + ")");
        this.bigBuffer = ByteBuffer.allocate(n);
    }

    public void streamClosed(StreamDescriptor streamDescriptor) throws StreamException {
        this.flush();
        try {
            this.stream.close();
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    public void streamDescriptor(StreamDescriptor streamDescriptor) throws StreamException {
        try {
            Document document = this.builder.newDocument();
            Element element = streamDescriptor.getDOMElement(document);
            document.appendChild(element);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "US-ASCII");
            StreamTool.formatHeader(document, outputStreamWriter);
            outputStreamWriter.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            int n = byArray.length;
            this.six[0] = 91;
            this.six[2] = 48;
            this.six[1] = 48;
            this.six[3] = 93;
            this.bigBuffer.put(this.six, 0, 4);
            this.six[0] = (byte)Character.forDigit(n / 100000 % 10, 10);
            this.six[1] = (byte)Character.forDigit(n / 10000 % 10, 10);
            this.six[2] = (byte)Character.forDigit(n / 1000 % 10, 10);
            this.six[3] = (byte)Character.forDigit(n / 100 % 10, 10);
            this.six[4] = (byte)Character.forDigit(n / 10 % 10, 10);
            this.six[5] = (byte)Character.forDigit(n % 10, 10);
            this.bigBuffer.put(this.six);
            this.bigBuffer.put(byArray);
            this.flush();
            if ("deflate".equals(streamDescriptor.getCompression())) {
                this.stream = StreamProducer.getDeflaterChannel(this.stream);
            }
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    public void streamException(StreamException streamException) throws StreamException {
    }

    public void flush() throws StreamException {
        try {
            this.bigBuffer.flip();
            while (this.bigBuffer.hasRemaining()) {
                this.stream.write(this.bigBuffer);
            }
            this.bigBuffer.clear();
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    private static String toString4(int n) {
        if (n > 9999) {
            throw new IllegalArgumentException("header is too big");
        }
        if (n < 10) {
            return "000" + n;
        }
        if (n < 100) {
            return "00" + n;
        }
        if (n < 1000) {
            return "0" + n;
        }
        return String.valueOf(n);
    }

    private static String toString2(int n) {
        if (n > 99) {
            throw new IllegalArgumentException("header number cannot be > 99");
        }
        if (n < 10) {
            return "0" + n;
        }
        return String.valueOf(n);
    }

    private static WritableByteChannel getDeflaterChannel(WritableByteChannel writableByteChannel) throws IOException {
        return new DeflaterChannel(writableByteChannel);
    }
}

