/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.stream;

import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.stream.DataTransferType;
import edu.uiowa.physics.pw.das.stream.SkeletonDescriptor;
import java.nio.ByteBuffer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StreamYScanDescriptor
implements SkeletonDescriptor,
Cloneable {
    private Units yUnits = Units.dimensionless;
    private Units zUnits = Units.dimensionless;
    private double[] yTags;
    private int nitems;
    private String name;
    private DataTransferType transferType = DataTransferType.SUN_REAL4;
    private double[] values;

    public StreamYScanDescriptor(Element element) {
        if (element.getTagName().equals("yscan")) {
            this.processElement(element);
        } else {
            this.processLegacyElement(element);
        }
    }

    private void processElement(Element element) {
        String string;
        String[] stringArray;
        this.nitems = Integer.parseInt(element.getAttribute("nitems"));
        String string2 = element.getAttribute("yTags");
        if (string2 != null) {
            this.yTags = new double[this.nitems];
            boolean bl = false;
            stringArray = string2.split("\\s*,\\s*");
            int n = 0;
            while (n < this.nitems) {
                this.yTags[n] = Double.parseDouble(stringArray[n]);
                ++n;
            }
        }
        if ((stringArray = DataTransferType.getByName(string = element.getAttribute("type"))) == null) {
            throw new RuntimeException("Illegal transfer type: " + string);
        }
        this.transferType = stringArray;
        String string3 = element.getAttribute("name");
        if (string3 != null) {
            this.name = string3;
        }
    }

    private void processLegacyElement(Element element) {
        block6: {
            try {
                DataTransferType dataTransferType;
                String string;
                if (!element.getTagName().equals("YScan")) {
                    throw new IllegalArgumentException("xml tree root node is not the right type. Node type is: " + element.getTagName());
                }
                this.nitems = Integer.parseInt(element.getAttribute("nitems"));
                if (element.getAttribute("yCoordinate") != null) {
                    string = element.getAttribute("yCoordinate");
                    this.yTags = new double[this.nitems];
                    int n = 0;
                    int n2 = 0;
                    while (n2 < this.nitems - 1) {
                        int n3 = string.indexOf(",", n) - 1;
                        this.yTags[n2] = Double.parseDouble(string.substring(n, n3));
                        n = n3 + 2;
                        ++n2;
                    }
                    this.yTags[this.nitems - 1] = Double.parseDouble(string.substring(n));
                }
                if ((dataTransferType = DataTransferType.getByName(string = element.getAttribute("type"))) != null) {
                    this.transferType = dataTransferType;
                    break block6;
                }
                throw new RuntimeException("Illegal transfer type: " + string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Error in das2stream at yCoordinate");
            }
        }
        this.name = element.getAttribute("name") != null ? element.getAttribute("name") : "";
    }

    public StreamYScanDescriptor() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public double[] getYTags() {
        return (double[])this.yTags.clone();
    }

    public void setYCoordinates(double[] dArray) {
        this.yTags = (double[])dArray.clone();
        this.nitems = dArray.length;
    }

    public int getNItems() {
        return this.nitems;
    }

    public Units getYUnits() {
        return this.yUnits;
    }

    public Units getZUnits() {
        return this.zUnits;
    }

    public void setZUnits(Units units) {
        this.zUnits = units;
    }

    public void setYCoordinates(DatumVector datumVector) {
        this.yUnits = datumVector.getUnits();
        this.yTags = datumVector.toDoubleArray(this.yUnits);
        this.nitems = this.yTags.length;
    }

    public void setDataTransferType(DataTransferType dataTransferType) {
        this.transferType = dataTransferType;
    }

    public DataTransferType getDataTransferType() {
        return this.transferType;
    }

    public int getSizeBytes() {
        return this.nitems * this.transferType.getSizeBytes();
    }

    public DatumVector read(ByteBuffer byteBuffer) {
        if (this.values == null) {
            this.values = new double[this.nitems];
        }
        int n = 0;
        while (n < this.nitems) {
            this.values[n] = this.transferType.read(byteBuffer);
            ++n;
        }
        return DatumVector.newDatumVector(this.values, this.zUnits);
    }

    public void write(DatumVector datumVector, ByteBuffer byteBuffer) {
        this.values = datumVector.toDoubleArray(this.values, this.zUnits);
        int n = 0;
        while (n < this.nitems) {
            this.transferType.write(this.values[n], byteBuffer);
            ++n;
        }
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("yscan");
        element.setAttribute("nitems", String.valueOf(this.nitems));
        element.setAttribute("yTags", StreamYScanDescriptor.toString(this.yTags));
        element.setAttribute("yUnits", this.yUnits.toString());
        element.setAttribute("zUnits", this.zUnits.toString());
        element.setAttribute("type", this.transferType.toString());
        return element;
    }

    private static String toString(double[] dArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(dArray[0]);
        int n = 1;
        while (n < dArray.length) {
            stringBuffer.append(", ").append(dArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        try {
            StreamYScanDescriptor streamYScanDescriptor = (StreamYScanDescriptor)super.clone();
            streamYScanDescriptor.yTags = (double[])this.yTags.clone();
            return streamYScanDescriptor;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public String toString() {
        return "<yScan nitems=" + this.nitems + ">";
    }
}

