/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.stream.test;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.stream.DataTransferType;
import edu.uiowa.physics.pw.das.stream.PacketDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamException;
import edu.uiowa.physics.pw.das.stream.StreamProducer;
import edu.uiowa.physics.pw.das.stream.StreamXDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamYScanDescriptor;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.List;

public class RipplesStream {
    private boolean compress;
    double x1;
    double y1;
    double p1;
    double x2;
    double y2;
    double p2;

    public RipplesStream(boolean bl) {
        this(14.0, 17.0, 10.0, 20.0, 60.0, 15.0, bl);
    }

    public RipplesStream(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        this.x1 = d;
        this.y1 = d2;
        this.p1 = d3;
        this.x2 = d4;
        this.y2 = d5;
        this.p2 = d6;
        this.compress = bl;
    }

    public void produceRipplesStream(WritableByteChannel writableByteChannel) {
        try {
            StreamProducer streamProducer = new StreamProducer(writableByteChannel);
            StreamDescriptor streamDescriptor = new StreamDescriptor();
            if (this.compress) {
                streamDescriptor.setCompression("deflate");
            }
            streamProducer.streamDescriptor(streamDescriptor);
            int n = 100;
            int n2 = 100;
            double[] dArray = new double[n2];
            int n3 = 0;
            while (n3 < dArray.length) {
                dArray[n3] = n3;
                ++n3;
            }
            StreamXDescriptor streamXDescriptor = new StreamXDescriptor();
            streamXDescriptor.setDataTransferType(DataTransferType.getByName("ascii10"));
            streamXDescriptor.setUnits(Units.dimensionless);
            StreamYScanDescriptor streamYScanDescriptor = new StreamYScanDescriptor();
            streamYScanDescriptor.setDataTransferType(DataTransferType.getByName("ascii10"));
            streamYScanDescriptor.setYCoordinates(dArray);
            PacketDescriptor packetDescriptor = new PacketDescriptor();
            packetDescriptor.setXDescriptor(streamXDescriptor);
            packetDescriptor.addYDescriptor(streamYScanDescriptor);
            streamProducer.packetDescriptor(packetDescriptor);
            double[] dArray2 = new double[n2];
            DatumVector[] datumVectorArray = new DatumVector[1];
            int n4 = 0;
            while (n4 < n) {
                Datum datum = Datum.create((double)n4);
                int n5 = 0;
                while (n5 < dArray.length) {
                    double d = Math.sqrt(((double)n4 - this.x1) * ((double)n4 - this.x1) + ((double)n5 - this.y1) * ((double)n5 - this.y1));
                    double d2 = Math.exp(-d / this.p1) * Math.cos(Math.PI * this.p1 * d);
                    double d3 = Math.sqrt((n4 - n * 2 / 3) * (n4 - n * 2 / 3) + (n5 - n2 * 2 / 3) * (n5 - n2 * 2 / 3));
                    double d4 = Math.exp(-d3 / this.p2) * Math.cos(Math.PI * this.p2 * d3);
                    dArray2[n5] = d2 + d4;
                    ++n5;
                }
                datumVectorArray[0] = DatumVector.newDatumVector(dArray2, Units.dimensionless);
                streamProducer.packet(packetDescriptor, datum, datumVectorArray);
                ++n4;
            }
            streamProducer.streamClosed(streamDescriptor);
        }
        catch (StreamException streamException) {
            streamException.printStackTrace();
            System.exit(-1);
        }
    }

    public static void main(String[] stringArray) {
        List<String> list = Arrays.asList(stringArray);
        boolean bl = list.contains("-c");
        WritableByteChannel writableByteChannel = Channels.newChannel(System.out);
        RipplesStream ripplesStream = new RipplesStream(bl);
        ripplesStream.produceRipplesStream(writableByteChannel);
    }
}

