/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util;

import edu.uiowa.physics.pw.das.util.DasDie;

public class DasMath {
    public static final double log10 = Math.log(10.0);

    public static double log10(double d) {
        return Math.log(d) / log10;
    }

    public static double exp10(double d) {
        double d2 = Math.pow(10.0, d);
        return d2;
    }

    public static double exp10(int n) {
        double d = Math.pow(10.0, n);
        if (d < 0.3) {
            d = 1.0 / (double)Math.round(1.0 / d);
        }
        return d;
    }

    public static double roundNDigits(double d, int n) {
        double d2 = DasMath.exp10((int)DasMath.log10(d));
        double d3 = d / d2;
        double d4 = DasMath.exp10(n - 1);
        d3 = (double)Math.round(d3 * d4) / d4;
        return d3 * d2;
    }

    public static double tanh(double d) {
        double d2 = (Math.exp(d) - Math.exp(-d)) / 2.0;
        double d3 = (Math.exp(d) + Math.exp(-d)) / 2.0;
        double d4 = d2 / d3;
        return d4;
    }

    public static double interpolate(double[] dArray, double d) {
        int n = (int)d;
        double d2 = d - (double)n;
        double d3 = d2 == 0.0 ? dArray[n] : dArray[n] * (1.0 - d2) + dArray[n + 1] * d2;
        return d3;
    }

    public static double[] interpolate(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray2.length];
        int n = 0;
        while (n < dArray2.length) {
            dArray3[n] = DasMath.interpolate(dArray, dArray2[n]);
            ++n;
        }
        return dArray3;
    }

    /*
     * Unable to fully structure code
     */
    public static double[] findex(double[] var0, double[] var1_1) {
        var2_2 = new double[var1_1.length];
        var3_3 = 0;
        var4_4 = 0;
        ** GOTO lbl13
        {
            ++var3_3;
            do {
                if (var3_3 < var0.length && var0[var3_3 + 1] < var1_1[var4_4]) continue block0;
                while (var3_3 > 0 && var0[var3_3] > var1_1[var4_4]) {
                    --var3_3;
                }
                var2_2[var4_4] = (double)var3_3 + (var1_1[var4_4] - var0[var3_3]) / (var0[var3_3 + 1] - var0[var3_3]);
                ++var4_4;
lbl13:
                // 2 sources

            } while (var4_4 < var2_2.length);
        }
        return var2_2;
    }

    public static void main(String[] stringArray) {
        double d = 1.0E-18;
        DasDie.println("x:" + d);
        DasDie.println("roundNDigits:" + DasMath.roundNDigits(d, 3));
        double[] dArray = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        double[] dArray2 = new double[]{4.0, 6.0, 7.0, 3.0, 1.0};
        double[] dArray3 = new double[]{1.0, 1.5, 4.5, 5.0, 1.5};
        double[] dArray4 = DasMath.interpolate(dArray2, DasMath.findex(dArray, dArray3));
        int n = 0;
        while (n < dArray3.length) {
            System.out.println("" + dArray3[n] + " " + dArray4[n]);
            ++n;
        }
    }

    public static double modp(double d, double d2) {
        double d3 = d % d2;
        return d3 >= 0.0 ? d3 : d2 + d3;
    }

    public static double biggerOf(double d, double d2) {
        return d > d2 ? d : d2;
    }
}

