/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.zip.Deflater;

public class DeflaterChannel
implements WritableByteChannel {
    private boolean closed = false;
    private WritableByteChannel out;
    private Deflater deflater;
    private ByteBuffer buf;
    private byte[] inBuf;

    public DeflaterChannel(WritableByteChannel writableByteChannel) {
        this.out = writableByteChannel;
        byte[] byArray = new byte[4096];
        this.buf = ByteBuffer.wrap(byArray);
        this.deflater = new Deflater();
    }

    public void flush() throws IOException {
        int n;
        this.deflater.finish();
        while ((n = this.deflater.deflate(this.buf.array())) != 0) {
            this.buf.position(0).limit(n);
            while (this.buf.hasRemaining()) {
                this.out.write(this.buf);
            }
        }
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.flush();
            this.closed = true;
            this.out.close();
            this.out = null;
            this.deflater.end();
            this.deflater = null;
            this.buf = null;
        }
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public synchronized int write(ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2;
        byte[] byArray;
        if (byteBuffer.hasArray()) {
            byArray = byteBuffer.array();
            n2 = byteBuffer.arrayOffset();
            n = byteBuffer.remaining();
            byteBuffer.position(byteBuffer.position() + byteBuffer.remaining());
        } else {
            if (this.inBuf == null) {
                this.inBuf = new byte[4096];
            }
            byArray = this.inBuf;
            n2 = 0;
            n = Math.min(byArray.length, byteBuffer.remaining());
            byteBuffer.get(byArray, 0, n);
        }
        this.deflater.setInput(byArray, n2, n);
        while (!this.deflater.needsInput()) {
            int n3 = this.deflater.deflate(this.buf.array());
            this.buf.position(0).limit(n3);
            while (this.buf.hasRemaining()) {
                this.out.write(this.buf);
            }
        }
        return n;
    }
}

