/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class InflaterChannel
implements ReadableByteChannel {
    private boolean closed = false;
    private boolean eof = false;
    private ReadableByteChannel in;
    private Inflater inflater;
    private ByteBuffer buf;
    private byte[] outBuf;

    public InflaterChannel(ReadableByteChannel readableByteChannel) {
        this.in = readableByteChannel;
        byte[] byArray = new byte[4096];
        this.buf = ByteBuffer.wrap(byArray);
        this.inflater = new Inflater();
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.in.close();
            this.in = null;
            this.inflater.end();
            this.inflater = null;
            this.buf = null;
        }
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public synchronized int read(ByteBuffer byteBuffer) throws IOException {
        try {
            int n;
            int n2;
            byte[] byArray;
            if (this.closed) {
                throw new ClosedChannelException();
            }
            if (this.eof && this.inflater.finished()) {
                return -1;
            }
            if (byteBuffer.hasArray()) {
                byArray = byteBuffer.array();
                n2 = byteBuffer.arrayOffset() + byteBuffer.position();
                n = byteBuffer.remaining();
            } else {
                byArray = this.outBuf == null ? (this.outBuf = new byte[4096]) : this.outBuf;
                n2 = 0;
                n = Math.min(byArray.length, byteBuffer.remaining());
            }
            int n3 = 0;
            while (n3 < n) {
                if (this.inflater.needsInput()) {
                    this.buf.clear();
                    if (this.in.read(this.buf) == -1) {
                        this.eof = true;
                    }
                    this.buf.flip();
                    this.inflater.setInput(this.buf.array(), this.buf.arrayOffset(), this.buf.remaining());
                }
                int n4 = this.inflater.inflate(byArray, n2 + n3, n - n3);
                n3 += n4;
                if (this.inflater.finished()) break;
            }
            if (byteBuffer.hasArray()) {
                byteBuffer.position(byteBuffer.position() + n3);
            } else {
                byteBuffer.put(byArray, 0, n3);
            }
            return n3;
        }
        catch (DataFormatException dataFormatException) {
            this.eof = true;
            this.close();
            IOException iOException = new IOException(dataFormatException.getMessage());
            iOException.initCause(dataFormatException);
            throw iOException;
        }
    }
}

