/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util.fft;

public final class SimpleFFT {
    private static final double LOG_2 = Math.log(2.0);

    private SimpleFFT() {
    }

    public static double[][] fft(double[][] dArray) {
        double d;
        double d2;
        int n = dArray.length;
        int n2 = (int)(Math.log(n) / LOG_2 + 0.5);
        int n3 = n / 2;
        int n4 = 1;
        int n5 = 1;
        while (n5 < n) {
            if (n5 < n4) {
                d2 = dArray[n5 - 1][0];
                d = dArray[n5 - 1][1];
                dArray[n5 - 1][0] = dArray[n4 - 1][0];
                dArray[n5 - 1][1] = dArray[n4 - 1][1];
                dArray[n4 - 1][0] = d2;
                dArray[n4 - 1][1] = d;
            }
            int n6 = n3;
            while (n6 < n4) {
                n4 -= n6;
                n6 /= 2;
            }
            n4 += n6;
            ++n5;
        }
        int n7 = 1;
        while (n7 <= n2) {
            int n8 = (int)(Math.exp((double)n7 * LOG_2) + 0.5);
            int n9 = n8 / 2;
            double d3 = 1.0;
            double d4 = 0.0;
            double d5 = Math.cos(Math.PI / (double)n9);
            double d6 = -Math.sin(Math.PI / (double)n9);
            n4 = 1;
            while (n4 <= n9) {
                n5 = n4;
                while (n5 <= n) {
                    int n10 = n5 + n9;
                    d2 = dArray[n10 - 1][0] * d3 - d4 * dArray[n10 - 1][1];
                    d = dArray[n10 - 1][1] * d3 + d4 * dArray[n10 - 1][0];
                    dArray[n10 - 1][0] = dArray[n5 - 1][0] - d2;
                    dArray[n10 - 1][1] = dArray[n5 - 1][1] - d;
                    dArray[n5 - 1][0] = dArray[n5 - 1][0] + d2;
                    dArray[n5 - 1][1] = dArray[n5 - 1][1] + d;
                    n5 += n8;
                }
                d2 = d3 * d5 - d6 * d4;
                d4 = d5 * d4 + d6 * d3;
                d3 = d2;
                ++n4;
            }
            ++n7;
        }
        return dArray;
    }
}

