/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util.fileSystem;

import edu.uiowa.physics.pw.das.util.fileSystem.FileObject;
import edu.uiowa.physics.pw.das.util.fileSystem.FileSystem;
import edu.uiowa.physics.pw.das.util.fileSystem.LocalFileSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Date;

public class LocalFileObject
implements FileObject {
    File localFile;
    File localRoot;
    LocalFileSystem lfs;

    protected LocalFileObject(LocalFileSystem localFileSystem, File file, String string) {
        this.lfs = localFileSystem;
        this.localFile = new File(file, string);
        this.localRoot = file;
    }

    public boolean canRead() {
        return this.localFile.canRead();
    }

    public FileObject[] getChildren() {
        File[] fileArray = this.localFile.listFiles();
        FileObject[] fileObjectArray = new LocalFileObject[fileArray.length];
        int n = 0;
        while (n < fileArray.length) {
            fileObjectArray[n] = new LocalFileObject(this.lfs, this.localRoot, this.lfs.getLocalName(fileArray[n]));
            ++n;
        }
        return fileObjectArray;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(this.localFile);
    }

    public FileObject getParent() {
        if (!this.localFile.equals(this.localRoot)) {
            return new LocalFileObject(this.lfs, this.localRoot, this.lfs.getLocalName(this.localFile.getParentFile()));
        }
        return null;
    }

    public long getSize() {
        return this.localFile.length();
    }

    public boolean isData() {
        return this.localFile.isFile();
    }

    public boolean isFolder() {
        return this.localFile.isDirectory();
    }

    public boolean isReadOnly() {
        return !this.localFile.canWrite();
    }

    public boolean isRoot() {
        return this.localFile.getParentFile() == null;
    }

    public Date lastModified() {
        return new Date(this.localFile.lastModified());
    }

    public boolean exists() {
        return this.localFile.exists();
    }

    public String getNameExt() {
        return FileSystem.toCanonicalFilename(this.localFile.toString().substring(this.localRoot.toString().length()));
    }

    public String toString() {
        return "[lfs]" + this.getNameExt();
    }
}

