;******************************************************************************
;* PROCEDURE:   ampte_createOrbitInfo 
;* 
;* DESCRIPTION: for all AMPTE-ephemeris-files in the directory AMPTE_EPH, 
;*	        orbit-infos are created and written to the file  
;*              $AMPTE_EPH/orbits.info 
;*
;* INPUTS:      none
;* 
;* OUTPUT:	none
;*
;* CALLING SEQUENCE: ampte_createOrbitInfo
;* 
;* MODIFICATION HISTORY: December 1997, written by R. Friedel 
;******************************************************************************
PRO ampte_createOrbitInfo

  common ampte_eph_data, input_header, input_data
  common apmte_OrbitInfo, times
  common get_error, get_err_no, get_err_msg  
   
;for ampte, each ampte cce data file contains orbit start and end time!   
  
; search for the AMPTE-data-files. Use this code to get a list of all the
; ephemeris files available for AMPTE. Replace with correct file template
; for your files in findfile below.

  message, 'Compiling list of all AMPTE CCE files...', /cont
  path=papco_getenv('AMPTE_EPH_DATA')
  allAMPTEFiles=findfile(path+'cce_pos*', count=ndat)
  print, '    ...found', ndat, ' data-files'
  allAMPTEFiles=strmid(allAMPTEFiles,strlen(path),10)
     
; Depending on your AMPTE ephemeris files, loop through them to find orbit
; start and end times. One way of doing this is to construct an array of
; radial distance. Max. of radius are then apogee times, Min perigee times.
  
  dummy={AMPTERAD,  time:0.0d, radius :0.0 }    
  ampte_rad=replicate(dummy,ndat*26500)
  total=0
  
  for i=0, ndat-1 do begin
    print,''
    message, allAMPTEFiles(i)+'  '+varprt(i)+' of '+varprt(ndat), /cont
    r_ampte_eph_onefile, allAMPTEFiles(i)
    if get_err_no ne 0 then begin
      message,'No data for year '+varprt(year),/cont
      goto, next
    endif
    n=n_elements(input_data)
    
    ampte_rad(total:total+n-1).time=input_data.time
    ampte_rad(total:total+n-1).radius=input_data.radius
    total=total+n
    
    next:
  endfor
  
  ampte_rad=ampte_rad(0:total)
  
; loop through radius and find where the minima are: perigee
  orbits=lonarr((total/72) * 24 / 12, 2)
  orbit=0
  for i=1l,total-2l do begin
    if (ampte_rad(i-1).radius ge ampte_rad(i).radius) AND $
       (ampte_rad(i).radius le ampte_rad(i+1).radius) then begin
      orbit=orbit+1
      orbits(orbit,0)=orbit
      orbits(orbit,1)=i
    endif
  endfor  
  orbits=orbits(0:orbit,*)
   
  print,''
  message, '...there are '+varprt(orbit)+ ' orbits', /cont
  tmp=papco_getOrbitInfoStruct()	  ; create a AMPTE_ORBIT_INFO-structure
  orbitInfo=replicate(tmp, orbit)        ; and create an array of those  
  
  for i=0,orbit-1 do begin
     orbitindex=orbits(i,1)
     
     perigee_time=ampte_rad(orbitindex).time
     result=TAI2UTC(perigee_time, /external)
             
     time_mjdt=convert_date_to_t90(day=result.day,month=result.month, $
                                   year=result.year,seconds=result.second,$
                                   hour=result.hour, minute=result.minute,$
                                   /MJDT)
          
     convert_t90_to_Date,time_mjdt, $
                 year,day_oy,hour,min,sec,mon,cmon,day_om,/MJDT
     
     print,year,mon,day_om,hour,min,i,orbitindex,day_oy
     
     orbitInfo(i).number=i		   ; save the data in 
     orbitInfo(i).day=day_oy	 	   ; the orbitInfo-structure
     orbitInfo(i).year=year
     orbitInfo(i).xut1=hour*3600.0+min*60.0+sec
     orbitInfo(i).xut2=orbitInfo(i).xut1+15*3600.0+40*60.0
     orbitInfo(i).xdata=0
     orbitInfo(i).ydata=0
  endfor  
  
; write the orbits.info-file
  result=papco_writeOrbitInfo('AMPTE', orbitInfo)
  IF result EQ 'OK' THEN $
     message, 'OrbitInfo successfully created.',/cont $
  ELSE $
     message, result, /cont
  RETURN

END; (ampte_createOrbitInfo)
