;******************************************************************************
;******************************************************************************
;* FILE:	 
;*      papco_defaults.pro
;* 
;* DESCRIPTION:  
;*      A window containing a entr field and buttons is displayed modally.
;*      The user can review and/or set some default fields here.
;*
;* OVERVIEW:
;*      PRO papco_defaults_event, event
;*	FUNCTION papco_defaults, strArray, buttons, CENTER=center
;*	
;* NEEDS:
;*      papco_util
;*
;* COMMON VARIABLES:
;*        COMMON papco_defaults, buttonSelected
;*	  	 this COMMON-block is used to return the selected button
;*		 from the event-handler to the papco_defaults-function
;*               It must not be used by other programs.
;*
;* MODIFICATION HISTORY:       
;*      February 1996, written by R. Friedel
;******************************************************************************
;******************************************************************************

;******************************************************************************
;* PROCEDURE:     
;*      papco_defaults_event
;* 
;* DESCRIPTION:  
;*      this is the event-handler. It is called by XMANAGER only
;* 
;* INPUTS:       
;*      event 	: the event to be handled
;* 
;* OUTPUT:	 
;*      none
;*
;* CALLING SEQUENCE:
;*      this procedure is to be called by XMANAGER only
;******************************************************************************
PRO papco_defaults_event, event

COMMON defaults, thiswidgetData
COMMON PLOT_COMPOSER, widgetData

WIDGET_CONTROL,Event.Id,GET_UVALUE=ev

CASE ev OF
    'mpb_format'      : BEGIN
        formatNames=['TXT', 'CDF', 'IDL', 'PUM']
        widgetData.default_output_format=formatNames(event.value)
    END   
    'mpb_redraw'      : widgetData.default_redraw = abs(event.value-1)
    'mpb_verbose'     : widgetData.default_verbose=abs(event.value-1)
    'mpb_scroll'      : widgetData.default_scroll=event.value
    'mpb_save_bitmap' : widgetData.default_save_bitmap=event.value
    'mpb_wid_enable'  : widgetData.default_input_enable=event.value
    'mpb_state'       : widgetData.default_states=event.value
    'mpb_layout'      : widgetData.default_layout=event.value
    'mpb_indent_str'  : widgetData.default_draw_ident=event.value
    'mpb_error_box'   : widgetData.default_error_box=event.value
    'mpb_us_europe'   : widgetData.default_us_europe=event.value
    'mpb_numbering'   : widgetData.default_numbering=event.value
    'mpb_slice_reload': widgetData.default_slice_reload=event.value
    'mpb_right_label' : widgetData.default_right_label=event.value
    'mpb_png_format'  : widgetData.default_png_format=event.value
    'mpb_trap_errors' : widgetData.default_trap=abs(event.value-1)
    'mpb_wget'        : widgetData.default_wget=abs(event.value-1)
    'mpb_ask_wget'    : widgetData.default_ask_wget=event.value
    'mpb_do_plots'    : widgetData.default_do_plots=event.value
    'spb_ps'          : widgetData.default_ps_eps=0
    'spb_eps'         : widgetData.default_ps_eps=1
    'pb_cancel'       : WIDGET_CONTROL, Event.top, /DESTROY
    'pb_update'       : BEGIN
        WIDGET_CONTROL, thiswidgetData.charsize_base, GET_VALUE=x
        widgetData.default_charsize=x
        !P.CHARSIZE=widgetData.default_charsize
        WIDGET_CONTROL, thiswidgetData.charthick_base, GET_VALUE=x
        widgetData.default_charthick=x
        WIDGET_CONTROL, thiswidgetData.ps_mult_base, GET_VALUE=x
        widgetData.default_ps_mult=x
        
        WIDGET_CONTROL, thiswidgetData.x_plot_size, GET_VALUE=x
        widgetData.default_plot_size(0)=x
        WIDGET_CONTROL, thiswidgetData.y_plot_size, GET_VALUE=x
        widgetData.default_plot_size(1)=x
        
        WIDGET_CONTROL, thiswidgetData.x_draw_size, GET_VALUE=x
        widgetData.default_draw_size(0)=x
        WIDGET_CONTROL, thiswidgetData.y_draw_size, GET_VALUE=x
        widgetData.default_draw_size(1)=x
        WIDGET_CONTROL, thiswidgetData.x_gif_size, GET_VALUE=x
        widgetData.default_gif_size(0)=x
        WIDGET_CONTROL, thiswidgetData.y_gif_size, GET_VALUE=x
        widgetData.default_gif_size(1)=x
        WIDGET_CONTROL, thiswidgetData.x_vert_size, GET_VALUE=x
        widgetData.default_vert_slice_size(0)=x
        WIDGET_CONTROL, thiswidgetData.y_vert_size, GET_VALUE=x
        widgetData.default_vert_slice_size(1)=x

        
        WIDGET_CONTROL, thiswidgetData.adjust_base, GET_VALUE=x
        widgetData.default_adjust_time=x
        WIDGET_CONTROL, thiswidgetData.xnolabel_base, GET_VALUE=x
        widgetData.default_XTICKS=x
        WIDGET_CONTROL, thiswidgetData.xnolines_base, GET_VALUE=x
        widgetData.default_XLINES=x
        WIDGET_CONTROL, thiswidgetData.bckg_color_base, GET_VALUE=x
        widgetData.default_bckg_color=x
        WIDGET_CONTROL, thiswidgetData.forg_color_base, GET_VALUE=x
        widgetData.default_forg_color=x
        
        papco_writeDefaultSettings
        widgetData.need_to_draw=1
        WIDGET_CONTROL, Event.top, /DESTROY
      END      
    ELSE: BEGIN &  end
ENDCASE 

; check if event if due to font list
;   if ev eq 'font_list' then begin
;     font_index=[3,5,6,17,8,11,12,13,14,15,18]
;     widgetData.default_charfont=font_index(event.index)
;   endif  

END

;******************************************************************************
;* PROCEDURE:     
;*      PROCEDURE papco_defaults
;* 
;* DESCRIPTION:  
;*      A window containing a entry field and buttons is displayed modally.
;*
;* INPUTS:       
;*	none
;*
;* KEYWORDS:
;*      SIZE_ONLY  returns size info of widget only. Used to determine
;*                 scrolling
;*
;* OUTPUT:	 
;*      mone
;*
;* CALLING EXAMPLE:
;*      papco_defaults
;******************************************************************************
PRO papco_defaults, SIZE_ONLY = SIZE_ONLY

COMMON defaults, thiswidgetData
COMMON plot_composer, widgetData
 
;check screensize. Add scrolling if needed! Only check y sizing, x is O.K
xsize = 0 & ysize = 0 & scroll = 0 
IF keyword_set(size_only) THEN GOTO, no_size

IF NOT widgetData.default_scroll THEN BEGIN
    size = 1
    papco_defaults, SIZE_ONLY = size
    y_screen = widgetData.screensize(1)
    IF size.YSIZE GT y_screen THEN BEGIN
        scroll = 1
        xsize = 20+ size.XSIZE / 2 
        ysize = y_screen-200
    ENDIF 
ENDIF 

no_size:

base = papco_widget_base(COLUMN=1, TITLE='papco defaults', $
                         GROUP_LEADER=widgetdata.base, UVALUE='papco_defaults')
   
top_base=WIDGET_BASE(base, COLUMN=1)
middle_base=WIDGET_BASE(base, /FRAME, ROW=1)
left_base=WIDGET_BASE(middle_base, COLUMN=1, SCROLL = scroll, $
                      X_SCROLL_SIZE = xsize, Y_SCROLL_SIZE = ysize)
right_base=WIDGET_BASE(middle_base, COLUMN=1, SCROLL = scroll, $
                      X_SCROLL_SIZE = xsize, Y_SCROLL_SIZE = ysize)
bottom_base=WIDGET_BASE(base, COLUMN=1)

yn_names=['Yes','No']

;--- top base label -----------------------------------------------------------
str = WIDGET_LABEL(top_base, /ALIGN_CENTER, $
                   VALUE='Edit / Review papco default settings '+ $
                   '(stored in $PAPCO_USER/papco_defaults.dat):')
 
;--- start left base widgets --------------------------------------------------
  
;--- vector drawn font choices ------------------------------------------------
char_base=WIDGET_BASE(left_base,COLUMN=1,/FRAME)
   
charthick_base=CW_FIELD(char_base,$
            value=widgetData.default_charthick, $
            TITLE=strFormat('Character thickness (float):', 28,/LEFT), $
            UVALUE='charthick_base',  /FLOATING, XSIZE=10)
charsize_base=CW_FIELD(char_base, $
            value=widgetData.default_charsize, $
            TITLE=strFormat('Character size (float):', 28,/LEFT), $
            UVALUE='charsize_base',  /FLOATING, XSIZE=10)
   
;--- postscript choices ------------------------------------------------------
postscript_base=WIDGET_BASE(left_base,column=1,/frame)
ps_mult_base=CW_FIELD(postscript_base, $
             value=widgetData.default_ps_mult, $
             TITLE=strFormat('Postscript charsize factor:',28,/LEFT), $
             UVALUE='ps_mult_base', /FLOATING, XSIZE=10)

sp_eps_base=WIDGET_BASE(postscript_base,ROW=1)
ps_label=WIDGET_LABEL(sp_eps_base, $
           VALUE=strFormat('Non Encapsulated PostScript', 28,/LEFT))
sp_yesno_base=WIDGET_BASE(sp_eps_base,row=1,/exclusive)   

spb_ps=WIDGET_BUTTON(sp_yesno_base, $ 
			VALUE='Yes', $
			UVALUE='spb_ps')
   spb_eps=WIDGET_BUTTON(sp_yesno_base, $
			VALUE='No', $
			UVALUE='spb_eps')
   IF widgetData.default_ps_eps EQ 0 THEN BEGIN
      WIDGET_CONTROL, spb_ps, SET_BUTTON=1
      WIDGET_CONTROL, spb_eps, SET_BUTTON=0
   ENDIF ELSE BEGIN
      WIDGET_CONTROL, spb_ps, SET_BUTTON=0
      WIDGET_CONTROL, spb_eps, SET_BUTTON=1
   ENDELSE
   
;--- Draw area scaling --------------------------------------------------------
plot_size_base=WIDGET_BASE(left_base, COLUMN=1, /frame)
str = WIDGET_LABEL(plot_size_base, VALUE='Draw area scaling scaling (float)')
plot_size_entry_base=WIDGET_BASE(plot_size_base, ROW=1)   
x_plot_size=CW_FIELD(plot_size_entry_base, XSIZE=10, $
                      value=widgetData.default_plot_size(0), $
                      TITLE=strFormat('X (%):',6, /RIGHT), $
                      UVALUE='x_plot_size', /INTEGER)
y_plot_size=CW_FIELD(plot_size_entry_base, XSIZE=10, $
                      value=widgetData.default_plot_size(1), $
                      TITLE=strFormat('Y (%):',6, /RIGHT), $
                      UVALUE='y_plot_size', /INTEGER)
   
;--- screen / gif draw size widget --------------------------------------------
draw_size_base=WIDGET_BASE(left_base, COLUMN=1, /FRAME)
str = WIDGET_LABEL(draw_size_base, VALUE='Screen draw window pixel size:')
draw_size_entry_base=WIDGET_BASE(draw_size_base, ROW=1)
x_draw_size=CW_FIELD(draw_size_entry_base, XSIZE=10, $
                      value=widgetData.default_draw_size(0), $
                      TITLE=strFormat('X:',6, /RIGHT), $
                      UVALUE='x_draw_size_base', /INTEGER)
y_draw_size=CW_FIELD(draw_size_entry_base, XSIZE=10, $
                      value=widgetData.default_draw_size(1), $
                      TITLE=strFormat('Y:',6, /RIGHT), $
                      UVALUE='y_draw_size_base', /INTEGER)

str = WIDGET_LABEL(draw_size_base, VALUE='File output PNG pixel size:')
gif_size_entry_base=WIDGET_BASE(draw_size_base, ROW=1)
x_gif_size=CW_FIELD(gif_size_entry_base, XSIZE=10, $
                      value=widgetData.default_gif_size(0), $
                      TITLE=strFormat('X:',6, /RIGHT), $
                      UVALUE='x_gif_size_base', /INTEGER)
y_gif_size=CW_FIELD(gif_size_entry_base, XSIZE=10, $
                      value=widgetData.default_gif_size(1), $
                      TITLE=strFormat('Y:',6, /RIGHT), $
                      UVALUE='y_gif_size_base', /INTEGER)


;--- background color widget -------------------------------------------------
bckg_color_base=CW_FIELD(left_base, $
                    value=widgetData.default_bckg_color, $
                    TITLE=strFormat('Plot background grey index:',28,/LEFT), $
                    UVALUE='bckg_color_base', /INTEGER, /FRAME, XSIZE=10)

;--- foreground color widget -------------------------------------------------
forg_color_base=CW_FIELD(left_base, $
                    value=widgetData.default_forg_color, $
                    TITLE=strFormat('Plot foreground grey index:',28,/LEFT), $
                    UVALUE='forg_color_base', /INTEGER, /FRAME, XSIZE=10)

;--- vertical slice widget draw area size -------------------------------------
vert_slice_size_base=WIDGET_BASE(left_base, COLUMN=1, /FRAME)
str = WIDGET_LABEL(vert_slice_size_base, $
                   VALUE='Vertical Slice draw window pixel size:')
vert_slice_size_entry_base=WIDGET_BASE(vert_slice_size_base, ROW=1)
x_vert_size=CW_FIELD(vert_slice_size_entry_base, XSIZE=10, $
                      value=widgetData.default_vert_slice_size(0), $
                      TITLE=strFormat('X:',6, /RIGHT), $
                      UVALUE='x_vert_slice_size_base', /INTEGER)
y_vert_size=CW_FIELD(vert_slice_size_entry_base, XSIZE=10, $
                      value=widgetData.default_vert_slice_size(1), $
                      TITLE=strFormat('Y:',6, /RIGHT), $
                      UVALUE='y_vert_slice_size_base', /INTEGER)

;--- Output data format--------------------------------------------------------
output_format_base = WIDGET_BASE(left_base, ROW=1, /FRAME)
formatNames=['TXT', 'CDF', 'IDL', 'PUM']
mpb_format = CW_BGROUP(output_format_base, formatNames, ROW=2, /EXCLUSIVE, $
    LABEL_LEFT=strFormat('Data OUTPUT format:', 23,/LEFT), $
    UVALUE='mpb_format', IDS=format_ids)  
pos = where(formatNames EQ widgetData.default_output_format, c)
IF c EQ 0 THEN set = 0 ELSE set = pos(0)
WIDGET_CONTROL, mpb_format, SET_VALUE=set

;--- png output full page or panels ------------------------------------------
png_format_base = WIDGET_BASE(right_base, ROW=1, /FRAME)
names=['Full Page   ', 'Panel Data', 'Panel Labels', 'Full Panel']
mpb_png_format=CW_BGROUP(png_format_base,names, ROW=2, /EXCLUSIVE, $
     LABEL_LEFT=strFormat('PNG output:', 11,/LEFT), $
     UVALUE='mpb_png_format', IDS=right_label_ids)    
WIDGET_CONTROL, mpb_png_format, SET_VALUE=widgetData.default_png_format

; --- Hours to automatically adjust time range by
adjust_base=CW_FIELD(left_base, $
                     value=widgetData.default_adjust_time, $
                     TITLE=strFormat('Auto time adjust (hours):',28, /LEFT), $
                     UVALUE='adjust_base', /FLOATING, /FRAME, XSIZE=10)  
  
; --- Set default number of x-axis labels
xnolabel_base=CW_FIELD(left_base, $
                     value=widgetData.default_XTICKS, $
                     TITLE=strFormat('Number of Time labels:',28, /LEFT),$
                     UVALUE='xnolabel_base', /INTEGER, /FRAME, XSIZE=10)   
  
; --- Set default number of x-axis label lines
xnolines_base=CW_FIELD(left_base, $
                     value=widgetData.default_XLINES, $
                     TITLE=strFormat('Number of Time label lines:',28, /LEFT),$
                     UVALUE='xnolines_base', /INTEGER, /FRAME, XSIZE=10)   
   
;--- start right base widgets -------------------------------------------------
  
; --- Layout widget - lan%dscape or portrait   
names=['Port.','Land.']
mpb_layout=CW_BGROUP(right_base,names,ROW=1,/EXCLUSIVE, $
    LABEL_LEFT=strFormat('Draw layout:', 28,/LEFT), $
    UVALUE='mpb_layout', IDS=layout_ids)    
WIDGET_CONTROL, mpb_layout, SET_VALUE=widgetData.default_layout
  
mpb_scroll=CW_BGROUP(right_base,yn_names,ROW=1,/EXCLUSIVE, $
    LABEL_LEFT=strFormat('Allow Scroll:', 28,/LEFT), $
    UVALUE='mpb_scroll', IDS=ident_str_ids)    
WIDGET_CONTROL, mpb_scroll, SET_VALUE=widgetData.default_scroll

; --- Ident string widget   
mpb_ident_str=CW_BGROUP(right_base,yn_names,ROW=1,/EXCLUSIVE, $
    LABEL_LEFT=strFormat('Draw PAPCO Ident string:', 28,/LEFT), $
    UVALUE='mpb_indent_str', IDS=ident_str_ids)    
WIDGET_CONTROL, mpb_ident_str, SET_VALUE=widgetData.default_draw_ident
   
; --- Input disable/enable
mpb_wid_enable=CW_BGROUP(right_base,yn_names,ROW=1,/EXCLUSIVE, $
    LABEL_LEFT=strFormat('Allow auto widget disable:', 28,/LEFT), $
    UVALUE='mpb_wid_enable', IDS=wid_enable_ids)    
WIDGET_CONTROL, mpb_wid_enable, SET_VALUE=widgetData.default_input_enable

; --- Bitmap save disable/enable
mpb_save_bitmap=CW_BGROUP(right_base,yn_names,ROW=1,/EXCLUSIVE, $
    LABEL_LEFT=strFormat('Inhibit save of draw bitmap:', 28,/LEFT), $
    UVALUE='mpb_save_bitmap', IDS=save_bitmap_ids)    
WIDGET_CONTROL, mpb_save_bitmap, SET_VALUE=widgetData.default_save_bitmap

; --- us/ european style date, paper size
names=['Europe','USA']
mpb_us_europe=CW_BGROUP(right_base,names,ROW=1,/EXCLUSIVE, $
    LABEL_LEFT=strFormat('Date / Paper Size:', 28,/LEFT), $
    UVALUE='mpb_us_europe', IDS=us_europe_ids)    
WIDGET_CONTROL, mpb_us_europe, SET_VALUE=widgetData.default_us_europe

; --- Trap user routine errors or crash
mpb_trap_errors=CW_BGROUP(right_base,yn_names,ROW=1,/EXCLUSIVE, $
     LABEL_LEFT=strFormat('Trap user routine errors:', 28,/LEFT), $
                           UVALUE='mpb_trap_errors', IDS=trap_errors_ids)    
IF widgetData.default_trap EQ 0 THEN set = 1 ELSE set = 0
WIDGET_CONTROL, mpb_trap_errors, SET_VALUE=set
   
; --- Enable remote get option
mpb_wget=CW_BGROUP(right_base,yn_names,ROW=1,/EXCLUSIVE, $
     LABEL_LEFT=strFormat('Enable remote data (wGeT):', 28,/LEFT), $
     UVALUE='mpb_wget', IDS=wget_ids)    
IF widgetData.default_wget EQ 0 THEN set = 1 ELSE set = 0
WIDGET_CONTROL, mpb_wget, SET_VALUE=set 

mpb_ask_wget=CW_BGROUP(right_base,yn_names,ROW=1,/EXCLUSIVE, $ 
     LABEL_LEFT=strFormat('Confirm remote data fetch:', 28,/LEFT), $ 
     UVALUE='mpb_ask_wget', IDS=wget_ids)     
WIDGET_CONTROL, mpb_ask_wget, SET_VALUE=widgetData.default_ask_wget
   
; --- Number panels on or off   
mpb_numbering=CW_BGROUP(right_base,yn_names,ROW=1,/EXCLUSIVE, $
     LABEL_LEFT=strFormat('Enable numbering of panels:', 28,/LEFT), $
     UVALUE='mpb_numbering', IDS=numbering_ids)    
WIDGET_CONTROL, mpb_numbering, SET_VALUE=widgetData.default_numbering
   
; --- Auto data reload for slice on or off   
mpb_slice_reload=CW_BGROUP(right_base,yn_names,ROW=1,/EXCLUSIVE, $
     LABEL_LEFT=strFormat('Auto reload data for slice:', 28,/LEFT), $
    UVALUE='mpb_slice_reload', IDS=slice_reload_ids)    
WIDGET_CONTROL, mpb_slice_reload, SET_VALUE=widgetData.default_slice_reload
   
; --- Turn papco_state_files one / off
mpb_state=CW_BGROUP(right_base,yn_names,ROW=1,/EXCLUSIVE, $
     LABEL_LEFT=strFormat('Enable papco states:', 28,/LEFT), $
     UVALUE='mpb_state', IDS=state_ids)    
WIDGET_CONTROL, mpb_state, SET_VALUE=widgetData.default_states

; --- right side label inside or outside of plot 
names=['Out','In']
mpb_right_label=CW_BGROUP(right_base,names,ROW=1,/EXCLUSIVE, $
     LABEL_LEFT=strFormat('Right-side panel label:', 28,/LEFT), $
     UVALUE='mpb_right_label', IDS=right_label_ids)    
WIDGET_CONTROL, mpb_right_label, SET_VALUE=widgetData.default_right_label
   
; --- draw plot error box normal or blank
names=['Empty', 'Verbose']
mpb_error_box=CW_BGROUP(right_base,names,ROW=1,/EXCLUSIVE, $
    LABEL_LEFT=strFormat('Draw Panel Error Box:', 28,/LEFT), $
    UVALUE='mpb_error_box', IDS=us_error_box)    
WIDGET_CONTROL, mpb_error_box, SET_VALUE=widgetData.default_error_box

; --- do plot or read loop only. useful for using PAPCO batch mode to
;     read/make a lot of data files without producing plots!
mpb_do_plots=CW_BGROUP(right_base,yn_names,ROW=1,/EXCLUSIVE, $
     LABEL_LEFT=strFormat('Do data read only, no plot:', 28,/LEFT), $
     UVALUE='mpb_do_plots', IDS=do_plots_ids)    
WIDGET_CONTROL, mpb_do_plots, SET_VALUE=widgetData.default_do_plots

; --- eneable general papco verbose -------------------------------------------
mpb_verbose=CW_BGROUP(right_base,yn_names,ROW=1,/EXCLUSIVE, $
     LABEL_LEFT=strFormat('Enable papco verbose:', 28,/LEFT), $
     UVALUE='mpb_verbose', IDS=verbose_ids)    
IF widgetData.default_verbose EQ 0 THEN set = 1 ELSE set = 0
WIDGET_CONTROL, mpb_verbose, SET_VALUE=set

; --- allow or inhibit automatic redraw checking ------------------------------
mpb_redraw=CW_BGROUP(right_base,yn_names,ROW=1,/EXCLUSIVE, $
     LABEL_LEFT=strFormat('Enable papco redraw logic:', 28,/LEFT), $
     UVALUE='mpb_redraw', IDS=redraw_ids)    
IF widgetData.default_redraw EQ 0 THEN set = 1 ELSE set = 0
WIDGET_CONTROL, mpb_redraw, SET_VALUE=set


; --- Do Action buttons at bottom of widget -----------------------------------
butBase=WIDGET_BASE(bottom_base, /row)
geo=WIDGET_INFO(base, /GEOMETRY)
x=600 - geo.xsize/2  &  y=300 - geo.ysize/2
pb_update = WIDGET_BUTTON(butBase, XSIZE = geo.xsize/2,  $
	                  VALUE='Enter new Values', UVALUE='pb_update')

pb_cancel = WIDGET_BUTTON(butBase, XSIZE = geo.xsize/2,  $
	                  VALUE='Keep old Values', UVALUE='pb_cancel')

if n_elements(xpos) gt 0 then x=xpos
if n_elements(ypos) gt 0 then y=ypos

IF keyword_set(SIZE_ONLY) THEN BEGIN
    size_only = geo
    return
ENDIF 

WIDGET_CONTROL, base, XOFFSET=x, YOFFSET=y
WIDGET_CONTROL, base, /REALIZE

;-- make a structure for this widget's ID's
thiswidgetData={charsize_base:charsize_base, $
                  charthick_base:charthick_base, $
                  ps_mult_base:ps_mult_base, $
                  x_plot_size: x_plot_size, $
                  y_plot_size: y_plot_size, $                     
                  x_draw_size:x_draw_size, $ 
                  y_draw_size:y_draw_size, $
                  x_gif_size:x_gif_size, $
                  y_gif_size:y_gif_size, $
                  x_vert_size:x_vert_size, $
                  y_vert_size:y_vert_size, $
                  adjust_base:adjust_base, $
                  xnolabel_base:xnolabel_base, $
                  xnolines_base:xnolines_base, $
                  bckg_color_base:bckg_color_base, $
                  forg_color_base:forg_color_base, $
                  formatNames:formatNames}

papco_xmanager, 'papco_defaults', base, /JUST_REG

END
