;******************************************************************************
;* FUNCTION:     
;*      papco_edit_Type, aPlotInfo, GROUP=GROUP
;*
;* DESCRIPTION:  
;*	creates window with all plot types listed for user to choose new
;*      type.
;*
;* INPUTS:       
;*	none
;*
;* RETURN VALUE: a structure
;*      {canceled:widgetData.canceled, $
;*	 panelKind:panelkinds(widgetData.panelKindNr)} panelkind of chosen plot
;*   	
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	papco_edit_Type(aPlotInfo, GROUP=GROUP)
;*
;* MODIFICATION HISTORY: 
;*      written Septembet 1995, Andreas Keese      
;*      modified December 1995, Reiner Friedel at Goddard
;******************************************************************************
FUNCTION papco_edit_Type, aPlotInfo, GROUP=GROUP
  
COMMON papco_edit_TYPE, widgetData
COMMON ADDINS, plot_types

  IF NOT KEYWORD_SET(GROUP) THEN GROUP=0

  edit_base=papco_widget_base(COLUMN=1, GROUP=GROUP, TITLE='Change Plot Type')

  select_base=WIDGET_BASE(edit_base, /EXCLUSIVE, COLUMN=3)

  panelkinds=plot_types

  Labels=panelkinds

  spb_type=lonarr(N_ELEMENTS(Labels))
  FOR i=0, N_ELEMENTS(Labels) -1 DO $
    spb_type(i)=WIDGET_BUTTON(select_base, $
			      VALUE=labels(i), $
			      UVALUE='spb_type'+strtrim(string(i),2))

  pb_help  =widget_button(edit_base, uvalue='pb_help',   value='Help')
  pb_cancel=widget_button(edit_base, uvalue='pb_cancel', value='Cancel')
  pb_done  =widget_button(edit_base, uvalue='pb_done',   value='Change Type')

  panelNr=-1
  FOR i=0, N_ELEMENTS(panelkinds)-1 DO $
     IF panelkinds(i) EQ strchminus(aPlotInfo.panelkind) THEN panelNr=i

  IF panelNr GT -1 THEN $
     WIDGET_CONTROL, spb_type(panelNr), /SET_BUTTON

  widgetData={papco_edit_TYPE, $
		   panelKindNr:panelNr, $
		   canceled:1}
    
  WIDGET_CONTROL, edit_base, /REALIZE
  papco_xmanager, 'papco_edit_Type', edit_base
  
  RETURN, {canceled:widgetData.canceled, $
	   panelKind:panelkinds(widgetData.panelKindNr)}

END

;******************************************************************************
PRO papco_edit_Type_Event, Event
  
  COMMON papco_edit_Type, widgetData

  WIDGET_CONTROL,GET_UVALUE=uval, event.id
  IF strleft(uval,8) EQ 'spb_type' THEN BEGIN
    widgetData.panelKindNr=fix(strfrom(uval, 8))
    RETURN
  ENDIF 

  CASE uval OF
    'pb_help' : BEGIN
      xdisplayfile,papco_helpfile('papco_edit_type.help'), $
        title=widgetData.panelKind+'Online-Help',$
        group=event.top
     END

    'pb_done' : BEGIN
      IF widgetData.panelKindNr eq -1 then BEGIN
        widgetData.canceled=1
        widgetData.panelKindNr=0
       ENDIF ELSE widgetData.canceled=0
       WIDGET_CONTROL, event.top, /DESTROY	       
     END


     'pb_cancel' : BEGIN
       widgetData.canceled=1
       widgetData.panelKindNr=0
       WIDGET_CONTROL, event.top, /DESTROY	       
     END
  END
         
END





