;******************************************************************************
;* PROCEDURE:
;*     PRO papco_find_modules
;*
;* DESCRIPTION:
;*     Searches through the !path variable for all directories which include
;*     the directory called papco_interface
;*     writes the resulting file papco_add_init.pro (which needs to be
;*     compiled to compile all modules) to the user's PAPCO_HOME.
;*
;* INPUTS:
;*     none
;*
;* KEYWORDS:
;*     NO_WRITE:   don't write an add_init compile file
;*     QUIET:      no verbose output
;*
;* CALLING SEQUENCE:
;*     papco_find_modules
;*
;* MODIFICATION HISTORY:
;*     written October 1997, Reiner Friedel
;******************************************************************************
pro papco_find_modules, NO_WRITE=NO_WRITE, QUIET=QUIET

COMMON module_paths, paths

idl_search_path=!path

; make an array of all the paths. The are seperated by dirsep
paths=str_sep(idl_search_path,papco_get_dirsep())
paths=strlowcase(paths)

; choose only those that have "papco_interface" in them
no_paths=n_elements(paths)
tag=intarr(no_paths)
for i=0,no_paths-1 do begin
     pos=strpos(paths(i),'papco_interface')
     pos2=strpos(paths(i),'papco_interface'+papco_get_pathsep())
     if (pos ne -1) and (pos2 eq -1) then begin
        tag(i)=1
        paths(i)=strmid(paths(i),0,pos)
     endif
endfor
index=where(tag eq 1,count)
if count eq 0 then begin
    message,'Cannot find any modules in !path', /cont
    paths=''
    papco_w_add_init, /EMPTY
    return
endif
paths=paths(index)

if not keyword_set(QUIET) then begin
    message,'The following module directories were found:' ,/cont
    print,''
    for i=0,n_elements(paths)-1 do begin
      paths(i)=papco_checkdirname(paths(i))
      print,'  '+paths(i)
    endfor
endif

;write a new papco_add_init.pro file which explicitly calls the init_module.pro
;files in each module directory.
if not keyword_set(NO_WRITE) then papco_w_add_init

end

;******************************************************************************
;* PROCEDURE:
;*      PRO papco_w_add_init
;*
;* DESCRIPTION:
;*      Writes the file papco_add_init.pro needed to compile module init files.
;*
;* INPUTS:
;*	none
;*
;* KEYWORDS:
;* 	EMPTY:   Writes an empty file (used in no modules are configured)
;*      FILE:    Used thias file name as output file name
;*
;* CALLING SEQUENCE:
;*	papco_w_add_init
;*
;* MODIFICATION HISTORY:
;*     written March 1998, Reiner Friedel
;******************************************************************************
pro papco_w_add_init, EMPTY=EMPTY, FILE=FILE

  COMMON MODULE_PATHS, paths

  dir_path=papco_getenv('PAPCO_HOME')
  if keyword_set(FILE) then fln=FILE else $
    fln='papco_add_init.pro'

  openw,unit,dir_path+fln,/get_lun

  print,''
  message,'Writing file '+fln, /cont
  print,''

  star_str='***************************************'

  printf,unit,';'+star_str+star_str
  printf,unit,';* FILE:	 '
  printf,unit,";*    $PAPCO_HOME/"+fln
  printf,unit,';* '
  printf,unit,';* DESCRIPTION:  '
  printf,unit,';*    initialize the add-in modules for PAPCO. Here all the '
  printf,unit,';*    individual init-files (init_module.pro) are called.'
  printf,unit,';*    This file is produced by papco_find_modules'
  printf,unit,';*    called in papco_startup.pro'
  printf,unit,';*    The file is written into the directory in the'
  printf,unit,';*    variable PAPCO_HOME in papco_set_variables.pro. '
  printf,unit,';*    Make sure this directory in contained in the'
  printf,unit,';*    IDL search path (!path) or start PAPCO in that directory.'
  printf,unit,';*'
  printf,unit,';* HOW TO START:'
  printf,unit,';*    from IDL, '
  printf,unit,';*        type @papco_add_init'
  printf,unit,';*    after papco_init has been run. Then start PAPCO by typing'
  printf,unit,';*        papco'
  printf,unit,';*    normally executed by papco_startup '
  printf,unit,';*'
  printf,unit,';* LAST TIME PRODUCED:       '
  printf,unit,';* ', systime(0)
  printf,unit,';'+star_str+star_str

  printf,unit,"print,'% "+fln+": Compiling found modules:'"
  printf,unit,"print,''"

  if keyword_set(EMPTY) then goto, out

  for i=0,n_elements(paths)-1 do begin
    printf,unit,'@'+ paths(i) +'init_module'
  endfor

out:

  printf,unit,"print,''"
  printf,unit,"print,'% papco_add_init: done'"

  close,unit  &  free_lun,unit

end
