;******************************************************************************
;******************************************************************************
;* FILE:
;*    $papco_PATH/papco_idlver.pro
;*
;*    This file belongs to the main-window of the papco-project. See
;*    papco.pro for further information.
;*
;* DESCRIPTION:
;*    implements IDL Version dependant tasks. Mainly widget routine calls.
;*    The idea here is that in papco the Version dependency
;*    becomes transparent, all such dependency is resolved here.
;*
;*    Those procedures are contained:
;*
;*       FUNCTION xfont, GROUP=GROUP
;*       -> calls the IDL xfont manager widget
;*
;*
;*       PRO
;*       ->
;*
;*
;* MODIFICATION HISTORY:
;*    October 1997, written by R. Friedel
;******************************************************************************
;******************************************************************************

;******************************************************************************
;* function:     papco_xfont, GROUP=GROUP
;*
;* description:  calls the IDL xfont manager widget. Under IDL 5, the old
;*               xfont didin't work, as it had not been updated to IDL 5.
;*               This is an IDL bug!
;*
;* inputs:       GROUP - the widget ID of the calling widget
;*
;* output:       as for xfont
;*
;* author:       R. Friedel, January 1998
;*
;* changes:      -
;******************************************************************************
function papco_xfont, GROUP=GROUP

COMMON PLOT_COMPOSER, widgetData

ver=fix(!version.RELEASE)

CASE 1 OF 

    (ver LT 4): message, 'PAPCO no longer supports IDL versions < 4'

    (ver EQ 4): BEGIN 
        return,xfont(/preserve,group=widgetdata.main_base)
    end

    else: BEGIN 
        return,xxfont(/preserve,group=widgetdata.main_base)
    END

ENDCASE 

END 

;******************************************************************************
;* function:     papco_widget_base, GROUP=GROUP
;*
;* description:  wrapper for WIDGET_BASE. Behaves the same way.
;*
;* inputs:       _EXTRA - any keywords set
;*
;* output:       none
;*
;* author:       R. Friedel, January 1998
;*
;* changes:      R. Friedel, December 2002, add wrapper for scrolling
;******************************************************************************
FUNCTION papco_widget_base, modal=modal, GROUP_LEADER=group_leader, _EXTRA=E
  
  COMMON plot_composer, widgetData
  
        ;check if group_leader exisits, otherwise don't call modal!        
  names=tag_names(E)
  res=where(names eq 'MODAL',count)
  if n_elements(modal) eq 0 then modal=1
  if not XREGISTERED('papco_main', /NOSHOW) then MODAL= 0
  if XREGISTERED('papco_configure') then MODAL= 1
  return,WIDGET_BASE(GROUP_LEADER=group_leader, _EXTRA=E, modal=modal )
  
END 

;******************************************************************************
;* procedure:    papco_xmanager, base, _EXTRA=E
;*
;* description:  wrapper for XMANAGER. Behaves the same way.
;*
;* inputs:       _EXTRA - any keywords set
;*
;* output:       none
;*
;* author:       R. Friedel, January 1998
;*
;* changes:      -
;******************************************************************************
pro papco_xmanager, Name, ID, _EXTRA=E

  XMANAGER, Name, ID, _EXTRA=E

END 

;******************************************************************************
;* procedure:    papco_xdisplayfile, filename, _EXTRA=E
;*
;* description:  wrapper for XDISPLAYFILE. Behaves the same way.
;*
;* inputs:       _EXTRA - any keywords set
;*
;* output:       none
;*
;* author:       R. Friedel, November 1998
;*
;* changes:      -
;******************************************************************************
PRO papco_xdisplayfile, filename, _EXTRA=E

ver=fix(!version.RELEASE)

CASE 1 OF

    (ver LT 4): message, 'PAPCO no longer supports IDL versions < 4'

    (ver eq 4): XDISPLAYFILE, filename, _EXTRA=E

    else: XDISPLAYFILE, filename, _EXTRA=E, /MODAL

ENDCASE 

END 

;******************************************************************************
;* function:     papco_lon64arr, dim
;*
;* description:  wrapper for lon64arr. returns a lonarr for versions 4
;*                or less, since these don't support lonar64.
;*
;* inputs:       dimension of array
;*
;* output:       lon64arr or lonarr
;*
;* author:       R. Friedel, October 1999
;*
;* changes:      -
;******************************************************************************
FUNCTION papco_lon64arr, dim

ver=!version.RELEASE
  
CASE 1 OF

    (ver LT 4): message, 'PAPCO no longer supports IDL versions < 4'

    (ver lt 5.2 ): return, lonarr(dim)

    else: return, lon64arr(dim) 

ENDCASE

END 
