;******************************************************************************
;* FILE:
;*    $PAPTO_PATH/papco_init.pro
;*
;* DESCRIPTION:
;*    initialize papco and compile all needed programs
;*
;* HOW TO START:
;*    from IDL, type @papco_init
;*    now called automatically by papco_startup
;*    afterwards, you can start papco by executing the command "papco"
;*
;* MODIFICATION HISTORY:
;*     August/september 1995, written by A. Keese
;*     November 1995, modified R. Friedel
;*     September 2002, modified R. Friedel
;******************************************************************************
print, ''
print, '--- Start papco-init -------------------------------------------------'
print, ''
print, '      Time utilities '
.r convert_time
.r utc2tai
.r tai2utc
.r int2utc
.r get_leap_sec
.r get_utc
.r anytim2cal
.r anytim2utc
.r mjd2date
.r check_ext_time
.r utc2int
.r date2mjd
.r check_int_time
.r papco_settime
.r papco_time
.r papco_remote_filesystem
.r papco_data_cache

print, '      Satellite by orbit utilities'
.r papco_orbitinfo
.r polar_createorbitinfo
.r crres_createorbitinfo
.r ampte_createorbitinfo
print, '      PAPCO-main-program'
@papco_forward		; define function - forwards
.r papco_settime
.r papco_color
.r papco_panel
.r papco_subtable_editor
.r papco_cursor
.r papco_slices
.r papco_edit_type
.r papco_draw
.r papco_files
.r papco_plotedit
.r papco_editslots
.r papco_defaults.pro
.r papco_get_remote_data
.r papco_output
.r papco_printer
.r papco_refresh_list
.r papco
print, '      General Plot Initialization'
.r panelset
.r cnvrttim
.r ticks
.r time_label_new
.r set_device
.r papco_panel_label
print, '      Color plot routines for papco'
.r autorange
.r plot_clr
.r papco_plot_colorspec
.r papco_colorbar
.r papco_color_bar
.r papco_ylim
.r papco_autorange
print, '      General routines for papco'
.r dealloc_lun
.r papco_annotate
.r papco_module_configure
.r papco_draw_window
.r entrybox
.r messagebox
.r papco_draw_eq_plane
print, ''
print, '    Other IDL packages for papco'
print, ''
print, '      Compiling CDAWlib routines '
@compile_cdaweb
print,''
print, '--- End papco_init: PAPCO Core compiled ------------------------------'
