;*****************************************************************************
; This file is part of the PAPCO software package. 
;
; PAPCO is a free IDL package to combine data plots written and
; maintained by A. Keese and R. Friedel.
;                                                           
;    For more information, check the papco home page at     
;    http://leadbelly/ccr/software/papco/papco.html       
;    for online Manual and downloadble latest version.      
;                                                           
; Comments and questions can be directed to friedel@lanl.gov  
;  
; You are free to modify and distribute this file. However, and
; changes not communicated to R. Friedel will not become part of the
; next release of PAPCO.
;*****************************************************************************
;+
; NAME:
;     PAPCO_MODULE_VERSION
;
; PURPOSE:
;     This function returns a string containing the current version of
;     a papco module. This information is read from the header of the
;     help file associated with that module / subplot type.
;     It is used to label the panel editor window of the module /sub
;     type. Date MUST be of format "dd mmm yyyy" and MUST come at end
;     of string. 
;
; CATEGORY:
;     Documentation
;
; KEYWORD PARAMETERS:
;     INFO:   Calls doc_library to display this header documentation.
;             1: print to terminal, 2: print to default printer
;
; INPUTS:
;     Module:  name of module, string
;
; CALLING SEQUENCE:
;     Result = PAPCO_VERSION()
;
; OUTPUTS:
;     This function returns a string of the module version information.
;
; MODIFICATION HISTORY:
;     Written by:  Reiner Friedel, May 1998
;     Modified:    Each time a new version is released
;-
;*****************************************************************************

FUNCTION papco_module_version, Module,  INFO = INFO

IF keyword_set(INFO) THEN BEGIN
    IF info EQ 2 THEN print = 1 ELSE print = 0
    doc_library, 'papco_module_version', print = print
    return, ''
ENDIF

helpfile = papco_module_helpfile(Module)

in_str = ''
ON_IOERROR,  out
openr, u, helpfile, /get_lun
readf, u, in_str & readf, u, in_str
pos = strpos(in_str, 'version')
IF pos NE -1 THEN version = strmid(in_str, pos, strlen(in_str)-pos) $
ELSE version = 'no version info in helpfile'
close, u & free_lun, u

return, version
  
out:
message, 'No helpfile found for module '+module, /cont
return, 'no helpfile found'
 
END
