;******************************************************************************
;* PROCEDURE:
;*      PRO papco_RefreshList
;*
;* DESCRIPTION:
;*      Refresh the listbox to display the currently selected plots
;*
;* INPUTS:
;*  none
;*
;* KEYWORDS:
;*  LIST  =  if set to 2, then also reset total panels.
;*
;* CALLING SEQUENCE:
;*  papco_RefreshList
;*
;* MODIFICATION HISTORY:
;*     written august 1995, Andreas Keese
;******************************************************************************
PRO papco_RefreshList, LIST=LIST
  
  COMMON PLOT_COMPOSER, widgetData
  COMMON papco_color_names
  COMMON RefreshList, old_maxPlotNo
  
  lb_plotInfos=widgetData.lb_plotInfos
  numberOfPlots=widgetData.numberOfPlots

;--- set the dw_plotInfos-Widget to be the Graphics-Device --------------------
  PAPCO_SET_PLOT, 'X'
  WIDGET_CONTROL, widgetData.dw_plotInfos,  GET_VALUE=drawIndex
  WSET, drawIndex

;--- calculate the char-height of the list-box --------------------------------
;  the character-heights of list-boxes and the character-height in
;  DRAW-widgets is NOT the same. Therefor, we try to calculate it.
  geom=WIDGET_INFO(lb_plotInfos, /GEOMETRY)
  char_height=(geom.scr_ysize - 2*geom.margin) / geom.ysize
  
;--- assign colors to bars in panel preview  
  dw_list_bgColor=0             ; the color of the preview's background
  dw_list_fgColor=blue          ; single non-overlap, non-overplot 
  dw_list_warnColor=red         ; general conflicts
  dw_list_oplotColor=dark_green ; valid overplots 
  dw_list_oplotWarnColor=cyan   ; exact overlaps
  
  max_panels=n_elements(widgetdata.plotInfos)
  orbitDescriptions=strarr(max_panels*2)   
  for i=0,max_panels-1 do orbitDescriptions(i*2)=string(i+1,format="(i2,':')")
  
;--- first, erase the drawing-widget ------------------------------------------
;  erase, dw_list_bgColor
  polyfill, [0,0, !d.x_size, !d.x_size], $
    [-1,!d.y_size, !d.y_size, -1], color=dw_list_bgColor, /dev

  if numberOfPlots ne 0 then begin

;--- what will the second element of panelVector be ? -------------------------
  maxPlotNo= max( widgetData.plotInfos(0:(numberOfPlots-1)).panelPosition + $
                      widgetData.plotInfos(0:(numberOfPlots-1)).panelHeight )

; REINER, WHY DO YOU DO THIS ???
;    if LIST ne 2 then $
;      if n_elements(old_maxPlotNo) ne 0 then $
;      maxPlotNo = maxPlotNo > old_maxPlotNo
      
  old_maxPlotNo=maxPlotNo
      
;--- calculate overlapping plots ----------------------------------------------
;     the 'overlaps'-array contains for each plot the plots it overlaps with
  overlapInfo={count:0, $
               with:intarr(N_ELEMENTS(widgetData.plotInfos)), $
               exact_count:0, $
               exact:intarr(N_ELEMENTS(widgetData.plotInfos))}
  overlaps=replicate(overlapInfo, N_ELEMENTS(widgetData.plotInfos))
  startPositions=widgetData.plotInfos(0:numberOfPlots-1).panelPosition
  endPositions=startPositions+$
    widgetData.plotInfos(0:numberOfPlots-1).panelHeight
  start_ind=sort(startPositions)

  for i=0, numberOfPlots-1 do begin
                        ; the next statement finds all plots, that overlap with
                        ; widgetData.plotInfos(i)
    overl=where((startPositions(i) GE startPositions AND $
                 startPositions(i) LT endPositions) OR $
                (endPositions(i) GT startPositions AND $
                 endPositions(i) LE endPositions) OR $
                (startPositions GE startPositions(i) AND $
                 startPositions LT endPositions(i)) , count)
    ; the conditions checked in this where-statement are:
    ;    1: does this plot start inside the range of another ?
    ; OR 2: does this plot end inside the range of another ?
    ; OR 3: does another plot start inside the range of this plot ?
    ; To check, if another plot ends inside this plot is not
    ; necessary, as this is done in the first and second check.
    ; The third check is neccessary, if a plot's end AND start
    ; lie inside of this plot's
    overlaps(i).count=count ;count is always GE 1, because the 
    overlaps(i).with(0:count-1)=overl ;plot i itself is contained  in 'overl'
    ; the next statements finds all plots that overlay EXACTLY.
    exact_overl=where((startPositions(i) EQ startPositions) AND $
                      (endPositions(i) EQ endPositions), count)   
    overlaps(i).exact_count=count
    overlaps(i).exact(0:count-1)=exact_overl
    endfor
      
    for i=0, numberOfPlots-1 do begin
      ; add a description to the list-box : --------------------------------
      currPlotInfo=widgetData.plotInfos(i)
      pos= currPlotInfo.panelPosition
      height= currPlotInfo.panelHeight

      ; panel position info ---------------------------------------------------
      posInfo=string(currPlotInfo.panelPosition,$
                     maxPlotNo, $
                     currPlotInfo.panelHeight, $
                     FORMAT='("[",i3.3,",",i3.3,",",i3.3,"]")')
      ; YSCL info -------------------------------------------------------------
      ysclStr='auto y-scl'
      IF currPlotInfo.manualYScaling THEN BEGIN
        ysclmin=strtrim(string(currplotInfo.yScaleMin, FORMAT='(G15.4)'),2)
        ysclmax=strtrim(string(currplotInfo.yScaleMax, FORMAT='(G15.4)'),2)
        ysclStr='y-scl: ' + '(' + ysclmin + ','+ysclmax +')'
      ENDIF
          
      orbitDescriptions(2*i)=string(i+1, format='(i2)') +': '+ $
        currPlotinfo.panelKind+' '+posInfo+' '+ysclStr
      orbitDescriptions(2*i+1)=papco_DescriptionFor(currPlotInfo, maxPlotNo)

      ; draw its preview ------------------------------------------------------
      right_side= geom.scr_xsize
      y1= geom.margin+i*2*char_height
      y1=!d.y_size - y1 - geom.margin - 4
      y2=y1 - char_height
      x1=!d.x_size-!d.x_size*FLOAT(currPlotInfo.panelPosition)/FLOAT(maxPlotNo)
      x2=!d.x_size-(!d.x_size*FLOAT(currPlotInfo.panelPosition + $
                                    currPlotInfo.panelHeight)/FLOAT(maxPlotNo))
      if abs(x2-x1) lt 1 then x2=x2+1.0
          
      ; decide on the color of the box depending on overlap / overplot 
      ; simple overlap : dw_list_warnColor
      ; overlap when all others are exact overplots: dw_list_oplotColor
      ; overlap if some others are overplots and /or not exact: 
      ; dw_list_oplotWarnColor
      color=dw_list_fgColor
          
      no_over=overlaps(i).count 
      no_exact_over=overlaps(i).exact_count 
      index=where(widgetData.plotInfos(overlaps(i).with(0:overlaps(i).count-1)).overplot EQ 1, no_over_overp)
          
      if no_over GT 1 then begin
        color=dw_list_warnColor
        if no_over eq no_exact_over then begin
          color=dw_list_oplotWarnColor
          if (no_over-1) eq no_over_overp then color=dw_list_oplotColor
        endif
      endif
          
     if currPlotInfo.overPlot then begin
       plots, [x1,x1,x2,x2,x1], [y1,y2,y2,y1,y1], col=color, /dev, thick=2

     ; draw line color
       xmid= long((x2+x1)/2.+ 0.5)+1 & ymid= long( (y2+y1)/2. + 0.5 )+1
       xoff= (x1-x2) / 2. * .4  & yoff= xoff/2.                  
       if yoff gt (y1-y2)/2 then begin
         yoff= ( y1-y2 ) / 2 * .4
         xoff= yoff * 2
       endif
       
       plotstyle = currPlotInfo.PLOTSTYLE
       color = currPlotInfo.COLOR
       linestyle = currPlotInfo.LINESTYLE
       thickness = currPlotInfo.THICK
       color=fixed_color_index(color)
       
       plots, [xmid-xoff, xmid+xoff], [ymid+yoff, ymid-yoff], $
         color=color, /dev, thick=1.
       plots, [xmid], [ymid], color=color, psym=plotStyle, /dev, thick=1.

     endif else begin
       polyfill, [x1,x1,x2,x2], [y1,y2,y2,y1], col=color, /dev
     endelse

; xyouts, right_side, y2, orbitDescriptions(2*i), /dev, color=dw_list_fgColor
    endfor                    ; next Plot-description...
  endif

  widget_control, widgetData.lb_plotInfos, set_value=orbitDescriptions
  
end
