function papco_str_join, s, delim
  result= s[0]
  for i=1,n_elements(s)-1 do begin
      result= result + delim + s[i]
  endfor
  return, result
end

function papco_matches, glob, file
  return, strmatch( file, glob )
end

function papco_rfs_hide_password, url
  s= str_sep( url, '@' )
  if n_elements(s) eq 1 then return, url
  protouserpass= s[0]
  rest= s[1]
  s= str_sep(protouserpass, ':' )
  s[n_elements(s)-1]='****'
  protouserpass= papco_str_join( s, ':' )
  return, protouserpass + '@' + rest
end

pro papco_web_open, url, lun
;; opens url directly into logical unit, avoiding f/s access and tedium of
;; a temporary file.  On unix this is implemented with a wget -O -, on windows
;; wget to a temporary file and open a lun from that.  Later versions of
;; papco may remove the dependence on wget.  Note wget formats ftp file listings
;; into html, so this would need to be implemented as well.
   wget_exe='wget'
   CASE strupcase(!version.os_family) OF
      'UNIX': BEGIN
          exe_str= wget_exe+" -T 10 -t 2 "+ url + " -O - -o /dev/null"
          print, exe_str
          spawn, exe_str, unit= lun, pid=pid
      END

      'WINDOWS': BEGIN
          f= findfile( getenv('TMP') + '\idl.papco_remote_filesystem.???.tmp', count=c )
          tmpfile= getenv('TMP') + '\idl_papco_remote_filesystem_'+string(c,format='(i3.3)')+'.tmp'
          exe_str= wget_exe+" -T 10 -t 2 "+ url + " -O "+tmpfile+" -o c:\wget.log"
          spawn, exe_str, pid=pid, result
          openr, lun, tmpfile, /get_lun, /delete
      END

  ENDCASE

end

;******************************************************************************
;* Procedure:    papco_wget_listing
;*
;* description:  Downloads listing of a remote directory.
;*
;* inputs:       url ie ftp://user.password@nis-ftp.lanl.gov/omni/
;*
;* output:       strarr of the files.
;*
;* keywords:     None.
;*
;* author:       Jeremy Faden, September 2004
;*
;* changes:      -
;******************************************************************************
function papco_wget_listing, url, monitor=monitor

  cd, curr=pwd
  cd, getenv( 'PAPCO_HOME' )

  if n_elements( monitor ) eq 0 then monitor= obj_new( 'papco_monitor' )

  if ( strpos( url, '/', /reverse_search ) ne ( strlen( url ) -1 ) ) then begin
      message, 'url must end in /'
  endif

  papco_web_open, url, unit

  content= ''
  lowerCaseContent=''  ;; folded case buffer
  line= ''

  cr= string(byte(10))
  while ( not eof( unit ) and strpos( lowerCaseContent, '<a' ) eq -1 ) do begin
      if monitor->isCancelled() then break
      readf, unit, line
      lowerCaseContent= lowerCaseContent + strlowcase( line ) + cr
      content= content + line + cr
  endwhile

  result= strarr(100)
  iresult= 0

  monitor->setTaskSize, 10   ;; it's indeterminate, but we'll count off groups of ten

  index= strpos( lowerCaseContent, "<a", 0 )
  while ( index ne -1 ) do begin

      while( not eof( unit ) and strpos( lowerCaseContent, 'href', index ) eq -1 ) do begin
          readf, unit, line
          lowerCaseContent= lowerCaseContent + strlowcase( line ) + cr
          content= content + line + cr
      endwhile
      index= strpos( lowerCaseContent, "href", index )
      if ( index eq -1 ) then break;

      while( not eof( unit ) and strpos( lowerCaseContent, '=', index ) eq -1 ) do begin
          readf, unit, line
          lowerCaseContent= lowerCaseContent + strlowcase( line ) + cr
          content= content + line + cr
      endwhile
      index = strpos( lowerCaseContent, "=", index )
      if ( index eq -1 ) then break;

      while ( not eof( unit ) and strpos( lowerCaseContent, '>', index ) eq -1 ) do begin
          readf, unit, line
          lowerCaseContent= lowerCaseContent + strlowcase( line ) + cr
          content= content + line + cr
      endwhile

      index= index+1;
      remaining = strmid( content, index )
      lowerCaseContent= strmid( lowerCaseContent, index )
      content= strmid( content, index )
      index= 0

      i= strpos( remaining, '>' )
      link= strmid( remaining, 1, i-2 )

       ;; apache puts sort by links on the headings.  ignore these
      if ( strpos( link, '?' ) eq 0 ) then goto, skip

      s= strpos( link, '/', /reverse_search )
      if ( s eq strlen(link)-1 ) then begin
          s2= strpos( link, '/', s-1, /reverse_search )
          file= strmid( link, s2+1, s-(s2+1) )
      endif else begin
          file= strmid( link, s+1, i-1-(s+1) )
      endelse

      if ( file eq '' ) then goto, skip

      result[iresult]= file
      iresult= iresult + 1
      if ( iresult ge n_elements( result ) ) then $
        result= [ result, strarr(100) ]

      skip:

      index= index + i + 1

      while ( not eof( unit ) and strpos( lowerCaseContent, '<a', index ) eq -1 ) do begin
          readf, unit, line
          lowerCaseContent= lowerCaseContent + strlowcase( line ) + cr
          content= content + line + cr
      endwhile
      index= strpos( lowerCaseContent, "<a", index )

      monitor->setProgress, iresult mod 10
      if ( iresult mod 10 eq 0 ) then begin
          monitor->setMessage, strtrim(iresult,2)+' files found'
      endif

      if monitor->isCancelled() then index=-1

  endwhile

  close, unit
  free_lun, unit

  if ( iresult eq 0 ) then begin
      return, ''
  endif else begin
      result= result[0:(iresult-1)]
  endelse

  monitor->setMessage, strtrim(iresult,2)+' files found'

  return, result

END

function papco_wget_unglob, root, glob, monitor=monitor
  if ( n_elements(monitor) eq 0 ) then monitor= obj_new( 'papco_monitor' )
  if ( n_params() eq 1 ) then begin
      i= strpos( root, '//' )
      i= strpos( root, '/', i+2 )
      host= strmid( root, 0, i+1 )
      glob= strmid( root, i+1 )
      rr= papco_wget_unglob( host, glob, monitor=monitor )
      if rr[0] eq '' then return, ''
      for i=0, n_elements(rr)-1 do begin
          rr[i]= host+rr[i]
      endfor
      return, rr
  endif

  surl= papco_rfs_hide_password( root+glob );
  monitor->setMessage, 'unglobbing '+surl

  dirfile= glob
  s= str_sep( dirfile, '/' )
  if ( n_elements(s) gt 1 ) then dirs= s[0:n_elements(s)-2] else dirs=['']
  file= s[n_elements(s)-1]

  for i=0,n_elements(dirs)-1 do begin
      ii= strpos( dirs[i], '?' )
      istar= strpos( dirs[i], '*' )
      if ( ii ne -1 or istar ne -1 ) then break
  endfor

  if ( i eq n_elements(dirs) ) then begin  ;; ROOT CONDITION -- no wildcards
      if ( dirs[0] eq '' ) then begin
          noGlobUrl= ''
      endif else begin
          noglobUrl= strjoin( dirs, '/' ) + '/'
      endelse
      monitor->setTasksize,5
      files= papco_wget_listing( root + noglobUrl, $
                                 monitor= monitor->newSubtaskMonitor( 0,5 ) )

      if ( files[0] eq '' ) then return, ''

      result= strarr(n_elements(files))
      iresult= 0
      for ifile=0,n_elements(files)-1 do begin
          if ( papco_matches( file, files[ifile] ) ) then begin
              result[iresult]= noglobUrl + files[ifile]
              iresult= iresult+1
          endif
      endfor
      if ( iresult eq 0 ) then begin
          result= ''
      endif else begin
          result= result[0:(iresult-1)]
      endelse
      return, result
  endif

  firstGlob= papco_str_join( dirs[0:i], '/' )
  if ( i+1 eq n_elements(dirs) ) then begin
      remainingGlob= file
  endif else begin
      remainingGlob= papco_str_join( dirs[(i+1):(n_elements(dirs)-1)], '/' ) + '/' + file
  endelse

  monitor->setTasksize, 5
  if ( not monitor->isCancelled() ) then begin
      firstUnglob= papco_wget_unglob( root, firstGlob, $
                                      monitor= monitor->newSubtaskMonitor( 0,1 ) )

      if ( firstUnglob[0] eq '' ) then begin
          return, ''
      endif

      monitor2= monitor->newSubtaskMonitor( 1,5 )

      result= strarr(300)
      iresult= 0
      monitor2->setTasksize, n_elements(firstUnglob)
      for i=0,n_elements(firstUnglob)-1 do begin
          if monitor2->isCancelled() then break;
          r1= papco_wget_unglob( root, firstUnglob[i] + '/' + remainingGlob, $
                                 monitor= monitor2->newSubtaskMonitor(i,i+1) )
          if ( r1[0] ne '' ) then begin
              while ( n_elements( r1 ) gt n_elements(result)-iresult ) do begin
                  result= [ result, strarr(100) ]
              endwhile
              result[iresult]= r1
              iresult= iresult+n_elements(r1)
          endif
      endfor
      if ( iresult eq 0 ) then begin
          return, ''
      endif else begin
          return, result[0:(iresult-1)]
      endelse
  endif

end

pro papco_remote_filesystem_test
  monitor= obj_new( 'papco_graph_monitor' )
  r= papco_wget_listing( 'http://genesis.lanl.gov/solar_wind_stats/', monitor=monitor )
  r= papco_wget_listing( 'http://papco:pap_dat@papco.org/data/polar/hydra/survey/', monitor=monitor )
  r= papco_wget_unglob( 'http://papco:pap_dat@papco.org/data/polar/hydra/survey/%Y%m%d_hyd_sv_v????.cdf' )
  r= papco_wget_listing( 'ftp://papco:pap_dat@nis-ftp.lanl.gov/noaa/NOAA_N12/sem/' )
  r= papco_wget_listing( 'ftp://papco:pap_dat@nis-ftp.lanl.gov/noaa/' )
  r= papco_wget_unglob( 'ftp://papco:pap_dat@nis-ftp.lanl.gov/noaa/NOAA_N12/sem/????/data/N12???????.dat.gz' )
  r= papco_wget_unglob( 'ftp://papco:pap_dat@nis-ftp.lanl.gov/noaa/', 'NOAA_N12/sem/????/data/N12???????.dat.gz' )

end

