;******************************************************************************
;* CALL (papco_set_module_env_var):
;*     PRO papco_set_module_env_var
;*
;* DESCRIPTION:
;*     This procedure runs through all the module default files and sets the
;*     required environmntal variables. Useful if you want to be in the PAPCO
;*     environment without starting the PAPCO widget (which normally does
;*     this).
;*
;* INPUTS:
;*     none
;*
;* KEYWORDS:
;*     VERBOSE   allows informative output or not
;*     INFO      prints papco info for this routine
;*
;* CALLING SEQUENCE:
;*     papco_set_module_env_var
;*
;* MODIFICATION HISTORY:
;*     written October 1997, Reiner Friedel
;;*****************************************************************************
pro papco_set_module_env_var, VERBOSE=VERBOSE, INFO=INFO

  COMMON MODULE_PATHS, paths          ;contains the paths found by find_modules
  COMMON GET_ERROR, get_err_no, get_err_msg, default_verbose
  
;--- Handle INFO keyword ------------------------------------------------------
  if keyword_set(INFO) then begin
    papco_routine_info,'papco_set_module_env_var','papco_set_module_env_var', $
    ROOT_DIR=papco_getenv('PAPCO_PATH')
  endif
  
;--- Get list of modules papcoadd files ---------------------------------------
  fn=n_elements(paths)
  if (fn eq 1) AND (paths(0) eq '') then begin
    message,'No modules found in !path', /cont
    return
  endif
  addinfiles=strarr(fn)
  for i=0,fn-1 do begin
    fname=papco_addpath(paths(i),'papco_interface')
    fname=fname+'papcoadd*.pro'
    addinfiles(i)=findfile(fname)
  endfor
  
;--- read module defaults -----------------------------------------------------
  FOR i=0,fn-1 DO BEGIN
    module=strplottype(strlowcase(addinfiles(i)))
    if keyword_set(VERBOSE) then message,module, /cont
    r_module_config, module, config_data, msg        ;get user defaults first
    if get_err_no eq 0 then begin
      for ii=0,n_elements(config_data)-1 do $
        papco_setenv,/FS,config_data(ii).env_var+'='+config_data(ii).path
    endif else begin
      r_module_default, paths(i), config_data, msg   ;get module defaults
      if get_err_no eq 0 then begin
        s_module_config, module, config_data
        for ii=0,n_elements(config_data)-1 do $
          papco_setenv,/FS,config_data(ii).env_var+'='+config_data(ii).path
      endif
    endelse
    if keyword_set(VERBOSE) then print, msg
  ENDFOR

end


