;******************************************************************************
;* PROCEDURE:
;*      PRO papco_write_paneldata_Event, Event
;*
;* DESCRIPTION:
;*	The slice-window displays a slice through the data,
;*	when the user clicks in the drawing-widget.
;*	This procedure handles events for that window.
;* INPUTS:
;*	Event	 	an XMANAGER-event
;*
;* KEYWORDS:
;* 	none
;*
;* CALLING SEQUENCE:
;*	called by XMANAGER
;*
;* MODIFICATION HISTORY:
;*     written May 1997, Reiner Friedel
;******************************************************************************
PRO papco_write_paneldata_Event, Event

COMMON PAPCO_WRITE_PANELDATA, slice_widget
COMMON PLOT_COMPOSER, widgetData

WIDGET_CONTROL,Event.Id,GET_UVALUE=Ev

CASE Ev OF
    'pb_add'  : BEGIN
        eventdata_dir=slice_widget.path
        fname=papco_fname(eventdata_dir+slice_widget.filename)
        result=findfile(fname,count=count)

        IF count eq 1 THEN BEGIN ;open file for append
            OPENU, f_unit, fname, /GET_LUN, /APPEND
        ENDIF ELSE BEGIN	      ;create new file for writing
            IF slice_widget.filename eq '' THEN BEGIN
               slice_widget.filename='paneldata.event'
            ENDIF
            fname=papco_fname(eventdata_dir+slice_widget.filename)
            OPENW, f_unit, fname, /GET_LUN
            slice_widget.status=1
            print,'% papco_write_paneldata: created ',fname
            papco_PANEL_Refresh,slice_widget
        ENDELSE

        WIDGET_CONTROL, slice_widget.lbl_sliceB , GET_VALUE=setB
        WIDGET_CONTROL, slice_widget.lbl_sliceD , GET_VALUE=setD
        WIDGET_CONTROL, slice_widget.lbl_slice2 , GET_VALUE=lbl2
        WIDGET_CONTROL, slice_widget.lbl_slice4 , GET_VALUE=lbl4
        WIDGET_CONTROL, slice_widget.lbl_slice6 , GET_VALUE=lbl6
        WIDGET_CONTROL, slice_widget.txt_comment, GET_VALUE=comment
        printf,f_unit,setB+' '+setD+'   '+lbl2+' '+lbl4+' '+lbl6+' '+comment
        print,'% papco_write_paneldata: appended ',fname
        close,f_unit
        free_lun,f_unit
        WIDGET_CONTROL, slice_widget.txt_comment, SET_VALUE=' '
    END

    'pb_close' : BEGIN
        WIDGET_CONTROL, slice_widget.slice_base, /DESTROY
    END

    'pb_help': $
        xdisplayfile, papco_helpfile('papco_write_paneldata_slice.help'), $
        title='papco Online-Help', group=event.top

     'txt_comment' :BEGIN
    END

    ELSE : BEGIN
        slice_widget=papco_panel_Event(event, slice_widget)
    END

ENDCASE

END

;******************************************************************************
;* PROCEDURE:
;*      PRO papco_write_paneldata, panelNr, seconds, yValue, CLOSE=CLOSE
;*
;* DESCRIPTION:
;*	The slice-window displays panelinfo, when the user clicks
;*	in the drawing-widget.
;*	This procedure opens that window and displays data about the position
;*      clicked, it x/y coordinates. A user-defined rountine can be called for
;*      auxilliary info, e.g. the ephemeris info.
;*
;* INPUTS:
;*	panelNr	 	an integer
;*			the number of the panel for which the slice is to be
;*			drawn
;*	seconds		a float
;*	yvalue		a float
;*			the time and the y-value, for the slice
;*
;* KEYWORDS:
;* 	CLOSE		when specified, the window is destroyed
;*
;* CALLING SEQUENCE:
;*	papco_write_paneldata, aPanel, sometime, 42.42
;*	papco_write_paneldata, /CLOSE
;*
;* MODIFICATION HISTORY:
;*     written october 1996, Reiner Friedel
;******************************************************************************
PRO papco_write_paneldata, panelNr, seconds, yValue, CLOSE=CLOSE

COMMON PAPCO_WRITE_PANELDATA, slice_widget
COMMON PLOT_COMPOSER, widgetData
COMMON ADDINS, plot_types
COMMON ISREAD, IsReadArr
COMMON mjdt, mjdt_start, mjdt_end    ;common time limit in mjdt
   
;-- close the window ? --------------------------------------------------------
IF KEYWORD_SET(CLOSE) THEN BEGIN
    IF N_ELEMENTS(slice_widget) eq 0 THEN RETURN
    IF XREGISTERED('PAPCO_WRITE_PANELDATA') THEN BEGIN
      print,'closing write slice'
      WIDGET_CONTROL, slice_widget.slice_base, /DESTROY
      slice_widget.slice_base=0
    ENDIF  
    RETURN
ENDIF

;-- IF the window exists, bring it in front. ELSE, create it ------------------
IF NOT XREGISTERED('PAPCO_WRITE_PANELDATA') THEN BEGIN
    Slice_Base=WIDGET_BASE(COLUMN=1, GROUP=widgetData.main_base, $
                           title='Write Paneldata window')

;-- set up label fields for time & y-value data -------------------------------
    set_label_base=WIDGET_BASE(slice_base, ROW=1, /FRAME)
    lbl_sliceA=WIDGET_LABEL(set_label_base, VALUE='Last click time:  ')
    click_time=papco_cursor_time(seconds,panelNr,/MJDT)
    click_time_str=convert_secondsToTime(click_time, /T90, /MJDT)
    lbl_sliceB=WIDGET_LABEL(set_label_base, VALUE=click_time_str)
    lbl_sliceC=WIDGET_LABEL(set_label_base, VALUE='        Y-value:')
    yvalstr=string(yValue, format="(g10.4)")
    lbl_sliceD=WIDGET_LABEL(set_label_base, VALUE=yvalstr)

;-- set up label fields for user data -----------------------------------------
    user_label_base=WIDGET_BASE(slice_base, COLUMN=1, /FRAME)
    lbl_slice1=WIDGET_LABEL(user_label_base, VALUE=strcenter('',75))
    lbl_slice2=WIDGET_LABEL(user_label_base, VALUE=strcenter('',75))
    lbl_slice3=WIDGET_LABEL(user_label_base, VALUE=strcenter('',75))
    lbl_slice4=WIDGET_LABEL(user_label_base, VALUE=strcenter('',75))
    lbl_slice5=WIDGET_LABEL(user_label_base, VALUE=strcenter('',75))
    lbl_slice6=WIDGET_LABEL(user_label_base, VALUE=strcenter('',75))
    dw_slice=0

; the routines used by papco_panel.pro define tags for a structure. Those
; tags will be stored in the structure 'additionalWData'. When you realize the
; window, you have to add your own window-specific data to that structure
; and afterwards assign it to widgetData.
    additionalWData={canceled:1}

;-- use the papco supplied widgets from papco_panel (same ones get
;   used for constructing panel editors!)
    dirpath=papco_getenv('PAPCO_EVENT_DATA')
    filter='.event'
    aPlotInfo=papco_getplotinfostruct()
    widgets=papco_panel_AddFile_Widgets(slice_base, aPlotInfo,$
                                        DIRPATH=dirpath, FILTER=filter)
    additionalWData=create_struct(widgets, additionalWData)
        
;-- set up entry field for comments to be added -------------------------------
    comment_base=WIDGET_BASE(slice_base, ROW=1, /FRAME)
    lbl_comment=WIDGET_LABEL(comment_base, VALUE='Comment:   ')
    txt_comment=WIDGET_TEXT(comment_base, XSIZE=60, YSIZE=1, EDITABLE=1, $
                              UVALUE='txt_comment')
    WIDGET_CONTROL, txt_comment, SET_VALUE=' '

;-- set up buttons for the Actions --------------------------------------------
    Butt_Base=WIDGET_BASE(Slice_Base, ROW=1, /FRAME)
    pb_add=WIDGET_BUTTON(Butt_Base, $
                         Value=strcenter('Add info to file', 22), $
                         UVALUE='pb_add')
    pb_help=WIDGET_BUTTON(Butt_Base, $
                          Value=strcenter('Help', 12), $
                          UVALUE='pb_help')
    pb_close=WIDGET_BUTTON(Butt_Base, $
                           Value=strcenter('Close', 12), $
			   UVALUE='pb_close')

    thisWidgetsData={slice_base:slice_base, $
                     txt_comment:txt_comment, $
                     lbl_sliceB:lbl_sliceB, $
                     lbl_sliceD:lbl_sliceD, $
		     lbl_slice1:lbl_slice1, $
	             lbl_slice2:lbl_slice2, $
         	     lbl_slice3:lbl_slice3, $
		     lbl_slice4:lbl_slice4, $
		     lbl_slice5:lbl_slice5, $
		     lbl_slice6:lbl_slice6, $
	             panelNr:panelNr, $
                     lastPanelDrawn:-1}

     slice_widget= $
        papco_panel_CreateWidgetData(thisWidgetsData, additionalWData)

    WIDGET_CONTROL, Slice_Base, /REALIZE
    XMANAGER, 'PAPCO_WRITE_PANELDATA', Slice_Base
ENDIF

;-- update the time, y-value label
click_time=papco_cursor_time(seconds,panelNr,/MJDT)
click_time_str=convert_secondsToTime(click_time, /T90, /MJDT)
yvalstr=string(yValue, format="(g10.4)")
WIDGET_CONTROL, slice_widget.lbl_sliceB, SET_VALUE=click_time_str
WIDGET_CONTROL, slice_widget.lbl_sliceD, SET_VALUE=yvalstr

papco_panel_Refresh,slice_widget
thisPlot=widgetData.plotsDrawn(panelNr)
this_plotInfo=widgetData.plotInfos(panelNr)
  
;--- now, we need to get the data --------------------------------------------
;    but we will only read the data, if the panel the user clicked is not the
;    panel that he last clicked into (in this case, the data is already read).
IF slice_widget.lastPanelDrawn NE panelNr THEN READDATA=1 else READDATA=0  
 
; ---  Call add-in routine for slice  -----------------------------------------
;      construct the draw call and trap any errors in user routine.
result=strpos(plot_types,strchminus(thisPlot.panelKind),0)
typeindex=where(result eq 0,count)
IF count ne 0 THEN BEGIN
    panelkind=strchminus(thisPlot.panelKind)
    proc_call='WriteSlice_'+panelkind
    if widgetData.default_trap eq 1 then $
      catch, error_status else error_status=0
    if error_status ne 0 then begin  ;call error handler
      papco_error_handler, $
        error_status, proc_call, panelkind, [0,0,0], /NO_ERR_DRAW
      error_status=0 & catch, /CANCEL ;disable error catching
      return
    endif  
ENDIF
  
CALL_PROCEDURE, proc_call, panelNr, seconds, yValue, READDATA=READDATA
  
catch, /CANCEL                ;disable error catching 
  
;--- keep old panel number- used for detecting panel changed of mouse ---------
slice_widget.lastPanelDrawn = panelNr     

END

;******************************************************************************
;* PROCEDURE:
;*      PRO papco_vert_slice_Event, Event
;*
;* DESCRIPTION:
;*	The slice-window displays a slice through the data,
;*	when the user clicks in the drawing-widget.
;*	This procedure handles events for that window.
;* INPUTS:
;*	Event	 	an XMANAGER-event
;*
;* KEYWORDS:
;* 	none
;*
;* CALLING SEQUENCE:
;*	called by XMANAGER
;*
;* MODIFICATION HISTORY:
;*     written august and september 1995, Andreas Keese
;******************************************************************************
PRO papco_vert_slice_Event, Event

COMMON papco_vert_slice, slice_widget
COMMON plot_composer, widgetdata
COMMON slice_calls, slice_calls

widget_control, Event.Id, GET_UVALUE=Ev
  
CASE ev OF

    'spb_mult':  slice_widget.mult  = event.select
    'spb_oplot': slice_widget.oplot = event.select

    'pb_done' :  widget_control, slice_widget.base, /destroy
    'pb_help':   xdisplayfile, papco_helpfile('papco_slice.help'), $
                  title='papco online-help', group=event.top
    'pb_print':  begin ;loop through slices for all panels if needed
        slice_widget.rsl_lines=0
         FOR i=0,n_elements(slice_calls)-1 DO BEGIN
            close_dev=[i,n_elements(slice_calls)-1]
            papco_printmenu_event,slice_calls(i), CLOSE_DEV=close_dev
        ENDFOR   
    END 
    'pb_output': BEGIN 
        ;establish error handler
        IF widgetData.default_trap EQ 1 THEN $
            catch, error_status ELSE error_status=0
        IF error_status NE 0 THEN BEGIN    ;call error handler
            papco_error_handler, $
              error_status, proc_call, '', [0,0,0], /NO_ERR_DRAW
            error_status=0 & catch, /CANCEL ;disable error catching
            return
        ENDIF 
        tmp_str=slice_widget.slice_call  &  tmp_str=str_sep(tmp_str,',')
        proc_call=tmp_str(0)  &  panelNr=fix(tmp_str(1))
        seconds=float(tmp_str(2))  &  yValue=float(tmp_str(3))
        CALL_PROCEDURE,proc_call,panelNr,seconds,yValue,/OUTPUT
        catch, /CANCEL        ;disable error catching 
    END   
    ELSE : BEGIN
        WIDGET_CONTROL, slice_widget.ef_nplot, GET_VALUE=x
        slice_widget.nplot = x
    END  
ENDCASE 

END

;******************************************************************************
;* PROCEDURE:
;*      PRO papco_vert_slice, panelNr, seconds, yValue, CLOSE=CLOSE
;*
;* DESCRIPTION:
;*	The slice-window displays a slice through the data,
;*	when the user clicks in the drawing-widget.
;*	This procedure opens that window and calls other routines, that draw
;*	the slice.
;*
;* INPUTS:
;*	panelNr	 	an integer
;*			the number of the panel for which the slice is to be
;*			drawn
;*	seconds		a float
;*	yvalue		a float
;*			the time and the y-value, for that the slice shall
;*			be drawn
;*
;* KEYWORDS:
;* 	CLOSE		when specified, the window is destroyed
;*
;* CALLING SEQUENCE:
;*	papco_vert_slice, aPanel, convert_tzero_to_t90(3600, 1, 1990), 42.42
;*	papco_vert_slice, /CLOSE
;*
;* MODIFICATION HISTORY:
;*     written august and september 1995, Andreas Keese
;*     modified for modules may 1996, Reiner Friedel
;******************************************************************************
PRO papco_vert_slice, panelNr, seconds, yValue, CLOSE=CLOSE, $
                      OVERPLOT = OVERPLOT

COMMON papco_vert_slice, slice_widget
COMMON plot_composer, widgetdata
COMMON addins, plot_types
COMMON isread, isreadarr
  
IF keyword_set(OVERPLOT) THEN overplot=OVERPLOT ELSE overplot=0
panel_kind = widgetData.plotsDrawn(panelNr).PANELKind

;-- close the window ? --------------------------------------------------------
IF keyword_set(close) THEN BEGIN 
    IF xregistered('papco_vert_slice') THEN $
        IF n_elements(slice_widget) GT 0 THEN BEGIN 
	    IF slice_widget.base NE 0 THEN $
              widget_control, slice_widget.base, /destroy
            slice_widget.base=0
        ENDIF 
    return 
ENDIF 

;-- if the window exists, bring it in front. ELSE, create it ------------------
IF NOT xregistered('papco_vert_slice') THEN BEGIN
    slice_base=widget_base(column=1, group=widgetdata.main_base, $
		           title='PAPCO vertical slice window - '+panel_kind)

    ;-- setup draw area -------------------------------------------------------
    draw_base = WIDGET_BASE(Slice_base, COLUMN=1, /FRAME)
    dw_Slice = WIDGET_DRAW(draw_base, $
      XSIZE=widgetdata.default_vert_slice_size(0), $
      YSIZE=widgetdata.default_vert_slice_size(1))

    ;-- set up label fields for user data -------------------------------------
    user_label_base=WIDGET_BASE(slice_base, COLUMN=1, /FRAME)
    lbl_slice1=WIDGET_LABEL(user_label_base,VALUE=strcenter('uservalues',80))
    lbl_slice2=WIDGET_LABEL(user_label_base,VALUE=strcenter('uservalues',80))

    ;-- setup choices for multiple plots, either in same plot window----------
    ;   or as multiple plot on a page.
    mult_base =  WIDGET_BASE(Slice_Base, ROW=1, /FRAME)
    toggle_base = WIDGET_BASE(mult_base, /ROW, /NONEXCLUSIVE)
    spb_mult = WIDGET_BUTTON(toggle_base, UVALUE = 'spb_mult', $
                             VALUE = 'Allow multiple slices')
    spb_oplot = WIDGET_BUTTON(toggle_base, UVALUE='spb_oplot', $
                              VALUE = 'Overplot')
    WIDGET_CONTROL, spb_oplot, SET_BUTTON = 1
    ef_nplot = CW_FIELD(mult_base, TITLE = 'Slices +/- :', /ALL_EVENTS, $ 
                        UVALUE='ef_nplot', /INTEGER, XSIZE = 2, VALUE = 0)
  
    ;-- set up buttons for the Actions ----------------------------------------
    Butt_Base=WIDGET_BASE(Slice_Base, ROW=1, /FRAME)
    pb_help=WIDGET_BUTTON(Butt_Base, Value=strcenter('Help', 12), $
                          UVALUE='pb_help')
    pb_print=WIDGET_BUTTON(Butt_Base, Value=strcenter('Print', 12), $
                           UVALUE='pb_print')
    pb_output=WIDGET_BUTTON(Butt_Base, Value=strcenter('Output', 12), $
                           UVALUE='pb_output')    
    pb_done=WIDGET_BUTTON(Butt_Base, Value=strcenter('Close', 12), $
                          UVALUE='pb_done')
    slice_widget={PAPCO_VERT_SLICE_1, $
                  mult:0, oplot:1, nplot:1, ef_nplot:ef_nplot, $
                  bang_x:!x, bang_y:!Y, $
                  rsl_lines:0 , $
                  overplot:overplot, $
                  base:slice_base, $
	          dw_slice:dw_slice, $
                  lbl_slice1:lbl_slice1, $
                  lbl_slice2:lbl_slice2, $
                  pb_output:pb_output, $
                  slice_call:'', $
	          panelNr:panelNr, $
                  lastPanelDrawn:-1}
    
    widget_control, slice_base, /realize
    xmanager, 'papco_vert_slice', slice_base, /JUST_REG
ENDIF 
  
slice_widget.overplot=overplot
IF slice_widget.overplot EQ 0 THEN BEGIN 
    slice_widget.rsl_lines=0
    slice_widget.slice_call=''
ENDIF

thisPlot=widgetData.plotsDrawn(panelNr)
this_plotInfo=widgetData.plotInfos(panelNr)
  
;--- now, we need to get the data --------------------------------------------
;    but we will only read the data, if the panel the user clicked is not the
;    panel that he last clicked into (in this case, the data is already read).
IF slice_widget.lastPanelDrawn NE panelNr THEN BEGIN
    message, 'Reading data for slice...', /cont
    papco_get_slice_data, panelNr
    READDATA=1
    message, '...data read', /cont
ENDIF ELSE READDATA=0
    
;--- prepare the drawing widget for plotting ----------------------------------
IF !D.name eq 'X' THEN BEGIN 
    widget_control, slice_widget.dw_slice,  get_value=drawindex
    wset, drawindex
ENDIF
  
;--- store the current coordinate system --------------------------------------
old_x = !x  &  old_y = !y  &  old_p = !p

; ---  Call add-in routine for slice  -----------------------------------------
;      construct the draw call and trap any errors in user routine.

;make sure panelkind actually a loaded module...
result=strpos(plot_types,strchminus(thisPlot.panelKind),0)
typeindex=where(result eq 0,count)
IF count ne 0 THEN BEGIN
    panelkind=strchminus(thisPlot.panelKind)
    proc_call='vert_slice_'+panelkind
    proc_prmt='panelNr, seconds, yValue'
    slice_call=proc_call+', '+ $
        string(panelNr)+','+string(seconds)+','+string(yValue)    
    if widgetData.default_trap eq 1 then $
      catch, error_status else error_status=0
    if error_status ne 0 then begin  ;call error handler
        papco_error_handler, $
          error_status, proc_call, panelkind, [0,0,0], /NO_ERR_DRAW
        error_status=0 & catch, /CANCEL ;disable error catching
        return
    ENDIF   
    if slice_widget.slice_call eq '' then $
      slice_widget.slice_call=slice_call $
      else slice_widget.slice_call=slice_widget.slice_call+'/'+slice_call
    CALL_PROCEDURE, proc_call, panelNr, seconds, yValue, READDATA=READDATA
    catch, /CANCEL                ;disable error catching    
ENDIF ELSE BEGIN
    message, 'Cannot do slice, module '+thisPlot.panelKind+' not found', /cont
    return
ENDELSE 

;--- restore the coordinate-system --------------------------------------------
!x = old_x  &  !y = old_y  &  !p = old_p
  
;--- keep old panel number- used for detecting panel changed of mouse ---------
slice_widget.lastPanelDrawn = panelNr   

END

;******************************************************************************
;* PROCEDURE:
;*      PRO papco_horiz_slice_Event, Event
;*
;* DESCRIPTION:
;*	The slice-window displays a slice through the data,
;*	when the user clicks in the drawing-widget.
;*	This procedure handles events for that window.
;* INPUTS:
;*	Event	 	an XMANAGER-event
;*
;* KEYWORDS:
;* 	none
;*
;* CALLING SEQUENCE:
;*	called by XMANAGER
;*
;* MODIFICATION HISTORY:
;*     written May 1998, Reiner Friedel
;******************************************************************************
PRO papco_horiz_slice_Event, Event

COMMON papco_horiz_slice, slice_widget
COMMON plot_composer, widgetdata
COMMON slice_calls, slice_calls

widget_control, Event.Id, GET_UVALUE=Ev

CASE ev OF
    'pb_done' :  widget_control, slice_widget.base, /destroy
    'pb_help':   xdisplayfile, papco_helpfile('papco_slice.help'), $
                  title='papco online-help', group=event.top
    'pb_print':  begin ;loop through slices for all panels if needed
      slice_widget.rsl_lines=0
      for i=0,n_elements(slice_calls)-1 do begin
        close_dev=[i,n_elements(slice_calls)-1]
        papco_printmenu_event,slice_calls(i), CLOSE_DEV=close_dev
      endfor  
    end
    'pb_output': begin
      ;establish error handler
      if widgetData.default_trap eq 1 then $
        catch, error_status else error_status=0
      if error_status ne 0 then begin    ;call error handler
        papco_error_handler, $
          error_status, proc_call, '', [0,0,0], /NO_ERR_DRAW
        error_status=0 & catch, /CANCEL ;disable error catching
        return
      endif
      tmp_str=slice_widget.slice_call  &  tmp_str=str_sep(tmp_str,',')
      proc_call=tmp_str(0)  &  panelNr=fix(tmp_str(1))
      seconds=float(tmp_str(2))  &  yValue=float(tmp_str(3))
      CALL_PROCEDURE,proc_call,panelNr,seconds,yValue,/OUTPUT
      catch, /CANCEL        ;disable error catching 
    end  
    else : begin & end
ENDCASE 

END

;******************************************************************************
;* PROCEDURE:
;*      PRO papco_horiz_slice, panelNr, seconds, yValue, CLOSE=CLOSE
;*
;* DESCRIPTION:
;*	The slice-window displays a slice through the data,
;*	when the user clicks in the drawing-widget.
;*	This procedure opens that window and calls other routines, that draw
;*	the slice.
;*
;* INPUTS:
;*	panelNr	 	an integer
;*			the number of the panel for which the slice is to be
;*			drawn
;*	seconds		a float
;*	yvalue		a float
;*			the time and the y-value, for that the slice shall
;*			be drawn
;*
;* KEYWORDS:
;* 	CLOSE		when specified, the window is destroyed
;*
;* CALLING SEQUENCE:
;*	papco_horiz_slice, aPanel, seconds
;*	papco_horiz_slice, /CLOSE
;*
;* MODIFICATION HISTORY:
;*     written May 1998, Reiner Friedel
;******************************************************************************
PRO papco_horiz_slice, panelNr, seconds, yValue, CLOSE=CLOSE, $
                       OVERPLOT=overplot

COMMON papco_horiz_slice, slice_widget
COMMON plot_composer, widgetData
COMMON addins, plot_types
COMMON isread, IsReadArr

if keyword_set(OVERPLOT) then overplot=OVERPLOT else overplot=0
panel_kind=widgetData.plotsDrawn(panelNr).PANELKind

;-- close the window ? --------------------------------------------------------
IF KEYWORD_SET(CLOSE) THEN BEGIN
    IF XREGISTERED('papco_horiz_slice') THEN $
        IF N_ELEMENTS(slice_widget) GT 0 THEN BEGIN
	    IF slice_widget.base NE 0 THEN $
  	       WIDGET_CONTROL, slice_widget.base, /DESTROY
            slice_widget.base=0
        ENDIF
    RETURN
ENDIF

;-- if the window exists, bring it in front. ELSE, create it ------------------
IF NOT XREGISTERED('papco_horiz_slice') THEN BEGIN
    slice_Base=WIDGET_BASE(COLUMN=1, GROUP=widgetData.main_base, $
		           title='Horizontal Slice-window - '+panel_kind)

    ;-- setup draw area -------------------------------------------------------
    draw_base=WIDGET_BASE(Slice_base, COLUMN=1, /FRAME)
    dw_Slice  =WIDGET_DRAW(draw_base, XSIZE=500, YSIZE=500)

    ;-- set up label fields for user data -------------------------------------
    user_label_base=WIDGET_BASE(slice_base, COLUMN=1, /FRAME)
    lbl_slice1=WIDGET_LABEL(user_label_base,VALUE=strcenter('uservalues',80))
    lbl_slice2=WIDGET_LABEL(user_label_base,VALUE=strcenter('uservalues',80))

    ;-- set up buttons for the Actions ----------------------------------------
    Butt_Base=WIDGET_BASE(Slice_Base, ROW=1, /FRAME)
    pb_help=WIDGET_BUTTON(Butt_Base, Value=strcenter('Help', 12), $
                          UVALUE='pb_help')
    pb_print=WIDGET_BUTTON(Butt_Base, Value=strcenter('Print', 12), $
                           UVALUE='pb_print')
    pb_output=WIDGET_BUTTON(Butt_Base, Value=strcenter('Output', 12), $
                            UVALUE='pb_output')    
    pb_done=WIDGET_BUTTON(Butt_Base, Value=strcenter('Close', 12), $
			      UVALUE='pb_done')
    slice_widget={PAPCO_HORIZ_SLICE_b, $
                       rsl_lines:0, $
                       overplot:overplot, $
                       base:slice_base, $
	               dw_slice:dw_slice, $
		       lbl_slice1:lbl_slice1, $
                       lbl_slice2:lbl_slice2, $
                       pb_output:pb_output, $
                       slice_call:'', $
	               panelNr:panelNr, $
		       lastPanelDrawn:-1}
     WIDGET_CONTROL, Slice_Base, /REALIZE
     XMANAGER, 'papco_horiz_slice', slice_Base, /JUST_REG
ENDIF

slice_widget.overplot=overplot
if slice_widget.overplot eq 0 then begin
    slice_widget.rsl_lines=0
    slice_widget.slice_call=''
endif  
thisPlot=widgetData.plotsDrawn(panelNr)
this_plotInfo=widgetData.plotInfos(panelNr)

;--- now, we need to get the data --------------------------------------------
;    but we will only read the data, if the panel the user clicked is not the
;    panel that he last clicked into (in this case, the data is already read).

IF slice_widget.lastPanelDrawn NE panelNr THEN BEGIN
    message, 'Reading data for slice...', /cont
    papco_get_slice_data, panelNr
    READDATA=1
    message, '...data read', /cont
endif else READDATA=0

;--- prepare the drawing widget for plotting ----------------------------------
if !D.name eq 'X' then begin
    widget_control, slice_widget.dw_slice,  get_value=drawindex
    wset, drawindex
endif   

;--- store the current coordinate system --------------------------------------
old_x = !x  &  old_y = !y  &  old_p = !p

; ---  Call add-in routine for slice  -----------------------------------------
;      construct the draw call and trap any errors in user routine.

;make sure panelkind actually a loaded module...
result=strpos(plot_types,strchminus(thisPlot.panelKind),0)
typeindex=where(result eq 0,count)
IF count ne 0 THEN BEGIN
    panelkind=strchminus(thisPlot.panelKind)
    proc_call='horiz_slice_'+panelkind
    proc_prmt='panelNr, seconds, yValue'
    slice_call=proc_call+', '+ $
        string(panelNr)+','+string(seconds)+','+string(yValue)    
    if widgetData.default_trap eq 1 then $
      catch, error_status else error_status=0
    if error_status ne 0 then begin  ;call error handler
      papco_error_handler, $
        error_status, proc_call, panelkind, [0,0,0], /NO_ERR_DRAW
      error_status=0 & catch, /CANCEL ;disable error catching
      return
    endif  
    if slice_widget.slice_call eq '' then $
      slice_widget.slice_call=slice_call $
      else slice_widget.slice_call=slice_widget.slice_call+'/'+slice_call
    CALL_PROCEDURE, proc_call, panelNr, seconds, yValue, READDATA=READDATA
    catch, /CANCEL                ;disable error catching    
ENDIF ELSE BEGIN
    message, 'Cannot do slice, module '+thisPlot.panelKind+' not found', /cont
    return
ENDELSE

; --- restore the coordinate-system -------------------------------------------
!x = old_x  &  !y = old_y  &  !p = old_p

;--- keep old panel number- used for detecting panel changed of mouse ---------
slice_widget.lastPanelDrawn = panelNr   

END

;******************************************************************************
;* PROCEDURE:
;*      PRO papco_multiple_slice_Event, Event
;*
;* DESCRIPTION:
;*	The multiple slice-window displays a list of possible slices
;*      and allows the user to choose more than one.
;*	This procedure handles events for that window.
;*
;* INPUTS:
;*	Event	 	an XMANAGER-event
;*
;* KEYWORDS:
;* 	none
;*
;* CALLING SEQUENCE:
;*	called by XMANAGER
;*
;* MODIFICATION HISTORY:
;*      written march 2000, Reiner Friedel
;******************************************************************************
PRO papco_multiple_slice_Event, Event

  common papco_multiple_slice, multiple_slice_widgetdata
  common plot_composer, widgetdata
  
  widget_control,event.id,get_uvalue=ev
  
  case ev of
    'mpb_slices' : BEGIN
      WIDGET_CONTROL,multiple_slice_widgetdata.mpb_slices, $
        GET_VALUE=result
      multiple_slice_widgetdata.slice_set=result     
    END
    'pb_done' :  widget_control, multiple_slice_widgetdata.base, /destroy
    'pb_help' :  xdisplayfile, papco_helpfile('papco_multiple_slice.help'), $
                  title='papco online-help', group=event.top
    else : begin & end
  endcase

END

;******************************************************************************
;* FUNCTION
;*      papco_multiple_slice
;*
;* DESCRIPTION:
;*	Sets up widget to choose multiple slices
;*
;* INPUTS:
;*	slice_name    string array of slice name
;*
;* OUTPUTS:
;*      result        bytearray of slices set
;* KEYWORDS:
;* 	none
;*
;* CALLING SEQUENCE:
;*	result=papco_multiple_slice(slice_name)
;*
;* MODIFICATION HISTORY:
;*     written march 20007, Reiner Friedel
;******************************************************************************
FUNCTION papco_multiple_slice, slice_name, slice_set
  
  common plot_composer, widgetdata
  common papco_multiple_slice, multiple_slice_widgetdata
  
  multiple_slice_base=papco_widget_base(column=1, group=widgetdata.main_base, $
                                title='PAPCO select multiple slices', /MODAL)  
  
;-- set up buttons for slice choiuces -----------------------------------------
  index=where(slice_name.FLAGS eq 0,n_slices)
  names=slice_name(index).NAME
  
  slice_choice=WIDGET_BASE(multiple_slice_base, column=1, /frame,/align_center)
  
  mpb_slices=CW_BGROUP(slice_choice, names, COLUMN=1,/NONEXCLUSIVE, $
                       LABEL_TOP='Select multiple slice combination', $
                       UVALUE='mpb_slices', SET_VALUE=slice_set)    
  
;-- set up buttons for the Actions --------------------------------------------
  Butt_Base=WIDGET_BASE(multiple_slice_base, ROW=1, /FRAME)
  pb_help=WIDGET_BUTTON(Butt_Base, Value=strcenter('Help', 12), $
                        UVALUE='pb_help')
  pb_done=WIDGET_BUTTON(Butt_Base, Value=strcenter('Close', 12), $
                        UVALUE='pb_done')
  multiple_slice_widgetdata={PAPCO_MULTIPLE_SLICE_1, $
                             slice_set:slice_set, $
                             base:multiple_slice_base, $
                             mpb_slices:mpb_slices}  
  
  widget_control, multiple_slice_base, /realize
  papco_xmanager, 'papco_multiple_slice', multiple_slice_base
  
  return,multiple_slice_widgetdata.slice_set
  
end  

;******************************************************************************
;* PROCEDURE:
;*      PRO papco_get_slice_data, panelNr
;*
;* DESCRIPTION:
;*      This routine is called by the built in OR user slices to get the
;*      data for the panel that the mouse is curently in.
;*      Also checks the ISREAD common, data might not need to be read again
;*      anyway!
;*
;*      NEW for PAPCO 10: call the whole draw_plot_type routine. If
;*      get_data_call is empty, use this method - if not, stick to old
;*                                                method.
;*
;* INPUTS:
;*      panelNr      no of panel for which to read data
;*
;* KEYWORDS:
;* 	none
;*
;* CALLING SEQUENCE:
;*	called by XMANAGER
;*
;* MODIFICATION HISTORY:
;*     written April 2000, Reiner Friedel
;******************************************************************************
PRO papco_get_slice_data, panelNr
  
common addins, plot_types
common isread, isreadarr
common plot_composer, widgetdata
  
thisPlot=widgetData.plotsDrawn(panelNr)
this_plotInfo=widgetData.plotInfos(panelNr)
  
result=strpos(plot_types,strchminus(thisPlot.panelKind),0)
typeindex=where(result eq 0,count)

IF (count ne 0) AND (NOT widgetdata.default_slice_reload) THEN BEGIN 

    ; plot_type is add-in, slice reload, proceed
    WIDGET_CONTROL,/HOURGLASS        
    message, strchminus(thisPlot.panelKind), /cont

    IF widgetData.plotsDrawn(panelNr).get_data_call eq '' then begin
      ;call the whole draw routine with OUTPUT=2 
      ;(no plot, make plot data only, includes read of data, ISREAD array)
      proc_call='draw_'+thisPlot.panelkind
      ;establish error handler
      if widgetData.default_trap eq 1 then $
        catch, error_status else error_status=0
      if error_status ne 0 then begin    ;call error handler
        papco_error_handler, error_status, proc_call, panelkind, panelVector
        error_status=0 & catch, /CANCEL  ;disable error catching
      endif          
      ;call the draw procedure from papcoadd
      orbitNr=0 & Isread=0 & isread = IsReadArr(typeindex(0))
      CALL_PROCEDURE, proc_call, [0,1,1], this_plotInfo, orbitNr, $
          get_data_call, slice_type, Isread, OUTPUT=2
      catch, /CANCEL        ;disable error catching 
      widgetData.plotInfos(panelNr)=this_plotInfo

    ENDIF ELSE BEGIN

      IF NOT EXECUTE(widgetData.plotsDrawn(panelNr).get_data_call) $
        THEN BEGIN
        dummy=messageBox(['Sorry, there seems to be an error',$
                         'I cannot read the data for the panel.', '', $
                         'Used get_data_call:',$
                         widgetData.plotsDrawn(panelNr).get_data_call, '', $
                         'To change the definition of get_data_call',$
                         'edit the papcoadd file for this module'], ['Ok'])
        return
      ENDIF 
    ENDELSE

ENDIF  
  
END  
