;******************************************************************************
;* PROCEDURE:
;*      PRO papco_subtable_editor_refresh
;*
;* DESCRIPTION:
;*	Referesh routine for papco_subtable_editor
;*
;* INPUTS:
;*      
;*
;* KEYWORDS:
;*      
;*
;* OUTPUT:
;*      
;*
;* CALLING SEQUENCE:
;*	
;*
;* MODIFICATION HISTORY:
;*     August 1999, written by Reiner Friedel
;******************************************************************************
PRO papco_subtable_editor_refresh, SUB_TBL=SUB_TBL, $
                                   NEW_IDL_TBL=NEW_IDL_TBL, $
                                   NEW_PAPCO_TBL=NEW_PAPCO_TBL
  
COMMON edit_color_data, editwidgetData
COMMON color_tbl_names, idl_color_tbl_names, papco_color_tbl_names
COMMON papco_color
COMMON papco_color_names  
  
if keyword_set(SUB_TBL) then begin
    name=color_bar_names(editwidgetData.channel)
    name=string(editwidgetData.channel,format="('# ',i1,'  ->  ')")+name
    WIDGET_CONTROL, editwidgetData.curr_sub_lbl_2, $
      SET_VALUE=strformat(name,30,/LEFT)
ENDIF 
  
if keyword_set(NEW_IDL_TBL) then begin
    WIDGET_CONTROL, editwidgetData.pb_load_new, SENSITIVE=1
    name=strformat(idl_color_tbl_names(editwidgetData.idl_tbl),25,/LEFT) 
    WIDGET_CONTROL, editwidgetData.new_sub_lbl_2, $
      SET_VALUE=name 
ENDIF 
  
if keyword_set(NEW_PAPCO_TBL) then begin
    WIDGET_CONTROL, editwidgetData.pb_load_new, SENSITIVE=1
    name=strformat(papco_color_tbl_names(editwidgetData.papco_tbl),25,/LEFT) 
    WIDGET_CONTROL, editwidgetData.new_sub_lbl_2, $
      SET_VALUE=name   
ENDIF   
  
END   

;******************************************************************************
;* PROCEDURE:
;*      PRO papco_subtable_editor
;*
;* DESCRIPTION:
;*	Widget to interactively modify PAPCO color sub-tables
;*
;* INPUTS:
;*      
;*
;* KEYWORDS:
;*      
;*
;* OUTPUT:
;*      
;*
;* CALLING SEQUENCE:
;*	
;*
;* MODIFICATION HISTORY:
;*     August 1999, written by Reiner Friedel
;******************************************************************************
PRO papco_subtable_editor, GROUP=group
  
COMMON PLOT_COMPOSER, widgetData
COMMON edit_color_data, editwidgetData
COMMON color_tbl_names, idl_color_tbl_names, papco_color_tbl_names
COMMON papco_color
COMMON papco_color_names  
  
; if GROUP is not specified, the group-leader will be the desktop
IF NOT KEYWORD_SET(GROUP) THEN GROUP=0  
  
; set the label for the action-button
IF NOT KEYWORD_SET(ACTION) THEN ACTION='Done'
  
aPlotInfo=papco_getplotinfostruct()
additionalWData={canceled:1}
  
;--- create the base-window ---------------------------------------------------
panel_base=papco_WIDGET_BASE(title='PAPCO Color Sub-Table Editor', $
                             column=1, GROUP_LEADER=group, /MODAL)    
  
;--- add the papco panel widget for choosing the color bar for color plots ----
widgets=papco_panel_Addcolorbar_Widgets(panel_base, aPlotInfo)
additionalWData=create_struct(widgets, additionalWData)  
  
;--- add list of IDL color tabel names ----------------------------------------
idl_color_tbl_names=''
LOADCT, GET_NAMES=idl_color_tbl_names
idl_name_list=CW_BGROUP(panel_base, idl_color_tbl_names, $
                        COLUMN=3, /FRAME, /RETURN_INDEX, $
                        LABEL_TOP='IDL Color Tables', $
                        /SCROLL, X_SCROLL_SIZE=440, Y_SCROLL_SIZE=120, $
                        UVALUE='idl_name_list',/EXCLUSIVE)
  
;--- add list of PAPCO defined  color tabel names -----------------------------
tbl_path=papco_getenv('PAPCO_PATH')
file_tbl=tbl_path+'papco.tbl'

; Get names of color tables in file
papco_color_tbl_names=''
LOADCT, file=file_tbl, GET_NAMES=papco_color_tbl_names 
papco_tbl_idx = [1, 2, 41]
papco_color_tbl_names=papco_color_tbl_names[papco_tbl_idx]
papco_name_list=CW_BGROUP(panel_base, papco_color_tbl_names, $
                          COLUMN=3, /FRAME, /RETURN_INDEX, $
                          LABEL_TOP='PAPCO Color Tables', $
                          XSIZE=440, $
                          UVALUE='papco_name_list',/EXCLUSIVE)  
  
;--- add loading widget for color tables --------------------------------------
load_tbl_base=WIDGET_BASE(panel_base, COLUMN=1, /FRAME)
curr_sub_base=WIDGET_BASE(load_tbl_base,ROW=1)
curr_sub_lbl_1=WIDGET_LABEL(curr_sub_base, $
                              VALUE='Current PAPCO Color Sub-Table: ')
name=color_bar_names(aPlotInfo.channel)
name=string(aPlotInfo.channel,format="('# ',i1,'  ->  ')")+name
curr_sub_lbl_2=WIDGET_LABEL(curr_sub_base, $
                              VALUE=strformat(name,30,/left))
  
new_sub_base=WIDGET_BASE(load_tbl_base,ROW=1)
new_sub_lbl_1=WIDGET_LABEL(new_sub_base, $
                              VALUE='New Color Table to be loaded:  ')
new_sub_lbl_2=WIDGET_LABEL(new_sub_base, $
                             VALUE=strformat('none chosen',25,/left))
   
pb_load_new=WIDGET_BUTTON(load_tbl_base, $
                    VALUE='Load new Color Table into chosen PAPCO Sub-Table', $
                            UVALUE='pb_load_new')
WIDGET_CONTROL, pb_load_new, SENSITIVE=0
  
;--- finally, the Actionbuttons (help, cancel, done) are added to the ---------
;    editor window.
widgets=papco_panel_AddActionButtons(panel_base, Action, aPlotInfo)
additionalWData=create_struct(widgets, additionalWData)  
  
;--- now, create the structure that keeps the panel-window data. You ----------
;    always need to specify the help-file, and your structure must
;    always contain the 'additionalWData'.
thisWidgetsData={helpfile:'papco_edit_batch.help',$
                 panel_base:panel_base, $
                 pb_load_new:pb_load_new, $
                 new_sub_lbl_2:new_sub_lbl_2, $
                 curr_sub_lbl_2:curr_sub_lbl_2, $
                 idl_name_list:idl_name_list, $
                 papco_name_list:papco_name_list, $
                 idl_tbl:0, $
                 papco_tbl:0, papco_tbl_idx:papco_tbl_idx}
editwidgetData=papco_panel_CreateWidgetData(thisWidgetsData, additionalWData)
   
;--- realize the window -------------------------------------------------------
papco_Panel_Realize, panel_base, editwidgetData

; As this is a function that will return all changes made by the
; user, the xmanager has to be called with the keyword MODAL. If we
; wouldn't specify /MODAL, no changes would be reportet but the 
; data contained in aPlotInfo would be returned.
xmanager, 'papco_subtable_editor', panel_base
  
END 

;******************************************************************************
;* PROCEDURE:
;*      PROpapco_subtable_editor_event
;*
;* DESCRIPTION:
;*	Event handler for Widget to interactively modify PAPCO color sub-tables
;*
;* INPUTS:
;*      
;*
;* KEYWORDS:
;*      
;*
;* OUTPUT:
;*      
;*
;* CALLING SEQUENCE:
;*	
;*
;* MODIFICATION HISTORY:
;*     August 1999, written by Reiner Friedel
;******************************************************************************
PRO papco_subtable_editor_event, event
  
COMMON edit_color_data, editwidgetData
COMMON color_tbl_names, idl_color_tbl_names, papco_color_tbl_names
COMMON papco_color
COMMON papco_color_names  
COMMON colors, r_orig,g_orig,b_orig,r_curr,g_curr,b_curr
  
WIDGET_CONTROL,GET_UVALUE=uval, event.id
  
IF strleft(uval, 9) EQ 'spb_color' THEN BEGIN 
    editwidgetData.channel=fix(strfrom(uval, 9))
    papco_subtable_editor_refresh, /SUB_TBL
ENDIF 
   
CASE uval OF 
    
    'idl_name_list': begin
        editwidgetData.idl_tbl=event.VALUE
        editwidgetData.papco_tbl=-1
        WIDGET_CONTROL, editwidgetData.papco_name_list, set_button=0
        papco_subtable_editor_refresh, /NEW_IDL_TBL
    END 
    
    'papco_name_list': begin
        editwidgetData.papco_tbl=event.VALUE
        editwidgetData.idl_tbl=-1
        WIDGET_CONTROL, editwidgetData.idl_name_list, set_button=0
        papco_subtable_editor_refresh, /NEW_PAPCO_TBL
    END     
    
    'pb_load_new': BEGIN
        c_index=editwidgetData.channel
        IF editwidgetData.papco_tbl ne -1 then BEGIN
            new_index=editwidgetData.papco_tbl_idx(editwidgetData.papco_tbl)
            name=papco_color_tbl_names(editwidgetData.papco_tbl)
            tbl_path=papco_getenv('PAPCO_PATH')
            file_table=tbl_path+'papco.tbl'
            message,'Loading PAPCO color table-> '+name+ $
              '-> # '+varprt(editwidgetData.channel), /cont
            LOADCT, file=file_table, new_index, /silent
        endif else begin
            new_index=editwidgetData.idl_tbl
            name=idl_color_tbl_names(new_index)
            message,'Loading IDL color table-> '+name+ $
              '-> # '+varprt(editwidgetData.channel),/cont
            LOADCT, new_index, /silent
        ENDELSE 
      
        color_bar_names(c_index)=name
        c_idx=papco_get_Colorindices(c_index)
        nc=c_idx(1)-c_idx(0)+1
      
        ; fold exisiting color table into this limited range
        r_subset=congrid(r_curr ,nc,/interp)
        r_papco(c_idx(0):c_idx(1))=r_subset

        g_subset=congrid(g_curr ,nc,/interp)
        g_papco(c_idx(0):c_idx(1))=g_subset

        b_subset=congrid(b_curr ,nc,/interp)
        b_papco(c_idx(0):c_idx(1))=b_subset
            
        ; load the new color table
        TVLCT,r_papco,g_papco,b_papco     
        papco_panel_Refresh, editwidgetData, /COLBAR_STYLE
      
    END 
      
    ELSE: editwidgetData=papco_panel_Event(event, editwidgetData)  
    
ENDCASE

END 
