;*****************************************************************************
; This file is part of the PAPCO software package. 
;
; PAPCO is a free IDL package to combine data plots written and
; maintained by A. Keese and R. Friedel.
;                                                           
;    For more information, check the papco home page at     
;    http://leadbelly/ccr/software/papco/papco.html       
;    for online Manual and downloadble latest version.      
;                                                           
; Comments and questions can be directed to friedel@lanl.gov  
;  
; You are free to modify and distribute this file. However, and
; changes not communicated to R. Friedel will not become part of the
; next release of PAPCO.
;*****************************************************************************
;+
; NAME:
;     papco_version
;
; PURPOSE:
;     This function returns a string containing the current version of PAPCO.
;     It is used to label the main-window and is included in the first
;     line of papco-save-files. Date MUST be of format "dd mmm yyyy"
;     and MUST come at end of string.
;
; CATEGORY:
;     Documentation
;
; CALLING SEQUENCE:
;     Result = papco_version()
;
; INPUTS:
;     none
;
; KEYWORD PARAMETERS:
;     INFO:   Calls doc_library to display this header documentation.
;             1: print to terminal, 2: print to default printer
;
; OUTPUTS:
;     This function returns a string of the PAPCO version information.
;
; MODIFICATION HISTORY:
;     Written by:  Reiner Friedel, May 1998
;     Modified:    Each time a new version is released
;-
;*****************************************************************************
FUNCTION papco_version, INFO = INFO

IF keyword_set(INFO) THEN BEGIN
    IF info EQ 2 THEN print = 1 ELSE print = 0
    doc_library, 'papco_version', print = print
    return, ''
ENDIF
  
ver = 'papco - Panel Plot Composer - version 10.6, 20 Nov 2003'
ver_str = '---'+strformat(ver, 64, /center)+'---'
   
return, ver_str
 
END
