;******************************************************************************
;* PROCEDURE:    
;* 	polar_createOrbitInfo
;* 
;* DESCRIPTION:  
;*	for all POLAR-ephemeris-files in the directory POLAREPHMPATH,
;*	orbit-infos are created and written to the file  
;*      $POLAR_WIDGETS/orbits.info 
;*
;* INPUTS:       
;*	none
;* 
;* OUTPUT:	 
;*	none
;*
;* CALLING SEQUENCE:
;*	polar_createOrbitInfo
;* 
;* MODIFICATION HISTORY:       
;*     october 1996, written by R. Friedel 
;******************************************************************************
PRO polar_createorbitinfo, GETRAD=GETRAD, HAVERAD=HAVERAD

COMMON polar_neweph, input_header, input_data 
COMMON time, xut1,xut2
COMMON rads, polar_rad

if keyword_set(HAVERAD) then goto, findapogee

; search for the POLAR-data-files ?
message, 'Compiling list of all POLAR (new) ephemeris files...',/cont
polar_path=papco_getenv('POLAR_EPH_DATA')

spawn, 'find '+polar_path+' -name "PO_EPH_????????.DAT" -print', allPOLARFiles
c0 =  n_elements(allPOLARFiles)
save = 1

message, '...found '+varprt(c0) + ' ephemeris-files',/cont
start_idx=0  &  total=0
dummy={POLAR_RAD,  tai:0.0d, radius :0.0}
  
if keyword_set(GETRAD) then begin ;get file of exisiting rads
    fln = polar_path+'*polar_rad.dat'
    result=findfile(fln, count=n)
    if n ne 0 then BEGIN
        message, 'Restoring '+result(n-1), /cont
        restore, result(n-1)
        total = n_elements(polar_rad)
        papco_sepdir, result(n-1), dd, ff, ee
        last_date = strmid(ff, 0, 8)
        pos = strpos(allPOLARFiles, last_date)
        idx = where(pos NE -1, c)
        if c ne 0 then start_idx=idx(0)+1 else $
            message, 'Cannot find start date, stuck..'
        polar_rad=[polar_rad,replicate(dummy,(c0-start_idx+1)*290)]
        IF c0 EQ start_idx THEN save = 0
    endif else begin
      message,"Can't find polar_rad file, making from scratch",/cont
      polar_rad=replicate(dummy,c*290)
    endelse
endif else polar_rad=replicate(dummy,c*290)

; POLAR ephemeris files are kept as files per day. To get a list of times
; of start orbit/ end orbit we need to loop through all ephemeris files
; and construct an array of times and radius. Maxima of radius are then
; apogee times, minima perigee times.

for i=start_idx, c0-1 do begin

     print,allPOLARFiles(i), ', ', varprt(i+1),'  of ', varprt(c0)
     datestr=strmid(allPOLARFiles(i),strlen(allPOLARFiles(i))-12,8)
     r_polar_new_eph_oneday, datestr, verbose=0
     
     ndat=n_elements(input_data)/5
     polar_eph=congrid(input_data,ndat)  ;reduce data resolution to 5 min
      
     polar_rad(total:total+ndat-1).tai=polar_eph.tai
      
     gsm=polar_eph.GSM_XYZ
     rad=fltarr(n_elements(polar_eph))
     ddd=float(sqrt(gsm(0,*)^2+gsm(1,*)^2+gsm(2,*)^2))
     rad(*)=ddd(0,*)
     polar_rad(total:total+ndat-1).radius=rad

     total=total+ndat

endfor
polar_rad=polar_rad(0:total)
   
;save polar_rad for future expansion!
IF save THEN BEGIN
    message, 'Saving '+polar_path+datestr+'polar_rad.dat'
    save, filename=polar_path+datestr+'polar_rad.dat', polar_rad
ENDIF

findapogee:
   
total=n_elements(polar_rad)

; loop through radius and find where the maxima are: apogees
message, 'Finding Apogees...', /cont
orbits=lonarr(6000,2) & orbit=0
FOR i=1l,total-2l DO BEGIN 
    IF (polar_rad(i-1).radius le polar_rad(i).radius) AND $
       (polar_rad(i).radius ge polar_rad(i+1).radius) THEN BEGIN
        orbit=orbit+1
        orbits(orbit,0)=orbit
        orbits(orbit,1)=i
    ENDIF  
ENDFOR  
orbits=orbits(0:orbit,*)
   
print, '...there are', orbit, ' orbits'
tmp=papco_getOrbitInfoStruct()	    ;create a POLAR_ORBIT_INFO-structure
orbitInfo=replicate(tmp, orbit)     ;and create an array of those
   
for i=0, orbit-1 do BEGIN

    orbitindex=orbits(i,1)
     
    ap_time=polar_rad(orbitindex).tai
    r = TAI2UTC(ap_time, /external)
    r_doy =  UTC2DOY(r)  

    print, i, orbitindex, r.year, r_doy, r.hour, r.minute

    orbitInfo(i).number=i		   ; save the data in 
    orbitInfo(i).day = r_doy	   ; the orbitInfo-structure
    orbitInfo(i).year=r.year
    orbitInfo(i).xut1=ap_time mod 86400.0 
    orbitInfo(i).xut2=(ap_time mod 86400.0) + 63120l
    orbitInfo(i).xdata=0
    orbitInfo(i).ydata=0
 
ENDFOR

; write the orbits.info-file
result=papco_writeOrbitInfo('POLAR', orbitInfo)
IF result EQ 'OK' THEN $
    message, 'OrbitInfo successfully created.', /cont $
ELSE $
    print, result
RETURN
   
END                            ; (polar_createOrbitInfo)
