#!/usr/local/bin/perl.5 -w

#use strict;

BEGIN { unshift @INC,'/usr/local/share/PerlCDF27/blib/arch',
                     '/usr/local/share/PerlCDF27/blib/lib'; }
use CDF;

#main
$maxRecZ=-1;
$showvars = 0;
$inputFile = "cdfplot.input";
$askvars = 0;
$deletepro = 1;
$deletegif = 0;
$quickcdf = 0;
$quickdir = 0;
$discreteid = 0;
$create = 0;
$arg = 0;
while ($arg <= $#ARGV) {
   $_ = $ARGV[$arg];
#   print "arg:$arg $_\n";
   if(/-showvars/) { $showvars=1; }
   if(/-askvars/) { $askvars=1; }
   if(/-create/) { $create=1; }
   if(/-nodelete/) { $deletepro=0; }
   if(/-deletegif/) { $deletegif=1; }
   if(/-infile/) {
      $arg++;
      $inputFile = $ARGV[$arg];
   }
   if(/-discrete/) {
      $arg++;
      push(@discrete,$ARGV[$arg]);
      $discreteid = 1;
   }
   if(/-quickcdf/) { 
       $quickcdf=1; 
       $arg++;
       push(@cdfs,$ARGV[$arg]);
   }
   if(/-quickdir/) { 
       $quickdir=1; 
       $arg++;
       $dirName = $ARGV[$arg];
   }
   if(/-gifdir/) { 
       $arg++;
       $_ = $ARGV[$arg];
       if(rindex($_,"/") == length($_)-1) {
	   $final = $_;
       } else {
	   $final = $_."/";
       }
       push(@gifdir, $final);
   }
   $arg++;
}
#print "quickcdf:$quickcdf\n";
#print "quickdir:$quickdir\n";
#print "inputFile:$inputFile\n";
if($quickcdf == 1) {
    openCDFs (@cdfs);
    @vars = getVariablesCDF();
    if($showvars) {
	showVars(@vars);
	exit;
    }
    @timespan=getTimeSpanCDF(@cdfs);
    if($discreteid == 0) {push(@discrete,"cdfplot");}
    if($#gifdir == -1) { push(@gifdir,"./"); }
} elsif($quickdir == 1) {
    @cdfs = getCDFsDIRquick($dirName);
    openCDFs (@cdfs);
    @vars = getVariablesCDF();
    if($showvars) {
	showVars(@vars);
	exit;
    }
    @timespan=getTimeSpanCDF(@cdfs);
    if($discreteid == 0) {push(@discrete,"cdfplot");}
    if($#gifdir == -1) { push(@gifdir,"./"); }
} else {
    if(!open(IN,$inputFile)) { 
	my $error_mes = sprintf("Can't open cdfplot input file, $inputFile");
	print $error_mes,"\n";
	exit;		       
    }
    while(<IN>) {
	chop $_;
	push(@input,$_);
    }
    close(IN);
    @cdfs = getCDFsDIR(@input);
    if($#cdfs == -1) {
	@cdfs = getCDFs(@input);
    }
    if($#cdfs == -1) { 
	printf("No CDFs found, exiting...\n");
	exit;
    }
    
    openCDFs (@cdfs);
    if($showvars) {
	@vars = getVariablesCDF();
	showVars(@vars);
	exit;
    }
    @vars = getVariables(@input);
    if($askvars ) {
	if($#vars != -1) {
	    print "You have asked to be prompted for variables,\n";
	    print "but you have entered variables in your input file, $inputFile\n";
	    do {
		print "Do you still wish to be prompted for variables (y/n)";
		chop ($answer = <STDIN>);
		($answer = $answer) =~ tr/A-Z/a-z/;
	    } while ($answer !~ /^[yn]$/);
	    $yn = $answer;
	    if($yn eq "y") {
		splice(@vars,0, $#vars+1);
		@vars = getVariablesCDF();
	    } else {
		$askvars = 0;
	    }
	} else {
	    @vars = getVariablesCDF();
	}
    } elsif($#vars == -1) {
	@vars = getVariablesCDF();
    }    
    if($#vars == -1) {
	print "No variables were found, exiting...\n";
	exit;
    }
    @master = getMaster(@input);
    @timespan = getTimeSpan(@input);
    if($#timespan == -1) {
	@timespan=getTimeSpanCDF(@cdfs);
    }
	
    if($discreteid == 0) {@discrete = getDiscrete(@input);}
    if($#gifdir == -1) { @gifdir = getGIFDIR(@input); }
}

if($create == 1) {
    createInputFile ();
    exit;
}
if (!defined $source) {			
#    print "SOURCE is not DEFINED \n";
    $source = getLogicalsource();
}
$gifFileName = getGIFfilename ();
$outFileName = sprintf("%s.pro",$discrete[0]);
&createAfile($outFileName);
print OUT "!quiet=1\n";
print OUT "\@compile_cdaweb\n";
print OUT "start = \'$timespan[0]\'\n";
print OUT "stop  = \'$timespan[1]\'\n";
if($#master != -1) {
    print OUT "a=strarr(",$#cdfs+2,")\n";
    print OUT "a(0) = \'$master[0]\'\n";
    $offset = 1;
} else {
    print OUT "a=strarr(",$#cdfs+1,")\n";
    $offset = 0;
}

for ($i = 0; $i <= $#cdfs; $i++)  {
    print OUT "a(",$i+$offset,") = \'$cdfs[$i]\'\n";
}
print OUT "buf1 = read_myCDF( [ \$\n";
$cnt = 0;
for ($i = 0; $i <= $#vars; $i++)  {
    $cnt++;
    if($cnt > 1) {
	print OUT ",\$\n";
    }
    print OUT "           \'$vars[$i]\'";
}
print OUT "],\$\n";
print OUT "            a, /NODATASTRUCT, TSTART=start, TSTOP=stop)\n";
print OUT "s = plotmaster(buf1, /AUTO, /CDAWEB, TSTART=start, PID='$discrete[0]',TSTOP=stop, \$\n";
print OUT "/gif, OUTDIR='$gifdir[0]', /SMOOTH, /SLOW, /DEBUG, /NONOISE)\n";
print OUT "exit\n";
close(OUT);
$ENV{'IDL_STARTUP'} = "";
$cmd = "idl $outFileName";
system($cmd);
if($deletepro) {
    $cmd = "rm $outFileName";
    system($cmd);
}
$cmd = "xv $gifFileName";
#$cmd = "xv $gifdir[0]$source\_$discrete[0]_*.gif";
print "cmd $cmd\n";
system($cmd);
if($deletegif) {
    $cmd = "rm $gifFileName";
    system($cmd);
}
sub createInputFile {
    $outFileName = sprintf("%s.input",$discrete[0]);
    &createAfile($outFileName);
    print OUT "#INDIR\n";
    if ($quickdir == 1) { print OUT "$dirName\n"; }
    print OUT "#INCDFS\n";
    if ($quickcdf == 1) { 
	for ($i = 0; $i <= $#cdfs; $i++)  {
	    print OUT "$cdfs[$i]\n";
	}
    }
    print OUT "#MASTER\n";
    print OUT "#TIMESPAN\n";
    print OUT "$timespan[0]\n";
    print OUT "$timespan[1]\n";
    print OUT "#VARIABLES\n";
    for ($i = 0; $i <= $#vars; $i++)  {
	print OUT "$vars[$i]\n";
    }
    print OUT "#DISCRETE\n";
    print OUT "$discrete[0]\n";
    print OUT "#GIFDIR\n";
    print OUT "#END\n";
    close (OUT);
}

sub getTimeSpanCDF {
    
    $EpochvarNum = getEpochVarNum();
    $status = CDF::CDFlib (SELECT_, CDF_, $CDFids[0],
			   GET_,  CDF_NUMrVARS_, \$numRvars,
			          CDF_NUMzVARS_, \$numZvars,
			   NULL_);
    statusCheck( $status) if ($status < CDF_OK) ;  
    if ($numRvars > 0) {
	$status = CDF::CDFlib (SELECT_, CDF_, $CDFids[0], rVAR_, $EpochvarNum,
			       rVARs_RECNUMBER_, 0,
			       GET_, rVAR_DATA_, \$start,
			       NULL_);
	statusCheck( $status) if ($status < CDF_OK) ;  
    } else {
	$status = CDF::CDFlib (SELECT_,  CDF_, $CDFids[0], zVAR_, $EpochvarNum,
			       zVAR_RECNUMBER_, 0,
			       GET_, zVAR_DATA_, \$start,
			       NULL_);
	statusCheck( $status) if ($status < CDF_OK) ;  
    }

    statusCheck( $status) if ($status < CDF_OK) ;  
    $status = CDF::CDFlib (SELECT_, CDF_, $CDFids[1],
			   GET_,  rVARs_MAXREC_, \$maxRecR,
			          zVARs_MAXREC_, \$maxRecZ,
			   NULL_);
    statusCheck( $status) if ($status < CDF_OK) ;  
    if ($numRvars > 0) {
      $status = CDF::CDFlib (SELECT_, CDF_, $CDFids[1], rVAR_, $EpochvarNum,
			              rVARs_RECNUMBER_, $maxRecR,
			        GET_, rVAR_DATA_, \$stop,
			     NULL_);
      statusCheck( $status) if ($status < CDF_OK) ;  
  } else {
      $status = CDF::CDFlib (SELECT_, CDF_, $CDFids[1], zVAR_, $EpochvarNum,
			              zVAR_RECNUMBER_, $maxRecZ,
			        GET_, zVAR_DATA_, \$stop,
			     NULL_);
      statusCheck( $status) if ($status < CDF_OK) ;  
  }

# Start Time

  CDF::EPOCHbreakdown ($start, $yr, $mon, $day, $hr, $min, $sec, $msec);
    if ($create == 0) {
	$t = sprintf("%04d/%02d/%02d %02d:%02d:%02d",$yr, $mon, $day, $hr, $min, $sec);
    } else {
# save off a alternate timespan in case the -create option was specified
	$t = sprintf("%04d%02d%02d%02d%02d%02d",$yr, $mon, $day, $hr, $min, $sec);
    }
  push(@timespan,$t);

# Stop Time

  CDF::EPOCHbreakdown ($stop, $yr, $mon, $day, $hr, $min, $sec, $msec);
    if ($create == 0) {
	$t = sprintf("%04d/%02d/%02d %02d:%02d:%02d",$yr, $mon, $day, $hr, $min, $sec);
    } else {
	$t = sprintf("%04d%02d%02d%02d%02d%02d",$yr, $mon, $day, $hr, $min, $sec);
    }
  push(@timespan,$t);
  return @timespan;
}
sub getLogicalsource {
  $status = CDF::CDFlib(SELECT_, CDF_, $CDFids[0],
			ATTR_NAME_, "Logical_source", gENTRY_, 0,
		  GET_, gENTRY_DATA_, \$source,
		  NULL_);
#  statusCheck( $status) if ($status < CDF_OK) ; 
  if($status == CDF_OK) {
      $source =~ tr/a-z/A-Z/;
      return $source;
  }

#  if($status == NO_SUCH_ATTR) { return ""; }
#  if($status <= CDF_WARN) { return ""; }
# 
# Didn't find Logical_source, look for Logical_file_id
#

  $status = CDF::CDFlib(SELECT_, CDF_, $CDFids[0],
			ATTR_NAME_, "Logical_file_id", gENTRY_, 0,
		  GET_, gENTRY_DATA_, \$lfile_id,
		  NULL_);
#  statusCheck( $status) if ($status < CDF_OK) ; 


  if($status == CDF_OK) {
#
# Only take the first 9 characters
#
      $len = 9;
      if(length($lfile_id) < 9) { $len = length($lfile_id); }
      $source = substr($lfile_id, 0, $len);
      $source =~ tr/a-z/A-Z/;
      return $source;
  }
  return "";
}


sub getAttrNum {
    my ($inattrName) = @_;
    $status = CDF::CDFlib (SELECT_, CDF_, $CDFids[0],
			   GET_, CDF_NUMATTRS_, \$numAttrs, NULL_);
    for ($attr_num = 0; $attr_num < $numAttrs; $attr_num++)  {
	$status = CDF::CDFlib(SELECT_,  CDF_, $CDFids[0], ATTR_, $attr_num,  
		      GET_, ATTR_NAME_,   \$attrName, 
			    
			      NULL_);
	if($attrName eq $inattrName) { return $attr_num }
    }
    return -1;
}
sub getEpochVarNum {
    $status = CDF::CDFlib (SELECT_, CDF_, $CDFids[0],
			   GET_,  CDF_NUMrVARS_, \$numRvars,
			          CDF_NUMzVARS_, \$numZvars,
			   NULL_);
    statusCheck( $status) if ($status < CDF_OK) ;  
    if ($numZvars > 0) {
	for ($var_num = 0; $var_num < $numZvars; $var_num++)  {
	    $status = CDF::CDFlib(SELECT_, CDF_, $CDFids[0],
				  zVAR_, $var_num, 
				  GET_,    zVAR_DATATYPE_, \$varDataType,
				  NULL_);
	    statusCheck( $status) if ($status < CDF_OK) ;  
	    if($varDataType == CDF_EPOCH) {
		$EpochvarNum = $var_num;
		push(@CDFinfo,$var_num);
		return $EpochvarNum;
	    }
	}
    } else {
	for ($var_num = 0; $var_num < $numRvars; $var_num++)  {
	    $status = CDF::CDFlib(SELECT_, CDF_, $CDFids[0], rVAR_, $var_num, 
				  GET_,    rVAR_DATATYPE_, \$varDataType,
				  NULL_);
	    statusCheck( $status) if ($status < CDF_OK) ;  

	    if($varDataType == CDF_EPOCH) {
		$EpochvarNum = $var_num;
		push(@CDFinfo,$var_num);
		return $EpochvarNum;
	    }
	}
    }
    print "No EPOCH varible in CDF, exiting...\n";
    exit;
}
sub getVariablesCDF {
    $status = CDF::CDFlib (SELECT_, CDF_, $CDFids[0],
			   GET_,  CDF_NUMrVARS_, \$numRvars,
			          CDF_NUMzVARS_, \$numZvars,
			   NULL_);

    statusCheck( $status) if ($status < CDF_OK) ;  
    if ($numZvars > 0) {
	$yn = "y";
	$var_num = 0;
	while ($var_num < $numZvars && $yn ne "q")  {
	    $status = CDF::CDFlib(SELECT_, CDF_, $CDFids[0], 
				  zVAR_, $var_num, 
				  GET_, zVAR_NAME_,   \$varName, 
				  NULL_);
	    statusCheck( $status) if ($status < CDF_OK) ;  
	    $status = CDF::CDFlib(SELECT_,  CDF_, $CDFids[0], 
				  ATTR_NAME_, "VAR_TYPE",
				  CONFIRM_, zENTRY_EXISTANCE_, $var_num, 
				  NULL_);
            if($status == CDF_OK) {
		$status = CDF::CDFlib(SELECT_,  CDF_, $CDFids[0], 
				  ATTR_NAME_, "VAR_TYPE",
				  zENTRY_, $var_num,  
				  GET_, zENTRY_DATA_, \$attrValue, 
				  NULL_);
		statusCheck( $status) if ($status < CDF_OK) ;  
		if($attrValue eq "data") {  
		    $yn = "y";
		    if ($askvars == 1) { $yn = includeVar($varName); }
		    if($yn eq "y") { push(@vars,$varName); } 
		}
	    }
	    $var_num++;
	}
    } else {
	$yn = "y";
	$var_num = 0;
	while ($var_num < $numRvars && $yn ne "q")  {
	    $status = CDF::CDFlib(SELECT_, CDF_, $CDFids[0], rVAR_, $var_num, 
				  GET_, rVAR_NAME_,   \$varName, 
				  NULL_);
	    statusCheck( $status) if ($status < CDF_OK) ;  
	    $status = CDF::CDFlib(SELECT_,  CDF_, $CDFids[0], 
				  ATTR_NAME_, "VAR_TYPE",
				  CONFIRM_, rENTRY_EXISTANCE_, $var_num, 
				  NULL_);
            if($status == CDF_OK) {
		$status = CDF::CDFlib(SELECT_,  CDF_, $CDFids[0], 
				  ATTR_NAME_, "VAR_TYPE",
				  rENTRY_, $var_num,  
				  GET_, rENTRY_DATA_, \$attrValue, 
				  NULL_);
		statusCheck( $status) if ($status < CDF_OK) ;  
		if($status == CDF_OK) {
		    if($attrValue eq "data") {  
			$yn = "y";
			if ($askvars == 1) { $yn = includeVar($varName); }
			if($yn eq "y") { push(@vars,$varName); } 
		    }
		}
	    }
	    $var_num++;
	}
    }

    $source = getLogicalsource();
    return @vars;
}

sub open_CDF {
    my ($CDF_name) = @_;
    $status = CDF::CDFlib (OPEN_, CDF_, $CDF_name , \$id,
			   NULL_);
    quitCDF("open_CDF", $status) if ($status < CDF_OK) ;  
    $_ = $id;
    return $id;
}
sub openCDFs {
    ($cdfs) = @_;
#    print "open_CDFs $cdfs[0]\n";

    $id = open_CDF ($cdfs[0]);
    push(@CDFids,$id);
    if ($#cdfs > 0) {
	$id = open_CDF ($cdfs[$#cdfs]);
    }
    push(@CDFids,$id);
    return @CDFids;
}
sub close_CDF {
    $status = CDF::CDFlib (CLOSE_, CDF_,
			   NULL_);
    statusCheck ($status) if ($status < CDF_OK) ;

}
sub getDiscrete {

    my ($input) = @_;
    my $i;
    my $found = 0;
    my $cnt = 0;
    my @discrete;
    for ($i = 0; $i <= $#input; $i++)  {
	$_ = $input[$i];
	if($found == 1 && /^#/) { 
	   if($#discrete > 0) {
	       print "Error: More than 1 discrete\n";
	       exit;
	   } elsif ($#discrete != 0) {
	       push(@discrete,"cdfplot");
	   }
	   return @discrete; 
        } 
	if(/^#DISCRETE/) {
	   if($found == 0) {
	       $found = 1;
	   } else {
	       return;
	   }
        } elsif($found == 1) {
	   push(@discrete,$_);
        }
    }
    if($#discrete == -1) {
	push(@discrete,"cdfplot");
    }
    return @discrete;
}
sub getGIFDIR {

    my ($input) = @_;
    my $i;
    my $found = 0;
    my $cnt = 0;
    my @gifdir;
    for ($i = 0; $i <= $#input; $i++)  {
	$_ = $input[$i];
	if($found == 1 && /^#/) { 
	   if($#gifdir > 0) {
	       print "Error: More than 1 GIFDIR, exiting...\n";
	       exit;
	   }
	   if($#gifdir == -1) { push(@gifdir,"./"); }
	   return @gifdir; 
        } 
	if(/^#GIFDIR/) {
	   if($found == 0) {
	       $found = 1;
	   } else {
	       if($#gifdir == -1) { push(@gifdir,"./"); }
	       return @gifdir;
	   }
        } elsif($found == 1) {
	    if(rindex($_,"/") == length($_)-1) {
		$final = $_;
	    } else {
                $final = $_."/";
	    }
	   push(@gifdir,$final);
        }
    }
    if($#gifdir == -1) { push(@gifdir,"./"); }
    return @gifdir;
}
sub getMaster {

    my ($input) = @_;
    my $i;
    my $found = 0;
    my $cnt = 0;
    my @master;
    for ($i = 0; $i <= $#input; $i++)  {
	$_ = $input[$i];
	if($found == 1 && /^#/) { 
	   if($#master > 0) {
	       print "Error: More than 1 master\n";
	       exit;
	   }
	   return @master; 
        } 
	if(/^#MASTER/) {
	   if($found == 0) {
	       $found = 1;
	   } else {
	       return;
	   }
        } elsif($found == 1) {
	   push(@master,$_);
        }
    }
}
sub getCDFs {

    my ($input) = @_;
    my $i;
    my $found = 0;
    my @cdfs;
    for ($i = 0; $i <= $#input; $i++)  {
	$_ = $input[$i];
	if($found == 1 && /^#/) { return @cdfs; }
	if(/^#INCDFS/) {
	   if($found == 0) {
	       $found = 1;
	   } else {
	       return;
	   }
       } elsif($found == 1) {
	   push(@cdfs,$_);
       }
    }
}
sub getCDFsDIRquick {
    ($dirName) = @_;
    opendir(DIR,$dirName);
    local(@all_files) = sort grep(!/^\./,readdir(DIR));	
    closedir(DIR);
    $cnt = $#all_files+1;
    if($#all_files > 20) {
	$yn = "y";
	do {
	    print "You have selected a directory with ",$#all_files+1," CDFs\n";
	    print "** When using -quickdir option program expects only CDFs\n";
            print "of one type to be in this directory, no other files\n";
	    print "Do you wish to proceed or SAMPLE a portion of the the CDFs (y/n/S)";
	    chop ($answer = <STDIN>);
	    ($answer = $answer) =~ tr/A-Z/a-z/;
	} while ($answer !~ /^[yns]$/);
	$yn = $answer;
	if($yn eq "n") { 
	    exit; 
	} elsif ($yn eq "s") {
	    print "Number of CDFs you would like to SAMPLE==>";
	    chop ($sample = <STDIN>);
	    $cnt = $sample;
	} else {
	    $cnt = $#all_files+1;
	}
    }
	
    for ($i = 0; $i < $cnt; $i++)  {
	$newname = sprintf("%s/%s",$dirName,$all_files[$i]);
	push(@cdfs,$newname);
    }
    return @cdfs; 
}
sub getCDFsDIR {

    my ($input) = @_;
    my $i;
    my $found = 0;
    my @dir;
    for ($i = 0; $i <= $#input; $i++)  {
	$_ = $input[$i];
	if($found == 1 && /^#/) { 
	   if ($#dir == 0) { 
	       opendir(DIR,$dir[0]);
	       local(@all_files) = sort grep(!/^\./,readdir(DIR));	
	       closedir(DIR);
	       $cnt = $#all_files+1;
	       if($#all_files > 20) {
		   $yn = "y";
		   do {
		       print "You have selected a directory with ",$#all_files+1," CDFs\n";
		       print "Do you wish to proceed or SAMPLE a portion of the the CDFs (y/n/S)";
		       chop ($answer = <STDIN>);
		       ($answer = $answer) =~ tr/A-Z/a-z/;
		   } while ($answer !~ /^[yns]$/);
		   $yn = $answer;
		   if($yn eq "n") { 
		       exit; 
		   } elsif ($yn eq "s") {
		       print "Number of files you would like to SAMPLE==>";
		       chop ($sample = <STDIN>);
		       $cnt = $sample;
		   } else {
		       $cnt = $#all_files+1;
		   }
	       }
	       
	       for ($i = 0; $i < $cnt; $i++)  {
		   $newname = sprintf("%s/%s",$dir[0],$all_files[$i]);
		   push(@cdfs,$newname);
	       }
	       return @cdfs; 
	   } else {
	       return @cdfs; 
	   }
       }
	if(/^#INDIR/) {
	   if($found == 0) {
	       $found = 1;
	   } else {
	       return;
	   }
       } elsif($found == 1) {
	   push(@dir,$_);
       }
    }
}
sub getVariables {

    my ($input) = @_;
    my $i;
    my $found = 0;
    my @vars;
    for ($i = 0; $i <= $#input; $i++)  {
	$_ = $input[$i];
	if($found == 1 && /^#/) { return @vars; }
	if(/^#VAR/) {
	   if($found == 0) {
	       $found = 1;
	   } else {
	       return;
	   }
       } elsif($found == 1) {
	   push(@vars,$_);
       }
    }
}
sub list_cdfplot_output {

    my ($input) = @_;
    my $i;
    for ($i = 0; $i <= $#input; $i++)  {
	print $input[$i],"\n";
    }
}
sub createAfile {

    my ($file_name) = @_;
#    my $file_name = sprintf("%s.pro",$head);
    if(!open(OUT,">$file_name")) { 
	my $error_mes = sprintf("Can't open output, %s",$file_name);
	print $error_mes,"\n";
	exit;		       
    }
}
sub getTimeSpan {

    my ($input) = @_;
    my $i;
    my $found = 0;
    my @timespan;
    for ($i = 0; $i <= $#input; $i++)  {
	$_ = $input[$i];
	if($found == 1 && /^#/) { 
#	   if($#timespan != 1) {
#	       print "Error: Start and Stop time not found\n";
#	   }
	   return @timespan; 
        }
	if(/^#TIMESPAN/) {
	   if($found == 0) {
	       $found = 1;
	   } else {
	       return;
	   }
       } elsif($found == 1) {
	   my $t = sprintf("%s/%s/%s %s:%s:%s",substr($_,0,4),
			                       substr($_,4,2),
			                       substr($_,6,2),
			                       substr($_,8,2),
			                       substr($_,10,2),
        			               substr($_,12,2));

	   push(@timespan,$t);
       }
    }
}
sub showVars {
    my (@vars) = @_;
    for ($i = 0; $i <= $#vars; $i++)  {
	print "$vars[$i]\n";
    }
}
sub includeVar {
    ($varName) = @_;
    $yn = "y";
    do {
	print "Plot $varName (y/n/q)";
	chop ($answer = <STDIN>);
	($answer = $answer) =~ tr/A-Z/a-z/;
    } while ($answer !~ /^[ynq]$/);
    $yn = $answer;
    return $yn;

}

#############################################################################
# QuitCDF.
#############################################################################
sub quitCDF {
	my ($where, $status)=@_;

  if ($status < CDF_OK) {
    my $text;
    CDF::CDFlib (SELECT_, CDF_STATUS_, $status,
		   GET_, STATUS_TEXT_, \$text,
		   NULL_);
    print "$text($where)\n";
  }
  CDF::CDFlib (CLOSE_, CDF_,
	  NULL_);
  exit;
	
}#endsub QuitCDF

sub statusCheck {
    my ($status)=@_;

    if ($status < CDF_OK) {
	my $text;
        CDF::CDFlib (SELECT_, CDF_STATUS_, $status, GET_, STATUS_TEXT_, \$text,
                   NULL_);
	print $text;
    }

}

sub getGIFfilename {
    $gifFileName = sprintf("%s%s_%s_000.gif",$gifdir[0],$source,$discrete[0]);
    $changed = 0;
#    $gifFileName = "$gifdir[0]$source\_$discrete[0]_000.gif";
    $next = 2;

    while (-e $gifFileName) {
	$changed = 1;
	print "Gif file $gifFileName is already there, changing discrete id to $discrete[0]$next\n";
	$gifFileName = sprintf("%s%s_%s%s_000.gif",$gifdir[0],$source,$discrete[0],$next);
	$next++;
    }
    if ($changed) { 
	$discrete[0] = sprintf("%s%s",$discrete[0],$next-1); 
        sleep 2;
    }

    return $gifFileName;
}

