;$Author: friedel $
;$Date: 2004/02/26 16:13:45 $
;$Header: /data0/n/toaster/u/friedel/cvs/papco//papco/papco_lib/CDAWlib/project_subtitle.pro,v 1.2 2004/02/26 16:13:45 friedel Exp $
;$Locker:  $
;$Revision: 1.2 $
;+------------------------------------------------------------------------
; NAME: PROJECT_SUBTITLE
; PURPOSE: Examine the structure given by the input parameter, and return
;          a string to be used as a subtitle giving project information,
;          and write this string onto current plot.
; CALLING SEQUENCE:
;       project_subtitle,a,title
; INPUTS:
;       a = structure containing a variable from the type of structure
;           returned by the read_mycdf procedure.
; OUTPUTS:
;       title = the string written to the plot or gif.
; KEYWORD PARAMETERS:
;       IMAGE    = special processing for image-type displays
;       TIMETAG  = epoch value associated with a single image
; AUTHOR:
;       Richard Burley, NASA/GSFC/Code 632.0, Feb 22, 1996
;       burley@nssdca.gsfc.nasa.gov    (301)286-2864
; MODIFICATION HISTORY:
;       8/7/96  R.Burley    ; Add TIMETAG keyword
;     10/21/97  R.Baldwin   ; Add SSCWEB keyword 
;     01/29/98  R.Baldwin   ; Added TCOLOR keyword 
;     10/14/98  T. Kovalick ; Added the acknowledgements line.
;     05/16/01  T. Kovalick ; Added carriage return after ISTP line since
;			      it was running of the page.
;-------------------------------------------------------------------------
PRO project_subtitle, a, title, SSCWEB=SSCWEB, IMAGE=IMAGE, TIMETAG=TIMETAG,$
                      TCOLOR=TCOLOR
if keyword_set(TCOLOR) then TCOLOR=TCOLOR else TCOLOR=247  ; rtb added 1/98

; write the title (at the top of the page) to the gif file
if keyword_set(SSCWEB) then web_code='SSCWEB' else web_code='CDAWeb'
if (title ne '' and keyword_set(IMAGE)) then begin
  xyouts,!d.x_size/2,!d.y_size-!d.y_ch_size,title,/DEVICE,ALIGNMENT=0.5,$
     COLOR=TCOLOR
endif else xyouts,!d.x_size/2,!d.y_size-!d.y_ch_size,title,/DEVICE,ALIGNMENT=0.5

; Generate the subtitle
pi = ' ' & s='' & b = tagindex('PROJECT',tag_names(a))
if (b(0) ne -1) then begin
 if(n_elements(a.PROJECT) eq 1) then begin 
  pr = break_mystring(a.PROJECT,delimiter='>')
 endif else begin
  pr = break_mystring(a.PROJECT(0),delimiter='>')
 endelse
  if (pr(0) eq 'ISTP') then begin
    s = 'Key Parameter and Survey data (labels K0,K1,K2)'
    s = s + ' are preliminary browse data.' + '!C'
  endif ;ISTP case

;TJK add in code to get and display the PI and PI_AFFILIATION
    b = tagindex('PI_NAME',tag_names(a))
    if (b(0) ne -1) then begin
     if(n_elements(a.PI_NAME) eq 1) then pi = a.PI_NAME
    endif
    b = tagindex('PI_AFFILIATION',tag_names(a))
    if (b(0) ne -1) then begin
      if((n_elements(a.PI_AFFILIATION) eq 1) and (a.PI_AFFILIATION[0] ne "")) then $
         pi = pi + ' at '+ a.PI_AFFILIATION
    endif
    
    pi = 'Please acknowledge data provider, ' + pi + ' and '+ web_code +' when using these data.'
   
    s = s + ' Generated by '+ web_code + ' on ' + systime()
endif ; Global attribute Project is found

; Write the subtitle into the window
if (s ne '') then begin
  c = 1.0 ; initialize
  if ((!d.x_ch_size * strlen(s)) gt !d.x_size) then begin
    b = float(!d.x_ch_size * strlen(s)) / float(!d.x_size)
    c = 1.0 - (b/7.0)
  endif
  if (c ge 0.75) then begin
    if keyword_set(IMAGE) then begin
      if keyword_set(TIMETAG) then begin
        d = size(TIMETAG) ; determine if time is a range or single time
        if d(0) eq 0 then ts = 'Frame time: ' + decode_cdfepoch(TIMETAG) $
        else ts = 'Time Range: ' + decode_cdfepoch(TIMETAG(0)) + ' to ' + $
                  decode_cdfepoch(TIMETAG(1))
        xyouts,!d.x_size/2,23L,ts,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,COLOR=TCOLOR
        xyouts,!d.x_size/2,13L,pi,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,COLOR=TCOLOR
      endif
      xyouts,!d.x_size/2,3L,s,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,COLOR=TCOLOR
    endif else begin
      xyouts,!d.x_size/2,20L,pi,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c
      xyouts,!d.x_size/2,10L,s,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c
    endelse

  endif 

  if (c lt 0.75) then begin ;TJK added to handle label when
				       ;space is limited

    s = ''
    if (pr(0) eq 'ISTP') then begin
      s = 'Key Parameter and Survey data (labels K0,K1,K2) are '
      s = s + 'preliminary browse data.' + '!C'
    endif

    gen_date = ' Generated by '+ web_code + ' on ' + systime()

    if keyword_set(IMAGE) then begin
      if keyword_set(TIMETAG) then begin
        d = size(TIMETAG) ; determine if time is a range or single time
        if d(0) eq 0 then ts = 'Frame time: ' + decode_cdfepoch(TIMETAG) $
        else ts = 'Time Range: ' + decode_cdfepoch(TIMETAG(0)) + ' to ' + $
                  decode_cdfepoch(TIMETAG(1))
	ts = ts + '; ' + gen_date
        xyouts,!d.x_size/2,23L,ts,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,COLOR=TCOLOR
        xyouts,!d.x_size/2,13L,pi,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,COLOR=TCOLOR
      endif
      xyouts,!d.x_size/2,3L,s,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,COLOR=TCOLOR
    endif else begin
      xyouts,!d.x_size/2,20L,pi,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c
      xyouts,!d.x_size/2,10L,s,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c
    endelse

  endif

endif
end





