pro autorange,pnum,xarr,zarr,zmax,zmin,linlogbit, FULLRANGE=fullrange   
  
   pts=n_elements(zarr)          ; # of elements of the 2-d array
   zarr=double(zarr)
   
   if linlogbit eq 1 then begin  ; for logarithmic z-scaling
      index=where(zarr le 0.0d,nodat) ; elements that are less or equal to zero
      print,'% autorange: Total points: ',pts,',  Missing: ',nodat
      temp=FLOAT(zarr) ; temporary array mirroring the zarr
      if nodat ne 0 then begin  ; if there are elements <= 0 
         temp(index)=1e20       ; set those to the 1e20 value
         index2=index
      endif
      if nodat eq pts then begin  ; if all points are <= 0 
         zmax=0 & zmin=0         ; set zmax, zmin and return
         print,'% autorange: no valid data points in this panel'
         return
      endif
      zminactual=min(temp) ; zmin is the minimum of the temp array
      zmin=double(zminactual)
      
      IF NOT keyword_set(FULLRANGE) then begin ; exclude % of points
        nopoints=pts-nodat
        index=where(temp lt zmin,count) ; Calculate the zmin.
        while (count  lt (nopoints*0.05)) do begin ; zmin is such that 5% of
          ;print,count,zmin,format="(i8,'  ',e10.2)"
          index=where(temp lt zmin,count) ; the greater than zero
          zmin=zmin+zmin*0.05d                     ; points is less than zmin.
        endwhile                                   
        print,'% autorange: Min:',zminactual,'  New Min: ',zmin,$
          '  Below: ',count
        if (count ne 0) then zarr(index)=zmin      ; points less than zmin are
                                                   ; set equal to zmin
      endif                     ; exclude 10% of points
      
      if (nodat ne 0) then zarr(index2)=zmin/1000; points less or equal to zero
                                                 ; are set to zmin/1000
      zmin=zmin*0.99                             

      zmaxactual=max(zarr) ; zmax is the maximum of the zarr
      zmax=zmaxactual
      IF NOT keyword_set(FULLRANGE) then begin ; exclude 10% of points      
        index=where(zarr gt zmax,count)            ; Calculate the zmax.
        while (count  lt (nopoints*0.05)) do begin ; zamx is such that 5% of
          index=where(zarr gt zmax,count)          ; the greater than zero
          zmax=zmax-zmax*0.05                      ; points is >  than zmax
        endwhile
        print,'% autorange: Max: ',zmaxactual,'  New Max: ',zmax,$
          ',  Above: ',count
        if (count ne 0) then zarr(index)=zmax ; points greater than zmax are
                                              ; set equal to zmax
      endif                     ; exclude 10% of points  
      zmax=zmax*1.01
      
      if zmin ge zmax then begin
        zmin=zminactual
        zmax=zmaxactual
        print,'% autorange: Actual max, min used ',zmin,zmax
      endif  
      
   endif else begin  ; for linear z-scaling

      index=where(zarr eq 0,nodat) 
      print,'% autorange: Total points: ',pts,',  Missing: ',nodat
      temp=float(zarr)
      if nodat ne 0 then temp(index)=1e20
      if nodat eq pts then begin
         zmax=1 & zmin=-1
         print,'% autorange: no valid data points in this panel'
         return
      endif
      zmin=min(temp)
      index=where(zarr ne 0.0,dat) 
      if dat ne 0 then temp2=zarr(index) else temp2=zarr
      zmax=max(temp2)

      print,'% autorange: Actual Minimum value: ',zmin
      nopoints=pts-nodat
      index=where(temp lt zmin,count)
      while (count  lt (nopoints*0.05)) do begin
         index=where(temp lt zmin,count)
         zmin=zmin+abs(zmax-zmin)*0.01
      endwhile
      print,'% autorange: New Minimum: ',zmin,';  Points below range: ',count
      index1=where(temp gt zmin,count)

      print,'% autorange: Actual Maximum value: ',zmax
      index=where(temp2 gt zmax,count)
      while (count  lt (nopoints*0.05)) do begin
         index=where(temp2 gt zmax,count)
         zmax=zmax-abs(zmax-zmin)*0.01
      endwhile
      print,'% autorange: New Maximum: ',zmax,',  Points above range: ',count
      index2=where(temp lt zmax,count)

      index=[index1,index2]

      zmax=zmax+abs(zmax-zmin)*0.1
      zmin=zmin-abs(zmax-zmin)*0.1

   endelse

end

;------------------------------------------------------------------------------
pro autorange_lp,pnum,xarr,zarr,zmax,zmin,linlogbit
; does automatic scaling for arrays that areto be plotted as line plots:
; checks valid data ("0" mark non-valid data)
; sets limits to 5% above and below actual max and min
; inputs 	pnum 		panel number
;        	xarr 		x-axis array
;		zarr 	 	y or z-azis array
;		zmax 		retured maximum value of axis
;		zmin		returned minimum value of axis
;		linlogbit	0 for logarythmic 0 for linear axis

   pts=n_elements(zarr)

   if linlogbit eq 1 then begin

      index=where(zarr le 0.0,nodat) 
      print,'% autorange: Panel',pnum,'  Total points: ',pts,',  Missing: ',nodat
      temp=FLOAT(zarr)
      if nodat ne 0 then temp(index)=1e20
      if nodat eq pts then begin
         zmax=1 & zmin=-1
         print,'% autorange: no valid data points in this panel'
         return
      endif
      zmin=min(temp)
      print,'% autorange: Actual Minimum value: ',zmin
      nopoints=pts-nodat
      index=where(temp lt zmin,count)
      while (count  lt (nopoints*0.04)) do begin
         index=where(temp lt zmin,count)
         zmin=zmin+zmin*0.04
      endwhile
      print,'% autorange: New Minimum: ',zmin,$
        ';  Points below range: ',count

      if (count ne 0) then zarr(index)=zmin*1.001
      zmax=max(zarr)
      print,'% autorange: Actual Maximum value: ',zmax
      index=where(zarr gt zmax,count)
      while (count  lt (nopoints*0.04)) do begin
         index=where(zarr gt zmax,count)
         zmax=zmax-zmax*0.04
      endwhile
      print,'% autorange: New Maximum: ',zmax,$
        ',  Points above range: ',count
      if (count ne 0) then zarr(index)=zmax*0.999

   endif else begin

      index=where(zarr eq 0,nodat) 
      print,'% autorange: Panel',pnum,'  Total points: ',pts,',  Missing: ',nodat
      if nodat eq pts then begin
         zmax=1 & zmin=-1
         print,'% autorange: no valid data points in this panel'
         return
      endif
      temp=float(zarr)
      zmin=min(temp)
      index=where(zarr ne 0.0,dat) 
      if dat ne 0 then temp2=zarr(index) else temp2=zarr
      zmax=max(temp2)

      print,'% autorange: Actual Minimum value: ',zmin
      zmin=zmin-abs(zmax-zmin)*0.05
      print,'% autorange: New Minimum: ',zmin
      index1=where(temp gt zmin,count)

      print,'% autorange: Actual Maximum value: ',zmax
      zmax=zmax+abs(zmax-zmin)*0.05
      print,'% autorange: New Maximum: ',zmax

   endelse

end

pro setmaxmin,zarr,max,min

;set those data that are actually below the minimum to the minimum
   index=where((zarr lt min) and (zarr ne 0),points)
   if points ne 0 then zarr(index)=min
   print,'% autorange: points less than',min,'  :',points

;set those data points actually above the max to the max
   index=where(zarr gt max,points)
   if points ne 0 then zarr(index)=max*0.99
   print,'% autorange: points greater than',max,'  :',points

;check for no data (zeros) set those to min - on plot this will be background
   index=where(zarr le 0,points)
   if points ne 0 then zarr(index)=min*0.9
   print,'% autorange: bad data points  :',points

end
