;------------------------------------------------------------------------------
pro ylim,time,yray,yst,yen

  yen=max(yray,min=yst)
  yst=float((fix(yst)/10)*10-10)
  yen=float((fix(yen)/10)*10+10)

end

;------------------------------------------------------------------------------
pro ylim2,time,yray,yst,yen,  NODATA = NODATA

  IF keyword_set(NODATA) THEN BEGIN
    index = where(yray NE nodata,c)
    if c eq 0 then begin
      yst=1
      yen=2
      return
    endif
    yen=max(yray(index),min=yst)
  ENDIF ELSE yen=max(yray,min=yst)

  yrange=abs(yen-yst)
  yst=yst-yrange*0.1
  yen=yen+yrange*0.1

end

;------------------------------------------------------------------------------
; finds limits of data in logarythmic space
pro ylim3,time,yray,yst,yen

  index=where(yray gt 0,count)
  if count ne 0 then begin
     data=alog10(yray)
     yen=max(data,min=yst)
     yen=float(ceil(yen))
     yst=float(floor(yst))
     yen=10^yen
     yst=10^yst
  endif

end

;------------------------------------------------------------------------------
; finds limits of data in linear space
pro ylim4,time,yray,yst,yen, BAD_DATA=BAD_DATA
  
  yen=max(yray,min=yst)
  
  if keyword_set(BAD_DATA) then begin
    index=where(yray ne BAD_DATA,c)
    if c ne 0 then yen=max(yray(index),min=yst)
  endif
  
  range=yen-yst
  extend=range/10
  yst=floor(yst-extend)
  yen=ceil(yen+extend)

end

;******************************************************************************
; finds limits any 1D data array - used for automatic scaling the
;                                  y-axis
;******************************************************************************
pro papco_ylim,time,iny,yst,yen, LOG=LOG, BAD_DATA=BAD_DATA, EXTEND=EXTEND
  
  if keyword_set(LOG) then log=LOG else log=0
  
  ;take out bad data values before determining limits
  if keyword_set(BAD_DATA) then begin 
    index=where(iny ne BAD_DATA,c)
    if c ne 0 then yray=iny(index) else begin
      message,'No good y data values',/cont
      yst=1 & yen=2
      return
    endelse
  endif else yray=iny
  
  if log then begin             ;do scaling logarythmically
    ;make sure there are no negative values
    index=where(yray gt 0,c)
    if c ne 0 then yray=yray(index) else begin
      message,'No positive y data values',/cont
      yst=1 & yen=2
      return
    endelse     
    yen=max(yray,min=yst)
    if keyword_set(EXTEND) then begin
      data=alog10(yray)
      yen=max(data,min=yst)
      yen=float(ceil(yen))  &  yst=float(floor(yst))
      yen=10^yen            &  yst=10^yst
    endif
  endif else begin              ;do scaling linear
    yen=max(yray,min=yst)
    if keyword_set(EXTEND) then begin
      range=yen-yst
      extend=range*0.1
      yst=floor(yst-extend)
      yen=ceil(yen+extend)
    endif
  endelse

end

