;******************************************************************************
;Note: all time labeling routines return two lines, the first being
;the time of day, the second the date. Dates are only printed if they
;change from the previous tick mark.

;******************************************************************************
;mjdt_yyyymmmdd returns dates as mjdt_ddmmmyyyy, eg. 27Nov1987
function mjdt_ddmmmyyyy, axis, index, t

  COMMON shift_label, down
  COMMON mjdt, mjdt_start, mjdt_end
  COMMON PLOT_COMPOSER, widgetData

  down_str=''  &  for i=0,down-1 do down_str=down_str+'!C'

  mjdt_now = mjdt_start    &  mjdt_add=mjdt_now
  mjdt_add.mjd=t / 86400l  &  mjdt_add.t=t mod 86400l
  mjdt_now = addSubTime(mjdt_now,mjdt_add,/ADD)

  convert_t90_to_date,mjdt_now, yr, doy, hr, min, sec, mon, cmon, dom, /mjdt
  time_str=string(hr,min,format="(i2.2,':',i2.2)")
  date_str=string(dom,cmon,yr,format="(i2.2,a3,i4.4)")
  
  if widgetData.default_XLINES eq 1 then out_str=date_str ELSE $
    out_str = time_str+'!C'+date_str

  return,down_str+out_str

end

;******************************************************************************
;mjdt_hhmm returns dates as hh:mm, eg 16:40               
function mjdt_hhmm, axis, index, t

  COMMON shift_label, down
  COMMON mjdt, mjdt_start, mjdt_end
  COMMON olddate, olddate
  COMMON PLOT_COMPOSER, widgetData

  down_str=''  &  for i=0,down-1 do down_str=down_str+'!C'

  mjdt_now = mjdt_start    &  mjdt_now.t=0  & mjdt_add=mjdt_now
  mjdt_add.mjd=t / 86400l  &  mjdt_add.t=t mod 86400l
  mjdt_now = addSubTime(mjdt_now,mjdt_add,/ADD)

  convert_t90_to_date,mjdt_now, yr, doy, hr, min, sec, mon, cmon, dom, /mjdt
  time_str=string(hr,min,format="(i2.2,':',i2.2)")
  date_str=string(dom,cmon,yr,format="(i2.2,a3,i4.4)")
  
  out_str=time_str+'!C'+date_str 
  if index ne 0 then if olddate eq date_str then out_str=time_str
  olddate=date_str
  
  if widgetData.default_XLINES eq 1 then out_str=time_str
  
  return,down_str+out_str

END


;******************************************************************************
;mjdt_date_sec returns dates as hh:mm !C ss.mss 
function mjdt_date_sec, axis, index, t

  COMMON shift_label, down
  COMMON mjdt, mjdt_start, mjdt_end
  COMMON olddate, olddate
  COMMON PLOT_COMPOSER, widgetData

  down_str=''  &  for i=0,down-1 do down_str=down_str+'!C'

  mjdt_now = mjdt_start    &  mjdt_now.t=0  & mjdt_add=mjdt_now
  mjdt_add.mjd=t / 86400l  &  mjdt_add.t=t mod 86400l
  mjdt_now = addSubTime(mjdt_now,mjdt_add,/ADD)

  convert_t90_to_date,mjdt_now, yr, doy, hr, min, sec, mon, cmon, dom, /mjdt
  time_str=string(hr,min,format="(i2.2,':',i2.2)")
  sec_str = string(sec,format="(f6.3)")
  date_str=string(dom,cmon,yr,format="(i2.2,a3,i4.4)")
  
  out_str=time_str+'!C'+sec_str+'!C'+date_str
  if index ne 0 then if olddate eq date_str then out_str=time_str+'!C'+sec_str
  olddate=date_str
  
  if widgetData.default_XLINES eq 1 then out_str=time_str
  
  return,down_str+out_str

  return, mjdt_date_ms(axis, index, t)

end


;******************************************************************************
;mjdt_date_ms returns dates as ss.mss 
;                     modified from Friedel's mjdt_date_4
;                     by Doug Rowland
;
function mjdt_date_ms, axis, index, t
    
   COMMON shift_label, down
   COMMON mjdt, mjdt_start, mjdt_end

   down_str=''
   for i=0,down-1 do down_str=down_str+'!C'

   mjdt_now = mjdt_start

   add_days = t / 86400l
   add_sec  = t mod 86400l

   mjdt_now.mjd = mjdt_start.mjd + add_days
   mjdt_now.t   = add_sec

   if mjdt_now.t ge 86400 then begin
      mjdt_now.t  = mjdt_now.t  - 86400
      mjdt_now.mjd= mjdt_now.mjd + 1
   endif

   convert_t90_to_date,mjdt_now, $
	 year, doy, hour, minutes, sec, month, cmonth, dom, /mjdt

   ms = sec - floor(sec)

   date_str=string(sec,ms,format="(i2.2,'.',i3.3)")
   return,down_str+date_str

end
;******************************************************************************
;* function find_timeticksmjd
;* takes starttime,endtime in time in seconds
;* since the start of the first Modified Julian day
;* loaded into PAPCO (PAPCO standard)
;* spits out "nice" ticks
;* formatstring is the routine that should be used to label the ticks
;******************************************************************************
PRO papco_timeticks, tickvalues, minor, formatstring, NTICKS=NTICKS

;start section common to ALL papco routines ----------------------------------
COMMON PLOT_COMPOSER, widgetData

IF keyword_set(INFO) THEN BEGIN
    IF info EQ 2 THEN print = 1 ELSE print = 0
    doc_library, 'papco_timeticks', PRINT = print
    return
ENDIF

IF keyword_set(VERBOSE) THEN verbose = 1 ELSE verbose = 0
IF widgetData.default_verbose THEN verbose = 1
;end section common to ALL papco routines ------------------------------------

COMMON mjdt, mjdt_start, mjdt_end
  
;set the possible time format strings
time_fs=['mjdt_ddmmmyyyy','mjdt_hhmm','mjdt_date_sec','mjdt_date_ms']
  
  ;set v time differences between ticks in seconds.
  v_ms=[1,2,5,10,20,50,100,200,500]
  f_ms=bytarr(n_elements(v_ms))          &  f_ms(*) =3
  v_sec=[1,2,5,10,15,20,30]
  f_sec=bytarr(n_elements(v_sec))        &  f_sec(*)=2
  v_min=v_sec
  f_min=bytarr(n_elements(v_min))        &  f_min(*)=1
  v_hr=[1,2,3,4,6,8,12]
  f_hr=bytarr(n_elements(v_hr))          &  f_hr(*) =1
  v_day=[1,2,5,10,20,30,121,365,730,1461,3652, 7305]
  f_day=bytarr(n_elements(v_day))        &  f_day(*)=0
  
  ;minor tick intervals
  m=[v_ms,v_sec,v_min,v_hr,v_day]
  ;seconds intervals
  v=[v_ms*0.001d,v_sec*1d,v_min*60d,v_hr*3600d,v_day*86400d]
  f=[f_ms,f_sec,f_min,f_hr,f_day]
  
  ;find range of plot in seconds
  deltat=(mjdt_end.mjd-mjdt_start.mjd)*86400.0d +(mjdt_end.t-mjdt_start.t)*1.0d
  starttime= mjdt_start.t*1.0d
  endtime  = (mjdt_end.mjd - mjdt_start.mjd)*86400.0d + mjdt_end.t*1.0d 
  
  ;find nearest v time difference given requested NTICKS. 
  ;make sure NTICKS is NOT exceeded! 
  if keyword_set(NTICKS) then nticks=NTICKS else nticks=!X.TICKS
  IF nticks EQ 0 THEN nticks = 4
  
  test_range = abs(v*nticks - deltat)
  result=min(test_range,min_idx)
  
  find_ticks:
  v_diff=v(min_idx)
  
  ;!!! this might change to find best "whole" start times  !!!
  ;now find good end and start times. Find the first
  ;whole time divisible by the v_diff.
  abs_starttime=mjdt_start.mjd*86400.0d + mjdt_start.t*1.0d 
  abs_starttime=ceil(abs_starttime/v_diff)*v_diff
  starttime=abs_starttime-mjdt_start.mjd*86400.0d
  tickvalues=[starttime]  &  nexttick=starttime+v_diff
  
  while nexttick le endtime do begin
    tickvalues=[tickvalues,nexttick]
    nexttick=nexttick+v_diff
  endwhile
  
  if n_elements(tickvalues) gt nticks then begin
    min_idx=min_idx+1
    goto,find_ticks
  endif  
  
  ;now select the best formatstring for time axis labels.  
  formatstring=time_fs(f(min_idx))
  
  ;set valid minor tick intervals based on valid time differences between ticks
  minor=m(min_idx)
  while minor gt 10 do begin  &  minor=minor/10  &  endwhile 
  if minor lt 2 then minor=4

IF verbose then message, $
  'Format: '+formatstring+', Minor: '+varprt(minor), /cont

END

