;-----------------------------------------------------------------------------
;  This is a collection procedures for returning tick-labels.
;
;  Earlier, all those procedures were in separate plot-files. As this might
;  lead to some problems, when using multiple plots (e.q. MEA and
;  CRRES), I ripped them out and put them together into this file.
;
;  This was necessary, because I had to change some tick-procedures. 
;  Maintanance is made easier this way...
;  
;  The function-headers list the names of all the files from which the
;  routines were ripped out.
;-----------------------------------------------------------------------------


;-----------------------------------------------------------------------------
; This function was ripped out from:
;   $HOME/idlprog/crres/p_crres_flux.pro
;   $HOME/idlprog/LEPA/p_lepa_flux.pro
;   $HOME/idlprog/MEA/p_mea_spec.pro
function mltticks,axis,index,t

   common ephem, xutepf,xmlt,xilat,xlshel,xrad,ndat

   difft=abs(xutepf-t)
   result=min(difft,minindex)

   mlt=xmlt(minindex)

  return,string(mlt,format="('!C',f4.1)")

end

;-----------------------------------------------------------------------------
; This function was ripped out from:
;   $HOME/idlprog/crres/p_crres_flux.pro
;   $HOME/idlprog/LEPA/p_lepa_flux.pro
;   $HOME/idlprog/Widgets/p_crres_spec.pro
;   $HOME/idlprog/MEA/p_mea_spec.pro
;
function ilatticks,axis,index,t

   common ephem, xutepf,xmlt,xilat,xlshel,xrad,ndat

   difft=abs(xutepf-t)
   result=min(difft,minindex)

   mlt=xilat(minindex)

  return,string(mlt,format="('!C!C',f5.1)")

end 

;-----------------------------------------------------------------------------
; This function was ripped out from:
;   $HOME/idlprog/crres/p_crres_flux.pro
;   $HOME/idlprog/LEPA/p_lepa_flux.pro
;   $HOME/idlprog/isee_project/p_pitch.pro
;   $HOME/idlprog/isee_project/p_pitch2.pro
;   $HOME/idlprog/isee_project/p_spectra.pro
;   $HOME/idlprog/isee_project/lshelticks.pro
;   $HOME/idlprog/Widgets/p_crres_spec.pro
;   $HOME/idlprog/MEA/p_mea_spec.pro
function lshelticks,axis,index,t

   common ephem, xutepf,xmlt,xilat,xlshel,xrad,ndat

   difft=abs(xutepf-t)
   result=min(difft,minindex)

   mlt=xlshel(minindex)

  return,string(mlt,format="('!C!C!C',f3.1)")

end 

;-----------------------------------------------------------------------------
; This function was ripped out from:
;   $HOME/idlprog/crres/p_crres_flux.pro
;   $HOME/idlprog/LEPA/p_lepa_flux.pro
;   $HOME/idlprog/isee_project/p_pitch.pro
;   $HOME/idlprog/isee_project/p_pitch2.pro
;   $HOME/idlprog/isee_project/p_spectra.pro
;   $HOME/idlprog/Widgets/p_crres_spec.pro
;   $HOME/idlprog/MEA/p_mea_spec.pro
function radticks,axis,index,t

   common ephem, xutepf,xmlt,xilat,xlshel,xrad,ndat

   difft=abs(xutepf-t)
   result=min(difft,minindex)

   mlt=xrad(minindex)

  return,string(mlt,format="('!C!C!C!C',i5)")

end 


;-----------------------------------------------------------------------------
; This function was ripped out from:
;   $HOME/idlprog/crres/bin2ascii.pro
;   $HOME/idlprog/crres/p_crres_flux.pro
;   $HOME/idlprog/LEPA/p_lepa_flux.pro
;   $HOME/idlprog/isee_project/orbit_3d.pro
;   $HOME/idlprog/Los_Alamos/plotlosal_old.pro
;   $HOME/idlprog/Los_Alamos/p_losal_flux.pro
;   $HOME/idlprog/Widgets/p_crres_spec.pro
function timeticks,axis,index,t

   t=t MOD (24*LONG(3600))	; time of day...
   hour = long(t)/3600
   minute = long(t-3600 * hour) / 60
   sec= t mod 60 

   return,string(hour,minute,sec,format="(i2.2,':',i2.2,'!D:',i2.2)")

end 


;-----------------------------------------------------------------------------
function timeticks_hr,axis,index,t

   hour = long(t)/3600
   minute = long(t-3600 * hour) / 60
   sec= t mod 60 

   return,string(hour,minute,sec,format="(i2.2,':',i2.2,'!C',f6.3)")

end 

;-----------------------------------------------------------------------------
; This function was ripped out from:
;   $HOME/idlprog/crres/p_crres_flux.pro
;   $HOME/idlprog/LEPA/p_lepa_flux.pro
;   $HOME/idlprog/Los_Alamos/plotlosal_old.pro
;   $HOME/idlprog/Los_Alamos/p_losal_flux.pro
;   $HOME/idlprog/Widgets/p_crres_spec.pro
;   $HOME/idlprog/MEA/p_mea_spec.pro
;   $HOME/idlprog/step_6.4/p_step_mag.pro
function nofirst2,axis,index,t
   if (index eq 0) then $
      return,' ' $
   else begin
      exp=fix(alog10(t)) 
      return,string(exp,format="('10!u',i1)")
   endelse

end 



;-----------------------------------------------------------------------------
; This function was ripped out from:
;   $HOME/idlprog/crres/p_crres_flux.pro
;   $HOME/idlprog/LEPA/p_lepa_flux.pro
;   $HOME/idlprog/isee_project/p_lav.pro
;   $HOME/idlprog/Widgets/p_crres_spec.pro
;   $HOME/idlprog/MEA/p_mea_spec.pro
;   $HOME/idlprog/Common/axislabels/noticks.pro
function noticks,axis,index,t
   empty=' '
   return,empty

end 

;------------------------------------------------------------------------------
; This function was ripped out from:
;   $HOME/idlprog/OMNI/plotomni.pro
;   $HOME/idlprog/OMNI/plotomni90.pro

function orbitticks,axis,index,t
   common lavlabel, time90, orbit, ipw, ichan, nd
   common time, xut1,xut2

   check=size(time90)
   if check(0) eq 0 then return,''
   res=min(abs(time90-t),mindex)

   if res lt 36000.0 then $
      return,string(orbit(mindex),format="('!C!C',i4.4)") $
   else $
      return,''
end 

;-----------------------------------------------------------------------------
; This function was ripped out from:
;   $HOME/idlprog/crres/p_crres_mag.pro
;   $HOME/idlprog/OMNI/plotomni.pro
;   $HOME/idlprog/OMNI/plotomni90.pro
;   $HOME/idlprog/OMNI/p_omni90.pro
;   $HOME/idlprog/Widgets/p_crres_mag.pro
;   $HOME/idlprog/geos/p_geos_mag.pro

function nofirst1,axis,index,t
   if ((index eq 0) or (index eq 0)) then $
     return,' ' else return,string(t,format="(i5)")
end 

;-----------------------------------------------------------------------------
function magticks,axis,index,t
   return,string(t,format="(i7)")
end 

;------------------------------------------------------------------------------
; This function labels orbits given that a lav file was read
; Written  Jan 96, R. Friedel 
;
function crres_orb_ticks,axis,index,t

   COMMON apo_info, apogees

   t90=apogees(*,4)
   res=min(abs(t90-t),mindex)

   if res lt 86400.0 then $
      return,string(apogees(mindex,0),format="('!C!C',i4.4)") $
   else $
      return,''
end 
 
;------------------------------------------------------------------------------
; This function labels mlt given that a lav file was read
; Written  Jan 96, R. Friedel 
;

function crres_mlt_ticks,axis,index,t

   COMMON apo_info, apogees
   
   t90=apogees(*,4)
   res=min(abs(t90-t),mindex)

   if res lt 86400.0 then $
      return,string(apogees(mindex,1),format="('!C!C!C',f4.1)") $
   else $
      return,''
end

;------------------------------------------------------------------------------

function nozero,axis,index,t
if t eq 0. then return,' ' else return,string(t,format="(f5.1)")
end 

;------------------------------------------------------------------------------

function nozero2,axis,index,t
if t lt 0. then t=-t
if (t eq 0.) or (t eq 1.) then return,' ' else return,string(t,format="(f4.1)")
end 

;------------------------------------------------------------------------------

function nozero3,axis,index,t
if t lt 0. then t=-t
if (t eq 0.) or (t eq 1.) then return,' ' else return,string(t,format="(i1)")
end 

;------------------------------------------------------------------------------
; The following  functions use the papco mjdt time format to label axis 
; with a date string.
; Usually, time axis use seconds since the start of the day of the start day. 
; The time common block from papco hands over begin and end time
; in MJDT (modified Julian date plus time since midnight) format.
; 
; Here, we use the start time and the sec since midnight of startday
; To calculate the tick date.
;
; mjdt_date_1 returns dates as dd-mmm-yyyy
; mjdt_date_2 returns dates as dd-mmm/hh:mm
; mjdt_date_3 returns dates as ddmmmyy
; mjdt_date_4 returns dates as hh:mm
;
; The common block shift_label controlls how many lines down from the nornmal
; label line to go.
;
; Written  Jan 97, R. Friedel
;------------------------------------------------------------------------------

function mjdt_date_1, axis, index, t

   COMMON shift_label, down
   COMMON mjdt, mjdt_start, mjdt_end

   mjdt_now=mjdt_start 
   
   add_days = t / 86400l
   add_sec  = t mod 86400l

   mjdt_now.mjd = mjdt_start.mjd + add_days
   mjdt_now.t   = add_sec

   if mjdt_now.t ge 86400 then begin
      mjdt_now.t  = mjdt_now.t  - 86400
      mjdt_now.mjd= mjdt_now.mjd + 1
   endif

   convert_t90_to_date,mjdt_now, $
         year, doy, hour, minutes, sec, month, cmonth, dom, /mjdt

   return,string(dom,cmonth,year,format="(i2.2,'-',a3,'-',i4.4)")

end

;------------------------------------------------------------------------------
; mjdt_date_2 returns dates as dd-mmm/hh:mm

function mjdt_date_2, axis, index, t

   COMMON shift_label, down
   COMMON mjdt, mjdt_start, mjdt_end

   mjdt_now=mjdt_start 
   
   add_days = t / 86400l
   add_sec  = t mod 86400l

   mjdt_now.mjd = mjdt_start.mjd + add_days
   mjdt_now.t   = add_sec

   if mjdt_now.t ge 86400 then begin
      mjdt_now.t  = mjdt_now.t  - 86400
      mjdt_now.mjd= mjdt_now.mjd + 1
   endif

   convert_t90_to_date,mjdt_now, $
         year, doy, hour, minutes, sec, month, cmonth, dom, /mjdt

   date_str=string(dom,cmonth,hour,minutes,format="(i2.2,'!U',a3,'!N/',i2.2,':',i2.2)")

   return,date_str

end

;------------------------------------------------------------------------------
; mjdt_date_3 returns dates as ddmmmyyyy

function mjdt_date_3, axis, index, t

   COMMON mjdt, mjdt_start, mjdt_end
   COMMON shift_label, down

   down_str=''
   for i=0,down-1 do down_str=down_str+'!C' 

   mjdt_now=mjdt_start 

   add_days = t / 86400l
   add_sec  = t mod 86400l

   mjdt_now.mjd = mjdt_start.mjd + add_days
   mjdt_now.t   = add_sec

   if mjdt_now.t ge 86400 then begin
      mjdt_now.t  = mjdt_now.t  - 86400
      mjdt_now.mjd= mjdt_now.mjd + 1
   endif

   convert_t90_to_date,mjdt_now, $
         year, doy, hour, minutes, sec, month, cmonth, dom, /mjdt

   date_str=string(dom,cmonth,year,format="(i2.2,a3,i4.4)")
   return,down_str+date_str

end

;------------------------------------------------------------------------------
; mjdt_date_4 returns dates as hh:mm

function mjdt_date_4, axis, index, t

   COMMON shift_label, down
   COMMON mjdt, mjdt_start, mjdt_end

   down_str=''
   for i=0,down-1 do down_str=down_str+'!C'

   mjdt_now=mjdt_start 
   
   add_days = t / 86400l
   add_sec  = t mod 86400l

   mjdt_now.mjd = mjdt_start.mjd + add_days
   mjdt_now.t   = add_sec

   if mjdt_now.t ge 86400 then begin
      mjdt_now.t  = mjdt_now.t  - 86400
      mjdt_now.mjd= mjdt_now.mjd + 1
   endif

   convert_t90_to_date,mjdt_now, $
         year, doy, hour, minutes, sec, month, cmonth, dom, /mjdt

   date_str=string(hour,minutes,format="(i2.2,':',i2.2)")
   return,down_str+date_str

end

;------------------------------------------------------------------------------
; mjdt_date_5 returns dates as hh:mm, newline, dd/mmm/yyyy

function mjdt_date_5, axis, index, t

   COMMON shift_label, down
   COMMON mjdt, mjdt_start, mjdt_end

   down_str=''
   for i=0,down-1 do down_str=down_str+'!C'

   mjdt_now=mjdt_start 
   
   add_days = t / 86400l
   add_sec  = t mod 86400l

   mjdt_now.mjd = mjdt_start.mjd + add_days
   mjdt_now.t   = add_sec

   if mjdt_now.t ge 86400 then begin
      mjdt_now.t  = mjdt_now.t  - 86400
      mjdt_now.mjd= mjdt_now.mjd + 1
   endif

   convert_t90_to_date,mjdt_now, $
         year, doy, hour, minutes, sec, month, cmonth, dom, /mjdt


   date_str1=string(dom,cmonth,format="(i2.2,a3)")
   date_str2=string(hour,minutes,format="(i2.2,':',i2.2)")
   return,down_str+date_str1+'!C!C'+date_str2

end

;------------------------------------------------------------------------------
; The following  functions use the papco mjdt time format to label axis 
; with a date string.
; Here, for plots which go over many days, the time format used is mjd decimal
; day, to keep the plot values in the float range for the idl plot routine
; The time common block from papco hands over begin and end time
; in MJDT (modified Julian date plus time since midnight) format.
; 
; Here, we use the decimal mjd time to calculate the tick time / date.
;
; mjd_dec_1 returns dates as ddmmmyy
; mjd_dec_2 returns dates as hh:mm
;
; The common block shift_label controlls how many lines down from the nornmal
; label line to go.
;
; Written June 97, R. Friedel
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; mjd_dec_1 returns dates as ddmmmyy

function mjd_dec_1, axis, index, t

   COMMON mjdt, mjdt_start, mjdt_end
   COMMON shift_label, down

   down_str=''
   for i=0,down-1 do down_str=down_str+'!C'
   
   mjdt_now=mjdt_start 
   mjdt_now.mjd=long(t)
   mjdt_now.t=(t-mjdt_now.mjd)*86400.0

   convert_t90_to_date,mjdt_now, $
         year, doy, hour, minutes, sec, month, cmonth, dom, /mjdt

   date_str1=string(dom,cmonth,year-1900,format="(i2.2,a3,i2.2)")


   return,down_str+date_str1

end

;------------------------------------------------------------------------------
; mjd_dec_1a returns dates as ddmmmyy. Assumes time is time - start mjd.

function mjd_dec_1a, axis, index, t

   COMMON mjdt, mjdt_start, mjdt_end
   COMMON shift_label, down

   down_str=''
   for i=0,down-1 do down_str=down_str+'!C'
   
   t=t+mjdt_start.mjd

   mjdt_now=mjdt_start 
   mjdt_now.mjd=long(t)
   mjdt_now.t=(t-mjdt_now.mjd)*86400.0

   convert_t90_to_date,mjdt_now, $
         year, doy, hour, minutes, sec, month, cmonth, dom, /mjdt

   date_str1=string(dom,cmonth,year,format="(i2.2,a3,i4.4)")

   return,down_str+date_str1

end
;------------------------------------------------------------------------------
; mjd_dec_2 returns dates as hh:mm

function mjd_dec_2, axis, index, t

   COMMON mjdt, mjdt_start, mjdt_end
   COMMON shift_label, down

   down_str=''
   for i=0,down-1 do down_str=down_str+'!C'
   
   mjdt_now=mjdt_start 
   mjdt_now.mjd=long(t)
   mjdt_now.t=(t-mjdt_now.mjd)*86400.0

   convert_t90_to_date,mjdt_now, $
         year, doy, hour, minutes, sec, month, cmonth, dom, /mjdt

   date_str1=string(hour,minutes,format="(i2.2,':',i2.2)")

   return,down_str+date_str1

end
 
;------------------------------------------------------------------------------
; cdf_epoch_1 returns dates as mm/dd/yyyy

function cdf_epoch_1, axis, index, t

  COMMON shift_label, down
  common cdf_epoch, start_time

  down_str=''  &  for i=0,down-1 do down_str=down_str+'!C'
  
  cdf_epoch,t+start_time, year, month, day_om, hour, minute, second, $
    /BREAKDOWN_EPOCH 

  date_str=string(day_om,month,year,format="(i2.2,'/',i2.2,'/',i4.4)")
  return,down_str+date_str

end 

;------------------------------------------------------------------------------
; cdf_epoch_2 returns dates as hh:mm

function cdf_epoch_2, axis, index, t

  COMMON shift_label, down
  common cdf_epoch, start_time

  down_str=''  &  for i=0,down-1 do down_str=down_str+'!C'
    
  cdf_epoch,t+start_time, year, month, day_om, hour, minute, second, $
    /BREAKDOWN_EPOCH 

  date_str=string(hour,minute,format="(i2.2,':',i2.2)")
  return,down_str+date_str

end 

function kp_ticks, axis, index, t

  COMMON shift_label, down
  if n_elements(down) eq 0 then down=0

  down_str=''  &  for i=0,down-1 do down_str=down_str+'!C'
    
  ;make KP arrays
  kp_str=[      '0', '0+', '1-', '1', '1+', $
          '2-', '2', '2+', '3-', '3', '3+', $
          '4-', '4', '4+', '5-', '5', '5+', $
          '6-', '6', '6+', '7-', '7', '7+', $
          '8-', '8', '8+', '9-', '9', '9'  ]
  
  out_str=kp_str(fix(t))
  return,down_str+out_str

end 

;------------------------------------------------------------------------------
; TAI_date_1 returns dates as yyyymmdd

function TAI_date_1, axis, index, t

  COMMON mjdt, mjdt_start, mjdt_end
  COMMON shift_label, down

  down_str='' &  for i=0,down-1 do down_str=down_str+'!C' 
   
; get start time in TAI   
  convert_t90_to_date, mjdt_start, year, day_oy, hour, minute, second,$
    month, cmonth, day_om, /mjdt 
  TAI_start=UTC2TAI({YEAR:year, MONTH:month, DAY:day_om, HOUR:hour, $
                     MINUTE:minute, SECOND:second, MILLISECOND:0.0})   
  TAI_now=t+TAI_start
  now=TAI2UTC(TAI_now, /external)

  date_str=string(now.year,now.month,now.day,format="(i4.4,i2.2,i2.2)")
  return,down_str+date_str

end

;------------------------------------------------------------------------------
; TAI_time_1 returns time as hh:mm

function TAI_time_1, axis, index, t

  COMMON mjdt, mjdt_start, mjdt_end
  COMMON shift_label, down

  down_str='' &  for i=0,down-1 do down_str=down_str+'!C' 
   
; get start time in TAI   
  convert_t90_to_date, mjdt_start, year, day_oy, hour, minute, second,$
    month, cmonth, day_om, /mjdt 
  TAI_start=UTC2TAI({YEAR:year, MONTH:month, DAY:day_om, HOUR:hour, $
                     MINUTE:minute, SECOND:second, MILLISECOND:0.0})   
  TAI_now=t+TAI_start
  now=TAI2UTC(TAI_now, /external)

  date_str=string(now.hour,now.minute,format="(i2.2,':',i2.2)")
  return,down_str+date_str

end
