;======================================================================
;  
PRO time_label,timemin,timemax,no_ticks,ticks_vector,minor_ticks
;
;  input: timemin, timemax: start, stop time given in seconds after end of 1989
;                           (no leap seconds included after 1989 !!!!)                
;         no_ticks        : number of tick marks   
; output: no_ticks        : modified number of ticks mark
;         ticks_vector    : time values for tick marks
;         minor_ticks     : number of minor tick marks
;
   timelength= 0L
   ticks_vector = lonarr(no_ticks)
   timelength = timemax - timemin
   sec_min=60L
   sec_hour=3600L
   sec_dayhalf=43200L
   sec_day=86400L
   timemod=60L
   timestepstart=1
   timestep=60L
   newtime=timemin
   repeat begin
      newtime = newtime+timestepstart
      smod = newtime MOD timestep
   endrep until (smod eq 0)

   if ((timelength ge (50*sec_min)) and (timelength lt (5*sec_hour)))   $
     then timemod = 10 * sec_min
   if ((timelength ge (5*sec_hour)) and (timelength lt sec_dayhalf))   $
     then timemod = sec_hour/2
   if ((timelength ge sec_dayhalf) and (timelength lt sec_day))   $
     then timemod = sec_hour
   if ((timelength ge sec_day) and (timelength lt (2*sec_day)))   $
     then timemod = 2*sec_hour 
   if ((timelength ge 2*sec_day) and (timelength lt (4*sec_day)))   $
     then timemod = long(sec_dayhalf/2L)
   if ((timelength ge (4*sec_day)) and (timelength lt (8*sec_day)))   $
     then timemod = long(sec_dayhalf)
   if ((timelength ge (8*sec_day)) and (timelength lt (16*sec_day)))  $
     then timemod = long(sec_day)
   if ((timelength ge (16*sec_day)) and (timelength lt (32*sec_day)))  $
     then timemod = long(2*sec_day)
   if ((timelength ge (32*sec_day)) and (timelength lt (64*sec_day)))  $
     then timemod = long(5*sec_day)
   if ((timelength ge (64*sec_day)) and (timelength lt (124*sec_day)))  $
     then timemod = long(10*sec_day)
   if ((timelength ge (124*sec_day)) and (timelength lt (248*sec_day)))  $
     then timemod = long(20*sec_day)
   if (timelength ge (248*sec_day)) then timemod = long(40*sec_day) 
   
   
;
; Search start tick
;   
   time_search=long(newtime)
   repeat begin
      tmod = time_search MOD timemod
      if (tmod eq 0) then ticks_vector(0) = time_search
      time_search = time_search + timestep
   endrep until (tmod eq 0)
;
;  Calculate time ticks
;
   timelength = timemax - ticks_vector(0)
   interval = long(timelength/no_ticks + 1)
   minor_ticks=fix(interval / timemod)
   intervallength = minor_ticks*timemod
;   rest = (interval - intervallength) * no_ticks
   testtime = intervallength * no_ticks + ticks_vector(0)
   if ((timemax - (testtime+intervallength)) ge 0) then begin
      minor_ticks=minor_ticks+1
      intervallength = minor_ticks*timemod
      testtime = intervallength * no_ticks + ticks_vector(0)  
   endif   
   for i=1,no_ticks-1  do begin
      ticks_vector(i) = ticks_vector(0) + i*intervallength
   endfor
   ticksend=ticks_vector(0)+no_ticks*intervallength
   if ((timemax - testtime) gt 0) then begin
      ticks_vector = [ticks_vector,ticksend]
      no_ticks=no_ticks + 1 
   endif
;   print,'timevector  ',ticks_vector
   return
end
;  
;======================================================================
;
function xticks,axis,index,value
;
   secd=24*3600L
;        sum90 =14610*secd+25L
; seconds of year from 1990 til 1999 (include leap seconds here)
   sec365=secd*365L
   sec366=secd*366L
;  
   secy= $
     [sec365,sec365,sec366,sec365,sec365,sec365,sec366,sec365,sec365,sec365]
;
; calculate the iyear value
;
   ltime=long(value)

;      print,ltime,format='(i20)'
;        tcounts=n_elements(time)
;        iyear=INTARR(tcounts)
   moarray = ['   ','Jan','Feb','Mar','Apr','May','Jun', $
              'Jul','Aug','Sep','Oct','Nov','Dec'] 

;
   dayarray=[0,31,28,31,30,31,30,31,31,30,31,30,31]

   i=0
   rtime=long(ltime)            ;-sum90
   while rtime GE secy(i) do begin
      rtime=rtime-secy(i)
      i=i+1
   endwhile
   iyear=90+i
   idoy=fix(rtime/secd)
   rsec=rtime-idoy*secd
   ihour=fix(rsec/3600L)
   rsec=rsec-ihour*3600L
   imin=fix(rsec/60L)
   isec=rsec-imin*60L
   idoy=idoy+1
;
;       IF (N_PARAMS(0) GE 7) THEN BEGIN
; Now calculate the month and day information
;
   if (FIX(iyear/4)*4 eq iyear ) then dayarray(2)=29 $
   else dayarray(2)=28
;
   i=1
   rdoy=idoy-1
   while rdoy GE dayarray(i) do begin
      rdoy=rdoy-dayarray(i)
      i=i+1
   endwhile
   imonth=i
   moday=rdoy+1
   cmonth=moarray(i)
;       ENDIF
;      ENDFOR
;      IF tcounts EQ 1 THEN BEGIN
;        iyear=iyear(0)
;        idoy=idoy(0)
;        ihour=ihour(0)
;        imin=imin(0)
;        isec=isec(0)
;        IF (N_PARAMS(0) GE 7) THEN BEGIN
;         imonth=imonth(0)
;         moday=moday(0)
;         cmonth=cmonth(0)
;        ENDIF
;      ENDIF
   
   return, string(idoy,ihour,imin,format="(i3.3,'/',i2.2,':',i2.2)")
;	return, string(ihour,imin,isec,format="(i3.2,'/',i2.2,':',i2.2)")
end

;======================================================================
;
function xticksdate,axis,index,value
;
; calculate the offset sum, the time to the end of 1989 in seconds
;  =14610d*86400s+25Ls
   secd=24*3600L
;        sum90 =14610*secd+25L
; seconds of year from 1990 til 1999 (include leap seconds here)
   sec365=secd*365L
   sec366=secd*366L
;  
   secy= $
     [sec365,sec365,sec366,sec365,sec365,sec365,sec366,sec365,sec365,sec365]
;
; calculate the iyear value
;
   ltime=long(value)

;      print,ltime,format='(i20)'
;        tcounts=n_elements(time)
;        iyear=INTARR(tcounts)
;        idoy=INTARR(tcounts)
;        ihour=INTARR(tcounts)
;        imin=INTARR(tcounts)
;        isec=INTARR(tcounts)
;  IF (N_PARAMS(0) GE 7) THEN BEGIN;
; Set up the Month array
;
;   IF langbit EQ 0 THEN $
   moarray = ['   ','Jan','Feb','Mar','Apr','May','Jun', $
              'Jul','Aug','Sep','Oct','Nov','Dec'] 

;
   dayarray=[0,31,28,31,30,31,30,31,31,30,31,30,31]
;   imonth=INTARR(tcounts)
;   moday=INTARR(tcounts)
;   cmonth=STRARR(tcounts)

;        FOR tc=0,tcounts-1 DO BEGIN
   i=0
   rtime=long(ltime)            ;-sum90
   while rtime GE secy(i) do begin
      rtime=rtime-secy(i)
      i=i+1
   endwhile
   iyear=90+i
   idoy=fix(rtime/secd)
   rsec=rtime-idoy*secd
   ihour=fix(rsec/3600L)
   rsec=rsec-ihour*3600L
   imin=fix(rsec/60L)
   isec=rsec-imin*60L
   idoy=idoy+1
;
;       IF (N_PARAMS(0) GE 7) THEN BEGIN
; Now calculate the month and day information
;
   if (FIX(iyear/4)*4 eq iyear ) then dayarray(2)=29 $
   else dayarray(2)=28
;
   i=1
   rdoy=idoy-1
   while rdoy GE dayarray(i) do begin
      rdoy=rdoy-dayarray(i)
      i=i+1
   endwhile
   imonth=i
   moday=rdoy+1
   cmonth=moarray(i)
;       ENDIF
;      ENDFOR
;      IF tcounts EQ 1 THEN BEGIN
;        iyear=iyear(0)
;        idoy=idoy(0)
;        ihour=ihour(0)
;        imin=imin(0)
;        isec=isec(0)
;        IF (N_PARAMS(0) GE 7) THEN BEGIN
;         imonth=imonth(0)
;         moday=moday(0)
;         cmonth=cmonth(0)
;        ENDIF
;      ENDIF
   lf='!C'  
   return, string(lf,iyear,cmonth,moday,     $
                  format="(A,i2.2,'/',A3,'/',i2.2)")
;	return, string(ihour,imin,isec,format="(i3.2,'/',i2.2,':',i2.2)")
end



;======================================================================
;======================================================================
;
function xticksdate2,axis,index,value
;
;
; calculate the offset sum, the time to the end of 1989 in seconds
;  =14610d*86400s+25Ls
   secd=24*3600L
;        sum90 =14610*secd+25L
; seconds of year from 1990 til 1999 (include leap seconds here)
   sec365=secd*365L
   sec366=secd*366L
;  
   secy= $
     [sec365,sec365,sec366,sec365,sec365,sec365,sec366,sec365,sec365,sec365]
;
; calculate the iyear value
;
   ltime=long(value)

;      print,ltime,format='(i20)'
;        tcounts=n_elements(time)
;        iyear=INTARR(tcounts)
;        idoy=INTARR(tcounts)
;        ihour=INTARR(tcounts)
;        imin=INTARR(tcounts)
;        isec=INTARR(tcounts)
;  IF (N_PARAMS(0) GE 7) THEN BEGIN;
; Set up the Month array
;
;   IF langbit EQ 0 THEN $
   moarray = ['   ','Jan','Feb','Mar','Apr','May','Jun', $
              'Jul','Aug','Sep','Oct','Nov','Dec'] 

;
   dayarray=[0,31,28,31,30,31,30,31,31,30,31,30,31]
;   imonth=INTARR(tcounts)
;   moday=INTARR(tcounts)
;   cmonth=STRARR(tcounts)

;        FOR tc=0,tcounts-1 DO BEGIN
   i=0
   rtime=long(ltime)            ;-sum90
   while rtime GE secy(i) do begin
      rtime=rtime-secy(i)
      i=i+1
   endwhile
   iyear=90+i
   idoy=fix(rtime/secd)
   rsec=rtime-idoy*secd
   ihour=fix(rsec/3600L)
   rsec=rsec-ihour*3600L
   imin=fix(rsec/60L)
   isec=rsec-imin*60L
   idoy=idoy+1
;
;       IF (N_PARAMS(0) GE 7) THEN BEGIN
; Now calculate the month and day information
;
   if (FIX(iyear/4)*4 eq iyear ) then dayarray(2)=29 $
   else dayarray(2)=28
;
   i=1
   rdoy=idoy-1
   while rdoy GE dayarray(i) do begin
      rdoy=rdoy-dayarray(i)
      i=i+1
   endwhile
   imonth=i
   moday=rdoy+1
   cmonth=moarray(i)
;       ENDIF
;      ENDFOR
;      IF tcounts EQ 1 THEN BEGIN
;        iyear=iyear(0)
;        idoy=idoy(0)
;        ihour=ihour(0)
;        imin=imin(0)
;        isec=isec(0)
;        IF (N_PARAMS(0) GE 7) THEN BEGIN
;         imonth=imonth(0)
;         moday=moday(0)
;         cmonth=cmonth(0)
;        ENDIF
;      ENDIF
   return, string(iyear,cmonth,moday,     $
                  format="(i2.2,'/',A3,'/',i2.2)")
;	return, string(ihour,imin,isec,format="(i3.2,'/',i2.2,':',i2.2)")
end


;======================================================================
; for giving correct ticks if time is in seconds since begining of year
; only - for high resolution timing

function xticksdate3,axis,index,value

   common time, xut1,xut2		;common time limits in T90

;work out actual start year - this has to be added
   convert_t90_to_date,xut1,y,doy,h,m,s,mon,cm,dom
   time_base=convert_date_to_t90(year=y)
   t90=value+time_base

   convert_t90_to_date,t90,y,doy,h,m,s,mon,cm,dom


   lf='!C'  
   return, string(lf,y,cm,dom,     $
                  format="(A,i2.2,'/',A3,'/',i2.2)")
end


