function cat_struct, a, b
;**********************************************************************
;* function cat_struct, a, b
;* 
;* PURPOSE:
;*       Catenate structures which may have redundant fields.
;*       This is only needed for IDL V5, earlier versions can 
;*       just use create_struct to cat redundant structures.
;*       DOES NOT WORK WITH ARRAYS OF STRUCTURES
;*       Note that if both a and b contain the same tag, the returned
;*       structure c, will have c.tag = a.tag
;*
;* INPUTS:
;*       a, b  structures.
;*
;* OUTPUT:
;*       Structure containing the fields of a and b.
;*
;* HISTORY:
;*       created 12/3/97 by jason franz at cornell university
;*        as a quick fix for PAPCO
;**********************************************************************

; check input
;;;;;;;;;;;;;

  sa = size(a) & sb = size(b)

  ;make sure a and b are not arrays
  if (sa(0) ne 1 or sa(1) ne 1 or sb(0) ne 1 or sb(1) ne 1) then $
      message, 'cat_struct does not handle arrays'

  ;make sure a and b are structures
  if (sa(2) ne 8 or sb(2) ne 8) then message, 'arguments are not structures'

; check for duplicate tag definitions
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ta = tag_names(a) & na = n_tags(a)
  tb = tag_names(b) & nb = n_tags(b)

  ind = intarr(nb)  ;ind(i) contains the position of tb(i) in ta, or -1
  n = 0             ;number of coincident fields

  i = 0
  while i lt nb do begin
    tmp = where(tb(i) eq ta)
    if tmp(0) ne -1 then n = n+1
    ind(i) = tmp
    i=i+1
  endwhile

; catenate the structures
;;;;;;;;;;;;;;;;;;;;;;;;;;
if n eq 0 then return, create_struct(a,b) $
else begin
 c = a
 j = 0
 while j lt nb do begin
   if ind(j) eq -1 then begin
      tmp_st = create_struct(tb(j), b.(j))
      c = create_struct(tmp_st, c)
   endif
   j=j+1
 endwhile
return, c
endelse

end
;**********************************************************************
