;+
; Project     : SOHO - CDS
;
; Name        : 
;	GET_LIB()
; Purpose     : 
;	Place elements of !PATH into a string array..
; Explanation : 
;	Place library and directory elements of !PATH into a string array.
;	Used by SCANPATH.
; Use         : 
;	Result = GET_LIB()
;	Result = GET_LIB( PATH )
; Inputs      : 
;	None required.
; Opt. Inputs : 
;       PATH = Path name (default is !path).
; Outputs     : 
;	Function result is a string array of path elements.
; Opt. Outputs: 
;	None.
; Keywords    : 
;	None.
; Calls       : 
;	PATH_EXPAND, GETTOK
; Common      : 
;	None.
; Restrictions: 
;	None.
; Side effects: 
;	None.
; Category    : 
;	Documentation, Online_help.
; Prev. Hist. : 
;       Written DMZ (ARC) April 1991
;	William Thompson, Dec 1991, modified to be compatible with UNIX, and
;				    with VMS logical names.  Also, to be
;				    compatible with changes in SCANPATH
; Written     : 
;	D. Zarro, GSFC/SDAC, April 1991.
; Modified    : 
;	Version 1, William Thompson, GSFC, 23 April 1993.
;		Incorporated into CDS library.
;	Version 2, William Thompson, GSFC, 7 May 1993.
;		Added IDL for Windows compatibility.
;	Version 3, William Thompson, GSFC, 24 September 1993.
;		Changed EXPAND_PATH to PATH_EXPAND.
;       Version 3.1, Dominic Zarro, GSFC, 1 August 1994.
;               Added check for current directory in path.
; Version     : 
;	Version 3.1, 1 August 1994.
;-
;
       function get_lib,path

       if n_elements(path) eq 0 then temp = !path else temp=path
;
;  expand any vms logical names.
;
	if !version.os eq 'vms' then temp = call_function('path_expand',temp)
;
;  get a listing of all the directories in the path.
;
	if !version.os eq "vms" then begin
        	sep = ','
		dirsep = ''
	end else if !version.os eq "windows" then begin
		sep = ';'
		dirsep = '\'
	end else begin
        	sep = ':'
		dirsep = '/'
	endelse
        cd,current=cdir
        dirs=''
	while temp ne '' do begin
         temp2=gettok(temp,sep)
         dirs = [dirs,temp2]
        endwhile
        ndirs=n_elements(dirs) & dirs=dirs(1:ndirs-1)
        find=where(cdir eq dirs,count)
        plook=findfile('*.pro',count=pcount)
        alook=findfile('aaareadme.txt',count=ccount)
        cok=((pcount gt 0) or (ccount gt 0)) and (find(0) ne 0)
        if cok then dirs=[cdir,dirs]   ;-- add current directory

	return,dirs
	end

