; $Id: str_sep.pro,v 1.1.1.1 2003/11/04 21:23:44 friedel Exp $

; Copyright(c) 1992-1993, CreaSo Creative Software Systems GmbH. 
;	All rights reserved.
;	Unauthorized reproduction prohibited.
;+
; NAME:
;    STR_SEP
;
; PURPOSE:
;    This routine cuts a string into pieces which are separated by the 
;    separator string.
; CATEGORY:
;    String processing.
; CALLING SEQUENCE:
;    arr = STR_SEP(string, separator)
;
; INPUTS:
;    str - The string to be separated.
;    sep - The separator.
;
; KEYWORDS:
;    None.
;
; OUTPUT: 
;    An array of strings as function value.
;
; COMMON BLOCKS:
;    None
;
; SIDE EFFECTS:
;    No known side effects.
;
; RESTRICTIONS:
;    None.
;
; EXAMPLE:
;    array = STR_SEP ("ulib.usca.test", ".")
;
; MODIFICATION HISTORY:
;	July 1992, AH,	CreaSo		Created.
;-
function STR_SEP, str, sep


   n = 0		   ; Determine number of seperators in string.
   spos = 0
   repeat begin
	pos = strpos (str, sep, spos)
	spos = pos + strlen(sep)
	n = n+1
   endrep until pos eq -1

   arr = strarr(n)	   ; Create result array

   spos = 0
   for i=0, n-1 do begin   ; Separate substrings
      pos = strpos (str, sep, spos)
      if pos ge 0 then arr(i) = strmid (str, spos, pos-spos) $
      else arr(i) = strmid(str, spos, strlen(str))
      spos = pos+strlen(sep)
   endfor
return, arr
end
