;+
; Project     : SOHO - CDS
;
; Name        : ESPAWN
;
; Purpose     : spawn a UNIX shell command and return STDIO and STDERR
;
; Category    : OS
;
; Explanation : regular IDL spawn command doesn't return an error message
;
; Syntax      : IDL> espawn,cmd,out
;
; Inputs      : CMD = UNIX command (e.g. cat file)
;
; Opt. Inputs : None
;
; Outputs     : OUT = output of CMD
;
; Opt. Outputs: None
;
; Keywords    : None
;
; Common      : None
;
; Restrictions: Unix only
;
; Side effects: None
;
; History     : Version 1,  24-Jan-1996,  D.M. Zarro.  Written
;
; Contact     : DZARRO@SOLAR.STANFORD.EDU
;-

pro espawn,cmd,out

out=''
if datatype(cmd) ne 'STR' then return

if os_family() eq 'vms' then ncmd=cmd else $
 ncmd='('+cmd+')'+'>& /tmp/temp ; \cat /tmp/temp; \rm /tmp/temp'
if n_params() gt 1 then spawn,ncmd,out else spawn,ncmd

return & end
