pro fdecomp, filename, disk, dir, name, qual, version
;+
; Project     :	SOHO - CDS
;
; Name        :	
;	FDECOMP
; Purpose     :	
;	Decompose file name into components.
; Explanation :	
;	Routine to decompose file name into disk (VMS) + directory +
;       name + qualifier + version (VMS).    
;
;	On a Vax the filenames "MOTD" and "MOTD." are distinguished by the fact
;	that qual = '' for the former and qual = ' ' for the latter.
;
; Use         :	
;	fdecomp, filename, disk, dir, name, qual, version
;
; Inputs      :	
;	filename - string file name, scalar
;
; Opt. Inputs :	None.
;
; Outputs     :	
;	All the output parameters are scalar strings
;	disk - disk name, always '' on a Unix machine
;	dir - directory name
;	name - file name
;	qual - qualifier, set equal to the characters beyond the last "."
;	version - version number, always '' on a Unix machine
;
; Opt. Outputs:	None.
;
; Keywords    :	None.
;
; Calls       :	
;	GETTOK
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Utilities, Operating_System
;
; Prev. Hist. :	
;	version 1  D. Lindler  Oct 1986
;	converted to SUN IDL.  M. Greason, STX, 30 July 1990.
;	W. Landsman     STX, August, 1991
;
; Written     :	D. Lindler, GSFC/HRS, October 1986
;
; Modified    :	Version 1, William Thompson, GSFC, 29 March 1994
;			Incorporated into CDS library
;		Version 2, William Thompson, GSFC, 16 August 1995
;			Incorporate following changes.
;
;	Include VMS DECNET machine name in disk    W. Landsman  HSTX  Feb. 94
;	Converted to Mac IDL, I. Freedman HSTX March 1994
;
; Version     :	Version 2, 16 August 1995
;-
;
;--------------------------------------------------------
;
  On_error,2                            ;Return to caller

  if N_params() LT 2 then begin
     print, 'Syntax - fdecomp, filename, disk, [dir, name, qual, ver ] '
     return
  endif

;   find out what machine you're on, and take appropriate action.

 case !VERSION.OS of
  "MacOS": begin

 ; disk name is all characters up to the first colon
   
  st = filename

; get disk

    if strpos(st,':') GE 0 then disk = gettok(st,':')  else disk = ''
	 
; directory is string of folders	 
     dir = ':' & tok = ''
     REPEAT BEGIN
       oldtok = tok
       tok = gettok(st,':')
       dir = dir + oldtok + ':'   
	 ENDREP UNTIL tok EQ ''

       dir = strmid(dir,1,strpos(dir,oldtok)-1)   
	 
; file name+qualifier is all characters after the last colon
     fname = oldtok	& qual = ''
     pos = strpos(fname,'.')
     if pos GE 0 then begin
       name = gettok(fname,'.')
       qual   = fname
     endif 

 ; version   is null string
    version = ''
	
	end

"vms":  begin                     ; begin VMS version

    st = filename

; get disk

    nodepos = strpos(st,'::')          ; Node name included in directory?
    if nodepos GE 0 then begin
	disk = strmid(st,0,nodepos+2) 
	st = strmid(st,nodepos+2, 999 )
    endif else disk = ''
    if strpos(st,':') GE 0 then disk = disk + gettok(st,':') + ':' else $
                                disk = disk + ''

; get dir

    if strpos( st, ']' ) GE 0 then dir = gettok( st, ']' ) + ']' else dir=''
    if strpos( st, ']' ) GE 0 then dir = dir + gettok( st, ']' ) + ']' 

; get name

    sv_name = st
    name = gettok(st,'.')

; get qualifier

    if (name + '.') EQ sv_name then qual = ' ' else $
    qual = gettok(st,';')

; get version

    version = st

  end   ;  end VMS version
 ELSE: begin

    st = filename

; get disk

    disk = ''

; get dir

    lpos = -1
    pos = -1
    repeat begin
	    pos = strpos(st, '/', pos+1)
	    if (pos GE 0) then lpos = pos
    endrep until pos LT 0

    if lpos GE 0 then begin
	    dir = strmid(st, 0, lpos+1)
	    len = strlen(st)
	    if lpos eq (len-1) then st = '' else $
                                    st = strmid(st,lpos+1,len-lpos-1)
    endif else dir = ''

; get name and qual

    pos = -1
    lpos = -1
    repeat begin
             pos = strpos(st,'.',pos+1)
             if (pos GE 0) then lpos = pos
    endrep until pos LT 0

    if lpos GE 0 then begin
             len = strlen(st)
             name = strmid(st,0,lpos)
             qual = strmid(st,lpos+1,len-lpos-1)
     endif else begin
         name = st
         qual = '' 
     endelse

    version = ''

 end 

ENDCASE  			; end OTHER version


  return
  end
