;+
; Project     : SOHO - CDS     
;                   
; Name        : FILE_EXIST()
;               
; Purpose     : Test whether a file exists.
;               
; Explanation : Returns true(1) if any files match pattern=file
;	        or false(0) if no files found.
;               
; Use         : IDL> file_ok = file_exist(filename [,/direct])
;    
; Inputs      : file -  file, pathname or file filter to check
;
; Opt. Inputs : None
;               
; Outputs     : Returns 1/0 as each file does/does not exist.
;               
; Opt. Outputs: None
;               
; Keywords    : direct - set if want full check (slower) - use if might be an
;		empty directory you are looking for
;
; Calls       : None
;               
; Restrictions: None
;               
; Side effects: None
;               
; Category    : Utilities, Files, OS
;               
; Prev. Hist. : Yohkoh procedure by Sam Freeland, LPARL
;
; Written     : CDS version by C D Pike, RAL, 2-Jul-1993
;               
; Modified    : 
;
; Version     : Version 1    2-Jul-1993
;-            

function file_exist, file, direct=direct

;
;  check input
;
if n_params() eq 0 then begin
   bell
   print,'Use: status = file_exist(filename [,/direct])
   return,0
endif

;
;  number of input files?
;
n = n_elements(file)
out = bytarr(n)

;
;  for each file specified...
;
for i=0,n-1 do begin
    case keyword_set(direct) of
	0:test=findfile(file(i),count=count)
;
;  if direct keyword set, can detect empty directories 
;  
	1:begin
           filedelim=str_lastpos(file(i),'/')
           name=strmid(file(i),filedelim+1,strlen(file(i))-filedelim) 
           path=strmid(file(i),0,filedelim)
           files=findfile(path)
           found=where(name eq files)
           count = found(0) ge 0
	end
    endcase
    out(i) = count ne 0
end
;
;  return only a scalar if single file specification input
;
if (n eq 1) then out = out(0)	

return, out

end
