Function GETLOG,lname
;+
; Project     :	SOHO - CDS
;
; Name        :	
;	GETLOG()
; Purpose     :	
;	Returns correct logical dir. for given operating system.
; Explanation :	
;	Returns the correct logical directory for the given operating system.
;	E.G. dat: for vms, $DAT/ for unix.
;
;	The operating system in !version.os is checked. If it equals:
;
;		'vms'		then a ':' is appended.
;
;		else		unix os is assumed and the input string is
;				uppercased, a '$' is prepended and a '/' is
;				appended.
;
; Use         :	
;	GETLOG,lname
;
; Inputs      :	
;	lname	- the base name of the logical (without special characters).
;
; Opt. Inputs :	None.
;
; Outputs     :	
;	Returns appropriate string.
;
; Opt. Outputs:	None.
;
; Keywords    :	None.
;
; Calls       :	None.
;
; Common      :	None.
;
; Restrictions:	
;	Assumes that the created directory logical will have meaning to the host
;	operating system.
;
; Side effects:	None.
;
; Category    :	Utilities, Operating_System
;
; Prev. Hist. :	
;	Written, JDNeill, May, 1990.
;	Modified, JDNeill,Sep, 1990 -- for unix return full path instead of
;		just environment variable name.
;
; Written     :	J. D. Neill, May 1990
;
; Modified    :	Version 1, William Thompson, GSFC, 29 March 1994
;			Incorporated into CDS library
;		Version 2, William Thompson, GSFC, 16 August 1995
;			Incorporated following changes
;
;	Modified, I. Freedman, HSTX April 1994 -- for MacOS return full path
;	Bug in CASE statement fixed.	JDO, HSTX, May 2 1994.
;
; Version     :	Version 1, 29 March 1994
;-
;
;-----------------------------------------------------------------------------
	CASE !VERSION.OS OF
  'vms':      return,lname+':' 
  'MacOS':  return,getenv(strupcase(lname))
   ELSE:	   return,getenv(strupcase(lname))+'/'   ; assume UNIX 
  ENDCASE

;
	end	; getlog.pro
