;+
; Project     : SOHO - CDS
;
; Name        : LIST_PRINTER
;
; Purpose     : LIST available printers from /etc/printcap
;
; Category    : Help, Device
;
; Explanation : Reads /etc/printcap 
;
; Syntax      : IDL> list_printer,printers,desc
;
; Examples    :
;
; Inputs      : None
;
; Opt. Inputs : None
;
; Outputs     : None
;
; Opt. Outputs: DESC -  description of each printer
;
; Keywords    : ERR - error messages
;
; Common      : None
;
; Restrictions: Unix only.
;
; Side effects: None
;
; History     : Version 1,  8-Aug-1995, D M Zarro . Written
;
; Contact     : DZARRO@SOLAR.STANFORD.EDU
;-

pro list_printer,printers,desc,err=err

on_error,1
printers=''
err=''
desc=''
printcap='/etc/printcap'           ;-- sorry Unix only
clook=loc_file(printcap,count=nf)  ;-- look for printcap file
if nf eq 0 then begin
 err='Cannot determine printers, trying PRINTER environmental'
 message,err,/cont
 printers=chklog('PRINTER')
 return
endif

;-- read and parse printcap file

file=rd_ascii(printcap)
vert=strpos(file,'|')
ok=where(vert gt -1,count)
if count gt 0 then begin
 printers=strarr(count) & desc=printers
 temp=file(ok) & vert=vert(ok)
 for i=0,count-1 do begin
  tp=strmid(TEMP[I],0,vert(i))
  printers(i)=tp
  colon=strpos(TEMP[I],':')
  if colon gt -1 then begin
   sub= string(reverse(byte(strmid(TEMP[I],0,colon))))
   vert2=strpos(sub,'|')
   if vert2 gt 0 then begin
    sub2=string(reverse(byte(strmid(sub,0,vert2))))
    desc(i)=sub2
   endif
  endif  
 endfor
endif

desc=strtrim(desc,2)
printers=strtrim(printers,2)

return
end 

