;+
; Project     : SOHO - CDS
;
; Name        : 
;       LOC_FILE()
; Purpose     : 
;       Get files from a set of directories.
; Explanation : 
;	Similar to the standard utility FINDFILE, but allows for a series of
;	directories to be searched.  Also, in Unix, it takes care of pathnames
;	that contain the special "~" character, which FINDFILE currently does
;	not do.
; Use         : 
;       Result = LOC_FILE(FILE,PATH=PATH,LOC=LOC,COUNT=COUNT,ALL=ALL)
; Inputs      : 
;       FILE	= Name of file(s) to search for.  It may contain wildcard
;		  characters.
; Opt. Inputs : 
;	None.
; Outputs     : 
;	The result of the function is an array containing the names of all the
;	files found.
; Opt. Outputs: 
;	None.
; Keywords    : 
;       PATH	= Array or scalar string with names of directories to search.
;       LOC	= Returned directory locations of found files.
;       COUNT	= Number of found files.
;       ALL	= If set, then search all directories.  Otherwise, the
;		  procedure stops as soon as a match is found.
; Calls       : 
;	BREAK_FILE, CONCAT_DIR, DATATYPE
; Common      : 
;	None.
; Restrictions: 
;	None.
; Side effects: 
;	None.
; Category    : 
;	Utilities, Operating_system.
; Prev. Hist. : 
;       Written Dec'92 (DMZ,ARC)
; Written     : 
;	D. Zarro, GSFC/SDAC, December 1992.
; Modified    : 
;	Version 1, William Thompson, GSFC, 23 April 1993.
;		Incorporated into CDS library.
;       Version 2, Dominic Zarro, GSFC, 1 August 1994.
;               Added for error checking
; Version     : 
;	Version 2, 1 August 1994.
;-
;
  
function loc_file,file,path=path,loc=loc,all=all,count=count,verbose=verbose
on_error,1

if keyword_set(verbose) then verb=1 else verb=0

if datatype(file) ne 'STR' then begin
 message,'file not found',/cont
 message,'usage --> FILES=LOC_FILE(FILE,PATH=PATH)'
endif

cd,current=cdir
cfile=chklog(file)
if cfile(0) eq '' then cfile=file

if n_elements(cfile) gt 1 then message,'only single filename allowed'

;-- strip off file  name

break_file, cfile, disk, direc, name, ext, vers
dirnam=disk+direc

cdirnam=chklog(dirnam)
if cdirnam(0) ne '' then dirnam=cdirnam
filnam=name+ext+vers

case 1 of

 (dirnam(0) eq '') and (n_elements(path) eq 0): dpath=cdir

 (dirnam(0) ne '') and (n_elements(path) eq 0): dpath=dirnam

 (dirnam(0) ne '') and (datatype(path) eq 'STR'): dpath=[dirnam,path]

 (dirnam(0) eq '') and (datatype(path) eq 'STR'): dpath=path

 else: message,'do not understand request'
endcase

loc=''  & fname=''
ndir=n_elements(dpath)
ppath=''
for i=0,ndir-1 do begin
 bpath=dpath(i)
 if bpath ne ppath then begin           ;-- avoid searching twice

  if !version.os ne 'vms' then begin
   cpath=chklog(bpath)
   if cpath(0) ne '' then bpath=cpath
  endif

  bname=concat_dir(bpath,filnam)

  if verb then message,'looking for '+bname,/contin

;-- translate logicals in disk and directory names

  cdir=chklog(bpath)
  if cdir(0) eq '' then cdir=bpath 
  break_file,cdir,dsk,dirc
  cdsk=chklog(dsk)
  if cdsk(0) eq '' then cdsk=dsk
  cdir=chklog(dirc)
  if cdir(0) eq '' then cdir=dirc

;-- look for odd characters in dir/file name

  wild=strpos(filnam,'*')
  quest=strpos(filnam,'?')
  ditto1=strpos(cdsk,'...')
  ditto2=strpos(cdir,'...')
  node=strpos(cdsk,'::')
  if (wild eq -1) and (quest eq -1) and (ditto1 eq -1) and (ditto2 eq -1) $
   and (node eq -1) then begin
   chk=test_open(bname)
   if chk then begin count=1 & go_find=bname & endif else count=0
  endif else begin
   if strpos(bpath,'~') gt -1 then chk=test_open(bpath)
   bname=concat_dir(bpath,filnam)
   go_find=findfile(bname,count=count)

;-- kluge for UNIX case where FINDFILE can't expand more than
;   about 310 files

   if (count eq 0) and (strupcase(!version.os) ne 'VMS') then begin
    chk_dir=findfile(bpath,count=nc)
    if nc gt 0 then begin
     cd,current=curr,bpath
     if verb then message,'rechecking...',/cont
     go_find=findfile(filnam,count=count)
     cd,curr
     if count gt 0 then go_find=concat_dir(bpath,go_find)
    endif
   endif
  endelse
  
  if count ne 0 then begin
   if fname(0) eq '' then fname=go_find else fname=[fname,go_find]
   if loc(0) eq '' then loc=bpath else loc=[loc,bpath]
   if not keyword_set(all) then goto,jump
  endif
 endif
 ppath=bpath
endfor

jump: if fname(0) eq '' then count=0 else count=n_elements(fname)
if n_elements(fname) eq 1 then fname=fname(0)

return,fname

end
