;+
; Project     : SOHO - CDS
;
; Name        : MKLOG
;
; Purpose     : define a logical (VMS) or environment (UNIX) variable
;
; Category    : Utility, OS
;
; Explanation : checks OS to determine which SET function to use
;
; Syntax      : IDL> mklog,name,value
;
; Inputs      : name = string name of variable to define logical for
;             : value = string name of logical 
;
; Opt. Inputs : None
;
; Outputs     : None
;
; Opt. Outputs: None
;
; Keywords    : None
;
; Common      : None
;
; Restrictions: None
;
; Side effects: logical will become undefined if name=''
;
; History     : Version 1,  1-Sep-1992,  D.M. Zarro.  Written
;
; Contact     : DZARRO@SOLAR.STANFORD.EDU
;-

pro mklog,name,value

on_error,1

if n_params() lt 2 then message,'enter names to define'
os=strupcase(!version.os) 

case os of
 'VMS'   : begin
            if strtrim(value,2) eq '' then begin
             ok=chklog(name)
             if ok ne '' then dellog,name
            endif  else setlog,name,value
           end
 else    : setenv,strtrim(name,2)+'='+strtrim(value,2)
endcase

return & end
